/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodata.waimak.storage;

import com.coxautodata.waimak.log.Level;
import com.coxautodata.waimak.log.Logging;
import com.coxautodata.waimak.storage.AuditTableFile;
import com.coxautodata.waimak.storage.AuditTableFile$;
import com.coxautodata.waimak.storage.AuditTableInfo;
import com.coxautodata.waimak.storage.AuditTableRegionInfo;
import com.coxautodata.waimak.storage.FileStorageOps;
import com.coxautodata.waimak.storage.StorageException;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

public final class AuditTableFile$
implements Logging {
    public static AuditTableFile$ MODULE$;
    private final String STORE_TYPE_COLUMN;
    private final String STORE_REGION_COLUMN;
    private final String DE_LAST_UPDATED_COLUMN;
    private final String HOT_PARTITION;
    private final String COLD_PARTITION;
    private final String REGION_INFO_DIRECTORY;
    private final Timestamp lowTimestamp;
    private final Timestamp highTimestamp;
    private final Logger com$coxautodata$waimak$log$Logging$$log;

    static {
        new AuditTableFile$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public <A> A logAndReturn(A a, Function1<A, String> message, Level level) {
        return (A)Logging.logAndReturn$((Logging)this, a, message, (Level)level);
    }

    public <A> A logAndReturn(A a, String msg, Level level) {
        return (A)Logging.logAndReturn$((Logging)this, a, (String)msg, (Level)level);
    }

    public Logger com$coxautodata$waimak$log$Logging$$log() {
        return this.com$coxautodata$waimak$log$Logging$$log;
    }

    public final void com$coxautodata$waimak$log$Logging$_setter_$com$coxautodata$waimak$log$Logging$$log_$eq(Logger x$1) {
        this.com$coxautodata$waimak$log$Logging$$log = x$1;
    }

    public String STORE_TYPE_COLUMN() {
        return this.STORE_TYPE_COLUMN;
    }

    public String STORE_REGION_COLUMN() {
        return this.STORE_REGION_COLUMN;
    }

    public String DE_LAST_UPDATED_COLUMN() {
        return this.DE_LAST_UPDATED_COLUMN;
    }

    public String HOT_PARTITION() {
        return this.HOT_PARTITION;
    }

    public String COLD_PARTITION() {
        return this.COLD_PARTITION;
    }

    public String REGION_INFO_DIRECTORY() {
        return this.REGION_INFO_DIRECTORY;
    }

    public Timestamp lowTimestamp() {
        return this.lowTimestamp;
    }

    public Timestamp highTimestamp() {
        return this.highTimestamp;
    }

    public String nextLongRegion(AuditTableFile table) {
        long arg$macro$1 = BoxesRunTime.unboxToLong((Object)table.activeRegionIDs().map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)AuditTableFile$.$anonfun$nextLongRegion$1(x$19))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        return new StringOps("r%020d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)}));
    }

    public AuditTableFile setRegions(AuditTableFile audit, Seq<AuditTableRegionInfo> allRegions, Option<Seq<AuditTableRegionInfo>> appendedRegions) {
        SparkSession spark = audit.storageOps().sparkSession();
        Seq regionsToWrite = (Seq)appendedRegions.getOrElse((Function0 & Serializable & scala.Serializable)() -> allRegions);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_coxautodata_waimak_storage_AuditTableFile$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("com.coxautodata.waimak.storage.AuditTableRegionInfo").asType().toTypeConstructor();
            }

            public Com_coxautodata_waimak_storage_AuditTableFile$$typecreator5$1() {
            }
        }
        Dataset regionInfoDS = audit.storageOps().sparkSession().createDataset(regionsToWrite, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_coxautodata_waimak_storage_AuditTableFile$$typecreator5$1()))).coalesce(1);
        audit.storageOps().writeParquet(audit.tableName(), new Path(audit.regionInfoBasePath(), audit.tableName()), regionInfoDS, appendedRegions.isEmpty(), (Option<String>)new Some((Object)this.REGION_INFO_DIRECTORY()));
        return new AuditTableFile(audit.tableInfo(), allRegions, audit.storageOps(), audit.baseFolder(), audit.newRegionID());
    }

    public void clearTableRegionCache(AuditTableFile audit) {
        Path tableRegionInfoPath = new Path(audit.regionInfoBasePath(), audit.tableName());
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> audit.storageOps().deletePath(tableRegionInfoPath, true)).recover((PartialFunction)new scala.Serializable(audit){
            public static final long serialVersionUID = 0L;
            private final AuditTableFile audit$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new StorageException(new StringBuilder(48).append("Failed to delete region information for table [").append(this.audit$1.tableName()).append("]").toString(), A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.audit$1 = audit$1;
            }
        }).get();
    }

    public Seq<AuditTableRegionInfo> inferRegionsWithStats(SparkSession sparkSession, FileStorageOps fileStorage, Path basePath, Seq<String> tableNames, boolean includeHot, boolean skipRegionInfoCache) {
        Map allCacheInfo = skipRegionInfoCache ? Predef$.MODULE$.Map().empty() : ((TraversableOnce)this.inferRegionsFromCache(fileStorage, basePath, tableNames, includeHot).map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)t.table_name(), (Object)t.store_type(), (Object)t.store_region())), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map allPathInfo = ((TraversableOnce)this.inferRegionsFromPaths(fileStorage, basePath, tableNames, includeHot).map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)t.table_name(), (Object)t.store_type(), (Object)t.store_region())), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq<AuditTableRegionInfo> validCacheInfo = this.calculateValidCacheInfo((Map<Tuple3<String, String, String>, AuditTableRegionInfo>)allCacheInfo, (Map<Tuple3<String, String, String>, AuditTableRegionInfo>)allPathInfo);
        Set validCachedTables = ((TraversableOnce)validCacheInfo.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.table_name(), Seq$.MODULE$.canBuildFrom())).toSet();
        Seq tablesMissingFromCache = tableNames.toSet().diff((GenSet)validCachedTables).toSeq();
        Map fromPaths = allPathInfo.filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)tablesMissingFromCache.contains(k._1())));
        Map fromParquet = ((TraversableOnce)this.inferRegionsFromParquet(sparkSession, fileStorage, basePath, (Seq<String>)tablesMissingFromCache, includeHot).map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)t.table_name(), (Object)t.store_type(), (Object)t.store_region())), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return (Seq)((TraversableLike)fromPaths.keySet().$plus$plus((GenTraversableOnce)fromParquet.keySet()).toSeq().map((Function1 & Serializable & scala.Serializable)k -> (AuditTableRegionInfo)fromParquet.getOrElse(k, (Function0 & Serializable & scala.Serializable)() -> (AuditTableRegionInfo)fromPaths.apply(k)), Seq$.MODULE$.canBuildFrom())).$plus$plus(validCacheInfo, Seq$.MODULE$.canBuildFrom());
    }

    public boolean inferRegionsWithStats$default$5() {
        return true;
    }

    public boolean inferRegionsWithStats$default$6() {
        return false;
    }

    public Seq<AuditTableRegionInfo> calculateValidCacheInfo(Map<Tuple3<String, String, String>, AuditTableRegionInfo> allCacheInfo, Map<Tuple3<String, String, String>, AuditTableRegionInfo> allPathInfo) {
        Map cacheInfoByTable = allCacheInfo.keySet().groupBy((Function1 & Serializable & scala.Serializable)x$21 -> (String)x$21._1());
        Map pathInfoByTable = allPathInfo.keySet().groupBy((Function1 & Serializable & scala.Serializable)x$22 -> (String)x$22._1());
        Set validCachedTables = ((MapLike)cacheInfoByTable.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AuditTableFile$.$anonfun$calculateValidCacheInfo$3(pathInfoByTable, x0$1)))).keySet();
        Seq validCacheInfo = allCacheInfo.filterKeys((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)validCachedTables.contains(t._1()))).values().toSeq();
        cacheInfoByTable.keySet().diff((GenSet)validCachedTables).reduceLeftOption((Function2 & Serializable & scala.Serializable)(z, t) -> new StringBuilder(2).append((String)z).append(", ").append((String)t).toString()).foreach((Function1 & Serializable & scala.Serializable)t -> {
            AuditTableFile$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(213).append("The cached region information for the following tables looks invalid, it does not match the found partition folders. ").append("The cached region information for these tables will be ignored, this will affect performance: [").append(t).append("]").toString());
            return BoxedUnit.UNIT;
        });
        return validCacheInfo;
    }

    public Seq<AuditTableRegionInfo> inferRegionsFromCache(FileStorageOps fileStorage, Path basePath, Seq<String> tableNames, boolean includeHot) {
        scala.Serializable parFun = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.isDirectory()) {
                    return (B1)A1.getPath();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                FileStatus fileStatus = x1;
                return fileStatus.isDirectory();
            }
        };
        List presentTables = fileStorage.globTablePaths(new Path(basePath, this.REGION_INFO_DIRECTORY()), tableNames, (Seq<String>)((Seq)Nil$.MODULE$), parFun, ClassTag$.MODULE$.apply(Path.class)).toList();
        List list = presentTables;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Path h = (Path)colon2.head();
            List tail = colon2.tl$access$1();
            SparkSession spark = fileStorage.sparkSession();
            Option cache = fileStorage.openParquet(h, (Seq<Path>)tail).map((Function1 & Serializable & scala.Serializable)x$23 -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                public final class Com_coxautodata_waimak_storage_AuditTableFile$$typecreator5$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("com.coxautodata.waimak.storage.AuditTableRegionInfo").asType().toTypeConstructor();
                    }

                    public Com_coxautodata_waimak_storage_AuditTableFile$$typecreator5$2() {
                    }
                }
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$23.as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_coxautodata_waimak_storage_AuditTableFile$$typecreator5$2()))).filter((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)AuditTableFile$.$anonfun$inferRegionsFromCache$2(includeHot, x$24))).collect())).toSeq();
            });
            return (Seq)cache.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(126).append("Unable to read region cache info for tables: [").append(((TraversableOnce)presentTables.map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.getName(), List$.MODULE$.canBuildFrom())).mkString(", ")).append("]. ").append("Defaulting to reading from file and/or parquet; this will affect performance.").toString());
                return (Seq)Nil$.MODULE$;
            });
        }
        if (Nil$.MODULE$.equals(list)) {
            return (Seq)Nil$.MODULE$;
        }
        throw new MatchError((Object)list);
    }

    private Seq<AuditTableRegionInfo> inferRegionsFromParquet(SparkSession sparkSession, FileStorageOps fileStorage, Path basePath, Seq<String> tableNames, boolean includeHot) {
        SparkSession spark = sparkSession;
        Seq regions = tableNames.iterator().grouped(20).flatMap((Function1 & Serializable & scala.Serializable)page -> {
            Seq pageDFs = (Seq)((TraversableLike)((TraversableLike)page.map((Function1 & Serializable & scala.Serializable)table -> {
                Option<Dataset<?>> data = fileStorage.openParquet(new Path(basePath, table), (Seq<Path>)Predef$.MODULE$.wrapRefArray((Object[])new Path[0]));
                return data.map((Function1 & Serializable & scala.Serializable)df -> {
                    if (includeHot) {
                        return df.filter(df.apply(MODULE$.STORE_TYPE_COLUMN()).isin((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.HOT_PARTITION(), MODULE$.COLD_PARTITION()})));
                    }
                    return df.filter(df.apply(MODULE$.STORE_TYPE_COLUMN()).isin((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.COLD_PARTITION()})));
                }).map((Function1 & Serializable & scala.Serializable)df -> df.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply(MODULE$.STORE_TYPE_COLUMN()), df.apply(MODULE$.STORE_REGION_COLUMN())})).agg(functions$.MODULE$.count(df.apply(MODULE$.DE_LAST_UPDATED_COLUMN())).as("count"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(df.apply(MODULE$.DE_LAST_UPDATED_COLUMN())).as("max_last_updated")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit(table).as("table_name"), df.apply(MODULE$.STORE_TYPE_COLUMN()).as("store_type"), df.apply(MODULE$.STORE_REGION_COLUMN()).as("store_region"), functions$.MODULE$.lit((Object)MODULE$.lowTimestamp()).as("created_on"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)false)).as("is_deprecated"), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max_last_updated"}))).$((Seq)Nil$.MODULE$)})));
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)x$26.isDefined()))).map((Function1 & Serializable & scala.Serializable)x$27 -> (Dataset)x$27.get(), Seq$.MODULE$.canBuildFrom());
            if (pageDFs.isEmpty()) {
                return (SeqLike)Nil$.MODULE$;
            }
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Com_coxautodata_waimak_storage_AuditTableFile$$typecreator5$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("com.coxautodata.waimak.storage.AuditTableRegionInfo").asType().toTypeConstructor();
                }

                public Com_coxautodata_waimak_storage_AuditTableFile$$typecreator5$3() {
                }
            }
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)pageDFs.reduce((Function2 & Serializable & scala.Serializable)(x$28, x$29) -> x$28.union(x$29))).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_coxautodata_waimak_storage_AuditTableFile$$typecreator5$3()))).collect()));
        }).toSeq();
        return regions;
    }

    public Seq<AuditTableRegionInfo> inferRegionsFromPaths(FileStorageOps fileStorage, Path basePath, Seq<String> tableNames, boolean includeHot) {
        scala.Serializable parFun = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.isDirectory()) {
                    Path path = A1.getPath();
                    return (B1)new AuditTableRegionInfo(path.getParent().getParent().getName(), new StringOps(Predef$.MODULE$.augmentString(path.getParent().getName())).split('=')[1], new StringOps(Predef$.MODULE$.augmentString(path.getName())).split('=')[1], AuditTableFile$.MODULE$.lowTimestamp(), false, 0L, AuditTableFile$.MODULE$.lowTimestamp());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                FileStatus fileStatus = x1;
                return fileStatus.isDirectory();
            }
        };
        return fileStorage.globTablePaths(basePath, tableNames, (Seq<String>)((Seq)new .colon.colon((Object)new StringBuilder(1).append(this.STORE_TYPE_COLUMN()).append("=").append((Object)(includeHot ? "*" : this.COLD_PARTITION())).toString(), (List)new .colon.colon((Object)new StringBuilder(2).append(this.STORE_REGION_COLUMN()).append("=*").toString(), (List)Nil$.MODULE$))), parFun, ClassTag$.MODULE$.apply(AuditTableRegionInfo.class));
    }

    public Tuple2<Map<String, Try<AuditTableFile>>, Seq<String>> openTables(SparkSession sparkSession, FileStorageOps fileStorage, Path basePath, Seq<String> tableNames, boolean includeHot, Function1<AuditTableFile, String> newRegionID) {
        Set existingTables = fileStorage.listTables(basePath).toSet();
        Tuple2 tuple2 = tableNames.partition((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)existingTables.contains((Object)elem)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq exist = (Seq)tuple2._1();
        Seq not = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)exist, (Object)not);
        Seq exist2 = (Seq)tuple22._1();
        Seq not2 = (Seq)tuple22._2();
        Map tableRegions = this.inferRegionsWithStats(sparkSession, fileStorage, basePath, (Seq<String>)exist2, includeHot, this.inferRegionsWithStats$default$6()).groupBy((Function1 & Serializable & scala.Serializable)x$31 -> x$31.table_name());
        Map tablesObjs = (Map)exist2.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(res, tableName) -> {
            Try<AuditTableInfo> info = fileStorage.readAuditTableInfo(basePath, (String)tableName);
            Seq regions = (Seq)tableRegions.getOrElse(tableName, (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
            return res.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tableName), (Object)info.map((Function1 & Serializable & scala.Serializable)i -> new AuditTableFile((AuditTableInfo)i, (Seq<AuditTableRegionInfo>)regions, fileStorage, basePath, newRegionID))));
        });
        return new Tuple2((Object)tablesObjs, (Object)not2);
    }

    public boolean openTables$default$5() {
        return true;
    }

    public Try<AuditTableFile> createTable(SparkSession sparkSession, FileStorageOps fileStorage, Path basePath, AuditTableInfo tableInfo, Function1<AuditTableFile, String> newRegionID) {
        AuditTableFile table = new AuditTableFile(tableInfo, (Seq<AuditTableRegionInfo>)((Seq)Nil$.MODULE$), fileStorage, basePath, newRegionID);
        return table.initNewTable();
    }

    public static final /* synthetic */ long $anonfun$nextLongRegion$1(Seq x$19) {
        return new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)x$19.max((Ordering)Ordering.String$.MODULE$))).drop(1))).toLong() + 1L;
    }

    public static final /* synthetic */ boolean $anonfun$calculateValidCacheInfo$3(Map pathInfoByTable$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String t = (String)tuple2._1();
            Set r = (Set)tuple2._2();
            return pathInfoByTable$1.get((Object)t).contains((Object)r);
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$inferRegionsFromCache$2(boolean includeHot$1, AuditTableRegionInfo x$24) {
        if (includeHot$1) return true;
        String string = x$24.store_type();
        String string2 = MODULE$.HOT_PARTITION();
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    private AuditTableFile$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.STORE_TYPE_COLUMN = "de_store_type";
        this.STORE_REGION_COLUMN = "de_store_region";
        this.DE_LAST_UPDATED_COLUMN = "_de_last_updated";
        this.HOT_PARTITION = "hot";
        this.COLD_PARTITION = "cold";
        this.REGION_INFO_DIRECTORY = ".regioninfo";
        this.lowTimestamp = Timestamp.valueOf("0001-01-01 00:00:00");
        this.highTimestamp = Timestamp.valueOf("9999-12-31 23:59:59");
    }
}

