/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodata.waimak.storage;

import com.coxautodata.waimak.log.Level;
import com.coxautodata.waimak.log.Logging;
import com.coxautodata.waimak.storage.AuditTable;
import com.coxautodata.waimak.storage.AuditTableFile$;
import com.coxautodata.waimak.storage.AuditTableInfo;
import com.coxautodata.waimak.storage.AuditTableRegionInfo;
import com.coxautodata.waimak.storage.FileStorageOps;
import com.coxautodata.waimak.storage.StorageException;
import com.coxautodata.waimak.storage.StorageException$;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Duration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.Window$;
import org.apache.spark.sql.expressions.WindowSpec;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r}f\u0001B%K\u0001MC\u0001\u0002\u001a\u0001\u0003\u0006\u0004%\t!\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005M\"A!\u000e\u0001BC\u0002\u0013\u00053\u000e\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003m\u0011!a\bA!b\u0001\n\u0003i\b\"CA\u0002\u0001\t\u0005\t\u0015!\u0003\u007f\u0011)\t)\u0001\u0001BC\u0002\u0013\u0005\u0011q\u0001\u0005\u000b\u0003C\u0001!\u0011!Q\u0001\n\u0005%\u0001BCA\u0012\u0001\t\u0015\r\u0011\"\u0001\u0002&!Q\u0011q\b\u0001\u0003\u0002\u0003\u0006I!a\n\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!I\u0011q\n\u0001A\u0002\u0013E\u0011\u0011\u000b\u0005\n\u00033\u0002\u0001\u0019!C\t\u00037B\u0001\"a\u001a\u0001A\u0003&\u00111\u000b\u0005\u000b\u0003S\u0002!\u0019!C\t\u0015\u0006\u001d\u0001\u0002CA6\u0001\u0001\u0006I!!\u0003\t\u0015\u00055\u0004A1A\u0005\u0012)\u000b9\u0001\u0003\u0005\u0002p\u0001\u0001\u000b\u0011BA\u0005\u0011%\t\t\b\u0001b\u0001\n#\t9\u0001\u0003\u0005\u0002t\u0001\u0001\u000b\u0011BA\u0005\u0011%\t)\b\u0001b\u0001\n#\t9\u0001\u0003\u0005\u0002x\u0001\u0001\u000b\u0011BA\u0005\u0011%\tI\b\u0001b\u0001\n#\t9\u0001\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA\u0005\u0011\u001d\ti\b\u0001C!\u0003\u007fBq!a\"\u0001\t\u0003\nI\tC\u0004\u0002\f\u0002!\t%!$\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u0011\u0011 \u0001\u0005B\u0005m\bb\u0002B\u0007\u0001\u0011\u0005!q\u0002\u0005\b\u0005O\u0001A\u0011\tB\u0015\u0011\u001d\u0011Y\u0007\u0001C!\u0005[BqAa\u001d\u0001\t\u0003\u0012)\bC\u0004\u0003z\u0001!\tEa\u001f\t\u000f\tE\u0005\u0001\"\u0001\u0003\u0014\"9!\u0011\u0014\u0001\u0005\u0012\tm\u0005b\u0002BQ\u0001\u0011E!1\u0015\u0005\b\u0005_\u0003A\u0011\u0003BY\u0011\u001d\u0011\t\r\u0001C\t\u0005\u0007<qA!2K\u0011\u0003\u00119M\u0002\u0004J\u0015\"\u0005!\u0011\u001a\u0005\b\u0003\u0003JC\u0011\u0001Bf\u0011%\u0011i-\u000bb\u0001\n\u0003\u0011y\r\u0003\u0005\u0003\\&\u0002\u000b\u0011\u0002Bi\u0011%\u0011i.\u000bb\u0001\n\u0003\u0011y\r\u0003\u0005\u0003`&\u0002\u000b\u0011\u0002Bi\u0011%\u0011\t/\u000bb\u0001\n\u0003\u0011y\r\u0003\u0005\u0003d&\u0002\u000b\u0011\u0002Bi\u0011%\u0011)/\u000bb\u0001\n\u0003\u0011y\r\u0003\u0005\u0003h&\u0002\u000b\u0011\u0002Bi\u0011%\u0011I/\u000bb\u0001\n\u0003\u0011y\r\u0003\u0005\u0003l&\u0002\u000b\u0011\u0002Bi\u0011%\u0011i/\u000bb\u0001\n\u0003\u0011y\r\u0003\u0005\u0003p&\u0002\u000b\u0011\u0002Bi\u0011%\u0011\t0\u000bb\u0001\n\u0003\u0011\u0019\u0010\u0003\u0005\u0003v&\u0002\u000b\u0011BAK\u0011%\u001190\u000bb\u0001\n\u0003\u0011\u0019\u0010\u0003\u0005\u0003z&\u0002\u000b\u0011BAK\u0011\u001d\u0011Y0\u000bC\u0001\u0005{Dqaa\u0001*\t\u0003\u0019)\u0001C\u0004\u0004\u0016%\"\taa\u0006\t\u000f\rm\u0011\u0006\"\u0001\u0004\u001e!I1QH\u0015\u0012\u0002\u0013\u00051q\b\u0005\n\u0007+J\u0013\u0013!C\u0001\u0007\u007f)aaa\u0016*\u0001\re\u0003\u0002CB1S\u0011\u0005!ja\u0019\t\u0011\rE\u0014\u0006\"\u0001K\u0007gBqa! *\t\u0013\u0019y\b\u0003\u0005\u0004\f&\"\tASBG\u0011\u001d\u00199*\u000bC\u0001\u00073C\u0011b!,*#\u0003%\taa\u0010\t\u000f\r=\u0016\u0006\"\u0001\u00042\nq\u0011)\u001e3jiR\u000b'\r\\3GS2,'BA&M\u0003\u001d\u0019Ho\u001c:bO\u0016T!!\u0014(\u0002\r]\f\u0017.\\1l\u0015\ty\u0005+A\u0006d_b\fW\u000f^8eCR\f'\"A)\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001!&L\u0018\t\u0003+bk\u0011A\u0016\u0006\u0002/\u0006)1oY1mC&\u0011\u0011L\u0016\u0002\u0007\u0003:L(+\u001a4\u0011\u0005mcV\"\u0001&\n\u0005uS%AC!vI&$H+\u00192mKB\u0011qLY\u0007\u0002A*\u0011\u0011\rT\u0001\u0004Y><\u0017BA2a\u0005\u001daunZ4j]\u001e\f\u0011\u0002^1cY\u0016LeNZ8\u0016\u0003\u0019\u0004\"aW4\n\u0005!T%AD!vI&$H+\u00192mK&sgm\\\u0001\u000bi\u0006\u0014G.Z%oM>\u0004\u0013a\u0002:fO&|gn]\u000b\u0002YB\u0019Q.\u001e=\u000f\u00059\u001chBA8s\u001b\u0005\u0001(BA9S\u0003\u0019a$o\\8u}%\tq+\u0003\u0002u-\u00069\u0001/Y2lC\u001e,\u0017B\u0001<x\u0005\r\u0019V-\u001d\u0006\u0003iZ\u0003\"aW=\n\u0005iT%\u0001F!vI&$H+\u00192mKJ+w-[8o\u0013:4w.\u0001\u0005sK\u001eLwN\\:!\u0003)\u0019Ho\u001c:bO\u0016|\u0005o]\u000b\u0002}B\u00111l`\u0005\u0004\u0003\u0003Q%A\u0004$jY\u0016\u001cFo\u001c:bO\u0016|\u0005o]\u0001\fgR|'/Y4f\u001fB\u001c\b%\u0001\u0006cCN,gi\u001c7eKJ,\"!!\u0003\u0011\t\u0005-\u0011QD\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005\u0011am\u001d\u0006\u0005\u0003'\t)\"\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0005\u0003/\tI\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u00037\t1a\u001c:h\u0013\u0011\ty\"!\u0004\u0003\tA\u000bG\u000f[\u0001\fE\u0006\u001cXMR8mI\u0016\u0014\b%A\u0006oK^\u0014VmZ5p]&#UCAA\u0014!\u001d)\u0016\u0011FA\u0017\u0003_I1!a\u000bW\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002\\\u0001A!\u0011\u0011GA\u001d\u001d\u0011\t\u0019$!\u000e\u0011\u0005=4\u0016bAA\u001c-\u00061\u0001K]3eK\u001aLA!a\u000f\u0002>\t11\u000b\u001e:j]\u001eT1!a\u000eW\u00031qWm\u001e*fO&|g.\u0013#!\u0003\u0019a\u0014N\\5u}Qa\u0011QFA#\u0003\u000f\nI%a\u0013\u0002N!)Am\u0003a\u0001M\")!n\u0003a\u0001Y\")Ap\u0003a\u0001}\"9\u0011QA\u0006A\u0002\u0005%\u0001bBA\u0012\u0017\u0001\u0007\u0011qE\u0001\fo\u0006\u001cXj\u001c3jM&,G-\u0006\u0002\u0002TA\u0019Q+!\u0016\n\u0007\u0005]cKA\u0004C_>dW-\u00198\u0002\u001f]\f7/T8eS\u001aLW\rZ0%KF$B!!\u0018\u0002dA\u0019Q+a\u0018\n\u0007\u0005\u0005dK\u0001\u0003V]&$\b\"CA3\u001b\u0005\u0005\t\u0019AA*\u0003\rAH%M\u0001\ro\u0006\u001cXj\u001c3jM&,G\rI\u0001\ni\u0006\u0014G.\u001a)bi\"\f!\u0002^1cY\u0016\u0004\u0016\r\u001e5!\u0003I\u0011XmZ5p]&sgm\u001c\"bg\u0016\u0004\u0016\r\u001e5\u0002'I,w-[8o\u0013:4wNQ1tKB\u000bG\u000f\u001b\u0011\u0002\u0011\r|G\u000e\u001a)bi\"\f\u0011bY8mIB\u000bG\u000f\u001b\u0011\u0002\u000f!|G\u000fU1uQ\u0006A\u0001n\u001c;QCRD\u0007%\u0001\u0007nKR\f')Y:f!\u0006$\b.A\u0007nKR\f')Y:f!\u0006$\b\u000eI\u0001\u0005[\u0016$\u0018-\u0006\u0002\u0002\u0002BA\u0011\u0011GAB\u0003_\ty#\u0003\u0003\u0002\u0006\u0006u\"aA'ba\u0006IA/\u00192mK:\u000bW.Z\u000b\u0003\u0003_\t!cZ3u\u0019\u0006$Xm\u001d;US6,7\u000f^1naR\u0011\u0011q\u0012\t\u0006+\u0006E\u0015QS\u0005\u0004\u0003'3&AB(qi&|g\u000e\u0005\u0003\u0002\u0018\u0006\u0005VBAAM\u0015\u0011\tY*!(\u0002\u0007M\fHN\u0003\u0002\u0002 \u0006!!.\u0019<b\u0013\u0011\t\u0019+!'\u0003\u0013QKW.Z:uC6\u0004\u0018AB1qa\u0016tG\r\u0006\u0005\u0002*\u0006\u0005\u00171^A{!\u0019\tY+!-\u000266\u0011\u0011Q\u0016\u0006\u0004\u0003_3\u0016\u0001B;uS2LA!a-\u0002.\n\u0019AK]=\u0011\rU\u000b9LWA^\u0013\r\tIL\u0016\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007U\u000bi,C\u0002\u0002@Z\u0013A\u0001T8oO\"9\u00111\u0019\u000fA\u0002\u0005\u0015\u0017A\u00013ta\u0011\t9-!7\u0011\r\u0005%\u0017\u0011[Ak\u001b\t\tYM\u0003\u0003\u0002\u001c\u00065'\u0002BAh\u0003+\tQa\u001d9be.LA!a5\u0002L\n9A)\u0019;bg\u0016$\b\u0003BAl\u00033d\u0001\u0001\u0002\u0007\u0002\\\u0006\u0005\u0017\u0011!A\u0001\u0006\u0003\tiNA\u0002`IE\nB!a8\u0002fB\u0019Q+!9\n\u0007\u0005\rhKA\u0004O_RD\u0017N\\4\u0011\u0007U\u000b9/C\u0002\u0002jZ\u00131!\u00118z\u0011\u001d\ti\u000f\ba\u0001\u0003_\f1\u0002\\1tiV\u0003H-\u0019;fIB!\u0011\u0011ZAy\u0013\u0011\t\u00190a3\u0003\r\r{G.^7o\u0011\u001d\t9\u0010\ba\u0001\u0003+\u000b\u0001\"\u00199qK:$GkU\u0001\tg:\f\u0007o\u001d5piR!\u0011Q B\u0005!\u0015)\u0016\u0011SA\u0000a\u0011\u0011\tA!\u0002\u0011\r\u0005%\u0017\u0011\u001bB\u0002!\u0011\t9N!\u0002\u0005\u0017\t\u001dQ$!A\u0001\u0002\u000b\u0005\u0011Q\u001c\u0002\u0004?\u0012\u0012\u0004b\u0002B\u0006;\u0001\u0007\u0011QS\u0001\u0003iN\f1\u0002Z3ekBd\u0017nY1uKR!!\u0011\u0003B\u000ea\u0011\u0011\u0019Ba\u0006\u0011\r\u0005%\u0017\u0011\u001bB\u000b!\u0011\t9Na\u0006\u0005\u0017\tea$!A\u0001\u0002\u000b\u0005\u0011Q\u001c\u0002\u0004?\u0012\"\u0004bBAb=\u0001\u0007!Q\u0004\u0019\u0005\u0005?\u0011\u0019\u0003\u0005\u0004\u0002J\u0006E'\u0011\u0005\t\u0005\u0003/\u0014\u0019\u0003\u0002\u0007\u0003&\tm\u0011\u0011!A\u0001\u0006\u0003\tiNA\u0002`IM\nqaY8na\u0006\u001cG\u000f\u0006\u0007\u0003,\t5\"\u0011\u0007B!\u0005\u000b\u00129\u0007E\u0003\u0002,\u0006E&\fC\u0004\u00030}\u0001\r!!&\u0002\u0013\r|W\u000e]1diR\u001b\u0006b\u0002B\u001a?\u0001\u0007!QG\u0001\fiJ\f7\u000f['bq\u0006;W\r\u0005\u0003\u00038\tuRB\u0001B\u001d\u0015\u0011\u0011Y$!(\u0002\tQLW.Z\u0005\u0005\u0005\u007f\u0011ID\u0001\u0005EkJ\fG/[8o\u0011\u001d\u0011\u0019e\ba\u0001\u0003w\u000bqc]7bY2\u0014VmZ5p]J{w\u000f\u00165sKNDw\u000e\u001c3\t\u000f\t\u001ds\u00041\u0001\u0003J\u0005)2m\\7qC\u000e$\u0018n\u001c8QCJ$\u0018\u000e^5p]\u0016\u0014\b\u0003\u0002B&\u0005CrAA!\u0014\u0003^9!!q\nB.\u001d\u0011\u0011\tF!\u0017\u000f\t\tM#q\u000b\b\u0004_\nU\u0013\"A)\n\u0005=\u0003\u0016BA'O\u0013\tYE*C\u0002\u0003`)\u000b!\"Q;eSR$\u0016M\u00197f\u0013\u0011\u0011\u0019G!\u001a\u0003+\r{W\u000e]1di&|g\u000eU1si&$\u0018n\u001c8fe*\u0019!q\f&\t\u0013\t%t\u0004%AA\u0002\u0005M\u0013\u0001\u0004:fG>l\u0007/Y2u\u00032d\u0017\u0001D5oSRtUm\u001e+bE2,GC\u0001B8!\u0019\tY+!-\u0003r5\t\u0001!A\bva\u0012\fG/\u001a+bE2,\u0017J\u001c4p)\u0011\u0011YCa\u001e\t\u000b\u0011\f\u0003\u0019\u00014\u0002\u0015\u0005dGNQ3uo\u0016,g\u000e\u0006\u0004\u0003~\t%%Q\u0012\t\u0006+\u0006E%q\u0010\u0019\u0005\u0005\u0003\u0013)\t\u0005\u0004\u0002J\u0006E'1\u0011\t\u0005\u0003/\u0014)\tB\u0006\u0003\b\n\n\t\u0011!A\u0003\u0002\u0005u'aA0%k!9!1\u0012\u0012A\u0002\u0005=\u0015\u0001\u00024s_6DqAa$#\u0001\u0004\ty)\u0001\u0002u_\u0006y\u0011m\u0019;jm\u0016\u0014VmZ5p]&#5\u000f\u0006\u0002\u0003\u0016B)Q+!%\u0003\u0018B!Q.^A\u0018\u0003A\u0011XmZ5p]N$vnQ8na\u0006\u001cG\u000fF\u0003m\u0005;\u0013y\nC\u0004\u0003D\u0011\u0002\r!a/\t\u000f\t%D\u00051\u0001\u0002T\u0005q1m\\7qC\u000e$(+Z4j_:\u001cH\u0003\u0003BS\u0005O\u0013YK!,\u0011\r\u0005-\u0016\u0011WA\u0017\u0011\u0019\u0011I+\na\u0001Y\u0006IAo\\\"p[B\f7\r\u001e\u0005\b\u0005_)\u0003\u0019AAK\u0011\u001d\u00119%\na\u0001\u0005\u0013\nqbY1mGJ+w-[8o'R\fGo\u001d\u000b\u0005\u0005g\u0013)\fE\u0004V\u0003o\u000bY,!&\t\u000f\u0005\rg\u00051\u0001\u00038B\"!\u0011\u0018B_!\u0019\tI-!5\u0003<B!\u0011q\u001bB_\t1\u0011yL!.\u0002\u0002\u0003\u0005)\u0011AAo\u0005\ryFEN\u0001\r[\u0006\u00148\u000eV8Va\u0012\fG/\u001a\u000b\u0003\u0003;\na\"Q;eSR$\u0016M\u00197f\r&dW\r\u0005\u0002\\SM\u0019\u0011\u0006\u00160\u0015\u0005\t\u001d\u0017!E*U\u001fJ+u\fV-Q\u000b~\u001bu\nT+N\u001dV\u0011!\u0011\u001b\t\u0005\u0005'\u0014I.\u0004\u0002\u0003V*!!q[AO\u0003\u0011a\u0017M\\4\n\t\u0005m\"Q[\u0001\u0013'R{%+R0U3B+ulQ(M+6s\u0005%A\nT)>\u0013Vi\u0018*F\u000f&{ejX\"P\u0019Vke*\u0001\u000bT)>\u0013Vi\u0018*F\u000f&{ejX\"P\u0019Vke\nI\u0001\u0017\t\u0016{F*Q*U?V\u0003F)\u0011+F\t~\u001bu\nT+N\u001d\u00069B)R0M\u0003N#v,\u0016)E\u0003R+EiX\"P\u0019Vke\nI\u0001\u000e\u0011>#v\fU!S)&#\u0016j\u0014(\u0002\u001d!{Ek\u0018)B%RKE+S(OA\u0005q1i\u0014'E?B\u000b%\u000bV%U\u0013>s\u0015aD\"P\u0019\u0012{\u0006+\u0011*U\u0013RKuJ\u0014\u0011\u0002+I+u)S(O?&seiT0E\u0013J+5\tV(S3\u00061\"+R$J\u001f:{\u0016J\u0014$P?\u0012K%+R\"U\u001fJK\u0006%\u0001\u0007m_^$\u0016.\\3ti\u0006l\u0007/\u0006\u0002\u0002\u0016\u0006iAn\\<US6,7\u000f^1na\u0002\nQ\u0002[5hQRKW.Z:uC6\u0004\u0018A\u00045jO\"$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\u000f]\u0016DH\u000fT8oOJ+w-[8o)\u0011\tyCa@\t\u000f\r\u00051\b1\u0001\u0002.\u0005)A/\u00192mK\u0006Q1/\u001a;SK\u001eLwN\\:\u0015\u0011\u000552qAB\u0006\u0007\u001fAqa!\u0003=\u0001\u0004\ti#A\u0003bk\u0012LG\u000f\u0003\u0004\u0004\u000eq\u0002\r\u0001\\\u0001\u000bC2d'+Z4j_:\u001c\bbBB\ty\u0001\u000711C\u0001\u0010CB\u0004XM\u001c3fIJ+w-[8ogB!Q+!%m\u0003U\u0019G.Z1s)\u0006\u0014G.\u001a*fO&|gnQ1dQ\u0016$B!!\u0018\u0004\u001a!91\u0011B\u001fA\u0002\u00055\u0012!F5oM\u0016\u0014(+Z4j_:\u001cx+\u001b;i'R\fGo\u001d\u000b\u000eY\u000e}1\u0011FB\u0017\u0007c\u0019)d!\u000f\t\u000f\r\u0005b\b1\u0001\u0004$\u0005a1\u000f]1sWN+7o]5p]B!\u0011\u0011ZB\u0013\u0013\u0011\u00199#a3\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\r\r-b\b1\u0001\u007f\u0003-1\u0017\u000e\\3Ti>\u0014\u0018mZ3\t\u000f\r=b\b1\u0001\u0002\n\u0005A!-Y:f!\u0006$\b\u000eC\u0004\u00044y\u0002\rAa&\u0002\u0015Q\f'\r\\3OC6,7\u000fC\u0005\u00048y\u0002\n\u00111\u0001\u0002T\u0005Q\u0011N\\2mk\u0012,\u0007j\u001c;\t\u0013\rmb\b%AA\u0002\u0005M\u0013aE:lSB\u0014VmZ5p]&sgm\\\"bG\",\u0017aH5oM\u0016\u0014(+Z4j_:\u001cx+\u001b;i'R\fGo\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u00111\u0011\t\u0016\u0005\u0003'\u001a\u0019e\u000b\u0002\u0004FA!1qIB)\u001b\t\u0019IE\u0003\u0003\u0004L\r5\u0013!C;oG\",7m[3e\u0015\r\u0019yEV\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB*\u0007\u0013\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003}IgNZ3s%\u0016<\u0017n\u001c8t/&$\bn\u0015;biN$C-\u001a4bk2$HE\u000e\u0002\n%\u0016<\u0017n\u001c8NCB\u0004r!!\r\u0002\u0004\u000em\u0003\u0010E\u0005V\u0007;\ny#a\f\u00020%\u00191q\f,\u0003\rQ+\b\u000f\\34\u0003]\u0019\u0017\r\\2vY\u0006$XMV1mS\u0012\u001c\u0015m\u00195f\u0013:4w\u000eF\u0003m\u0007K\u001ai\u0007C\u0004\u0004h\t\u0003\ra!\u001b\u0002\u0019\u0005dGnQ1dQ\u0016LeNZ8\u0011\u0007\r-\u0014)D\u0001*\u0011\u001d\u0019yG\u0011a\u0001\u0007S\n1\"\u00197m!\u0006$\b.\u00138g_\u0006)\u0012N\u001c4feJ+w-[8og\u001a\u0013x.\\\"bG\",G#\u00037\u0004v\r]4\u0011PB>\u0011\u0019\u0019Yc\u0011a\u0001}\"91qF\"A\u0002\u0005%\u0001bBB\u001a\u0007\u0002\u0007!q\u0013\u0005\b\u0007o\u0019\u0005\u0019AA*\u0003]IgNZ3s%\u0016<\u0017n\u001c8t\rJ|W\u000eU1scV,G\u000fF\u0006m\u0007\u0003\u001b\u0019i!\"\u0004\b\u000e%\u0005bBB\u0011\t\u0002\u000711\u0005\u0005\u0007\u0007W!\u0005\u0019\u0001@\t\u000f\r=B\t1\u0001\u0002\n!911\u0007#A\u0002\t]\u0005bBB\u001c\t\u0002\u0007\u00111K\u0001\u0016S:4WM\u001d*fO&|gn\u001d$s_6\u0004\u0016\r\u001e5t)%a7qRBI\u0007'\u001b)\n\u0003\u0004\u0004,\u0015\u0003\rA \u0005\b\u0007_)\u0005\u0019AA\u0005\u0011\u001d\u0019\u0019$\u0012a\u0001\u0005/Cqaa\u000eF\u0001\u0004\t\u0019&\u0001\u0006pa\u0016tG+\u00192mKN$Bba'\u0004$\u000e\u00156qUBU\u0007W#Ba!(\u0004\"B9Q+a.\u0004 \n]\u0005\u0003CA\u0019\u0003\u0007\u000byC!*\t\u000f\u0005\rb\t1\u0001\u0002(!91\u0011\u0005$A\u0002\r\r\u0002BBB\u0016\r\u0002\u0007a\u0010C\u0004\u00040\u0019\u0003\r!!\u0003\t\u000f\rMb\t1\u0001\u0003\u0018\"I1q\u0007$\u0011\u0002\u0003\u0007\u00111K\u0001\u0015_B,g\u000eV1cY\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u000b\u0007g\u001b9l!/\u0004<\u000euF\u0003\u0002BS\u0007kCq!a\tI\u0001\u0004\t9\u0003C\u0004\u0004\"!\u0003\raa\t\t\r\r-\u0002\n1\u0001\u007f\u0011\u001d\u0019y\u0003\u0013a\u0001\u0003\u0013AQ\u0001\u001a%A\u0002\u0019\u0004")
public class AuditTableFile
implements AuditTable,
Logging {
    private final AuditTableInfo tableInfo;
    private final Seq<AuditTableRegionInfo> regions;
    private final FileStorageOps storageOps;
    private final Path baseFolder;
    private final Function1<AuditTableFile, String> newRegionID;
    private boolean wasModified;
    private final Path tablePath;
    private final Path regionInfoBasePath;
    private final Path coldPath;
    private final Path hotPath;
    private final Path metaBasePath;
    private final Logger com$coxautodata$waimak$log$Logging$$log;

    public static Try<AuditTableFile> createTable(SparkSession sparkSession, FileStorageOps fileStorageOps, Path path, AuditTableInfo auditTableInfo, Function1<AuditTableFile, String> function1) {
        return AuditTableFile$.MODULE$.createTable(sparkSession, fileStorageOps, path, auditTableInfo, function1);
    }

    public static boolean openTables$default$5() {
        return AuditTableFile$.MODULE$.openTables$default$5();
    }

    public static Tuple2<Map<String, Try<AuditTableFile>>, Seq<String>> openTables(SparkSession sparkSession, FileStorageOps fileStorageOps, Path path, Seq<String> seq, boolean bl, Function1<AuditTableFile, String> function1) {
        return AuditTableFile$.MODULE$.openTables(sparkSession, fileStorageOps, path, seq, bl, function1);
    }

    public static boolean inferRegionsWithStats$default$6() {
        return AuditTableFile$.MODULE$.inferRegionsWithStats$default$6();
    }

    public static boolean inferRegionsWithStats$default$5() {
        return AuditTableFile$.MODULE$.inferRegionsWithStats$default$5();
    }

    public static Seq<AuditTableRegionInfo> inferRegionsWithStats(SparkSession sparkSession, FileStorageOps fileStorageOps, Path path, Seq<String> seq, boolean bl, boolean bl2) {
        return AuditTableFile$.MODULE$.inferRegionsWithStats(sparkSession, fileStorageOps, path, seq, bl, bl2);
    }

    public static void clearTableRegionCache(AuditTableFile auditTableFile) {
        AuditTableFile$.MODULE$.clearTableRegionCache(auditTableFile);
    }

    public static AuditTableFile setRegions(AuditTableFile auditTableFile, Seq<AuditTableRegionInfo> seq, Option<Seq<AuditTableRegionInfo>> option) {
        return AuditTableFile$.MODULE$.setRegions(auditTableFile, seq, option);
    }

    public static String nextLongRegion(AuditTableFile auditTableFile) {
        return AuditTableFile$.MODULE$.nextLongRegion(auditTableFile);
    }

    public static Timestamp highTimestamp() {
        return AuditTableFile$.MODULE$.highTimestamp();
    }

    public static Timestamp lowTimestamp() {
        return AuditTableFile$.MODULE$.lowTimestamp();
    }

    public static String REGION_INFO_DIRECTORY() {
        return AuditTableFile$.MODULE$.REGION_INFO_DIRECTORY();
    }

    public static String COLD_PARTITION() {
        return AuditTableFile$.MODULE$.COLD_PARTITION();
    }

    public static String HOT_PARTITION() {
        return AuditTableFile$.MODULE$.HOT_PARTITION();
    }

    public static String DE_LAST_UPDATED_COLUMN() {
        return AuditTableFile$.MODULE$.DE_LAST_UPDATED_COLUMN();
    }

    public static String STORE_REGION_COLUMN() {
        return AuditTableFile$.MODULE$.STORE_REGION_COLUMN();
    }

    public static String STORE_TYPE_COLUMN() {
        return AuditTableFile$.MODULE$.STORE_TYPE_COLUMN();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public <A> A logAndReturn(A a, Function1<A, String> message, Level level) {
        return (A)Logging.logAndReturn$((Logging)this, a, message, (Level)level);
    }

    public <A> A logAndReturn(A a, String msg, Level level) {
        return (A)Logging.logAndReturn$((Logging)this, a, (String)msg, (Level)level);
    }

    @Override
    public boolean compact$default$5() {
        return AuditTable.compact$default$5$(this);
    }

    public Logger com$coxautodata$waimak$log$Logging$$log() {
        return this.com$coxautodata$waimak$log$Logging$$log;
    }

    public final void com$coxautodata$waimak$log$Logging$_setter_$com$coxautodata$waimak$log$Logging$$log_$eq(Logger x$1) {
        this.com$coxautodata$waimak$log$Logging$$log = x$1;
    }

    public AuditTableInfo tableInfo() {
        return this.tableInfo;
    }

    @Override
    public Seq<AuditTableRegionInfo> regions() {
        return this.regions;
    }

    public FileStorageOps storageOps() {
        return this.storageOps;
    }

    public Path baseFolder() {
        return this.baseFolder;
    }

    public Function1<AuditTableFile, String> newRegionID() {
        return this.newRegionID;
    }

    public boolean wasModified() {
        return this.wasModified;
    }

    public void wasModified_$eq(boolean x$1) {
        this.wasModified = x$1;
    }

    public Path tablePath() {
        return this.tablePath;
    }

    public Path regionInfoBasePath() {
        return this.regionInfoBasePath;
    }

    public Path coldPath() {
        return this.coldPath;
    }

    public Path hotPath() {
        return this.hotPath;
    }

    public Path metaBasePath() {
        return this.metaBasePath;
    }

    @Override
    public Map<String, String> meta() {
        return this.tableInfo().meta();
    }

    @Override
    public String tableName() {
        return this.tableInfo().table_name();
    }

    @Override
    public Option<Timestamp> getLatestTimestamp() {
        if (this.regions().nonEmpty()) {
            return new Some(((TraversableOnce)this.regions().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.max_last_updated(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(t1, t2) -> {
                if (t1.after((Timestamp)t2)) {
                    return t1;
                }
                return t2;
            }));
        }
        return None$.MODULE$;
    }

    @Override
    public Try<Tuple2<AuditTable, Object>> append(Dataset<?> ds, Column lastUpdated, Timestamp appendTS) {
        Try res = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            this.markToUpdate();
            String regionID = (String)this.newRegionID().apply((Object)this);
            Path regionPath = new Path(this.hotPath(), new StringBuilder(1).append(AuditTableFile$.MODULE$.STORE_REGION_COLUMN()).append("=").append(regionID).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Creating region in path [").append(regionPath.toString()).append("]").toString());
            Dataset withLastUpdated = ds.withColumn(AuditTableFile$.MODULE$.DE_LAST_UPDATED_COLUMN(), lastUpdated);
            this.storageOps().writeParquet(this.tableInfo().table_name(), regionPath, withLastUpdated, this.storageOps().writeParquet$default$4(), this.storageOps().writeParquet$default$5());
            Tuple2<Object, Timestamp> tuple2 = this.calcRegionStats((Dataset)this.storageOps().openParquet(regionPath, (Seq<Path>)Predef$.MODULE$.wrapRefArray((Object[])new Path[0])).get());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long count = tuple2._1$mcJ$sp();
            Timestamp max_latest_ts = (Timestamp)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)count), (Object)max_latest_ts);
            long count2 = tuple22._1$mcJ$sp();
            Timestamp max_latest_ts2 = (Timestamp)tuple22._2();
            AuditTableRegionInfo region = new AuditTableRegionInfo(this.tableInfo().table_name(), AuditTableFile$.MODULE$.HOT_PARTITION(), regionID, appendTS, false, count2, max_latest_ts2);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Created region ").append(region).toString());
            return new Tuple2((Object)AuditTableFile$.MODULE$.setRegions(this, (Seq<AuditTableRegionInfo>)((Seq)this.regions().$colon$plus((Object)region, Seq$.MODULE$.canBuildFrom())), (Option<Seq<AuditTableRegionInfo>>)new Some((Object)new .colon.colon((Object)region, (List)Nil$.MODULE$))), (Object)BoxesRunTime.boxToLong((long)count2));
        });
        return res;
    }

    @Override
    public Option<Dataset<?>> snapshot(Timestamp ts) {
        return this.allBetween((Option<Timestamp>)None$.MODULE$, (Option<Timestamp>)new Some((Object)ts)).map((Function1 & Serializable & scala.Serializable)ds -> this.deduplicate((Dataset<?>)ds)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.drop(AuditTableFile$.MODULE$.DE_LAST_UPDATED_COLUMN()));
    }

    public Dataset<?> deduplicate(Dataset<?> ds) {
        Seq primaryKeyColumns = (Seq)this.tableInfo().primary_keys().map((Function1 & Serializable & scala.Serializable)x$4 -> ds.apply(x$4), Seq$.MODULE$.canBuildFrom());
        WindowSpec windowLatest = Window$.MODULE$.partitionBy(primaryKeyColumns).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{ds.apply(AuditTableFile$.MODULE$.DE_LAST_UPDATED_COLUMN()).desc()}));
        return ds.withColumn("_rowNum", functions$.MODULE$.row_number().over(windowLatest)).filter("_rowNum = 1").drop("_rowNum");
    }

    @Override
    public Try<AuditTable> compact(Timestamp compactTS, Duration trashMaxAge, long smallRegionRowThreshold, Function2<Dataset<?>, Object, Object> compactionPartitioner, boolean recompactAll) {
        Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.markToUpdate()).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> this.compactRegions(this.regionsToCompact(smallRegionRowThreshold, recompactAll), compactTS, compactionPartitioner)).map((Function1 & Serializable & scala.Serializable)f -> {
            f.storageOps().purgeTrash(f.tableName(), compactTS, trashMaxAge);
            return f;
        });
        return res.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6);
    }

    public Try<AuditTableFile> initNewTable() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Initialising table [").append(this.tableInfo().table_name()).append("] in path [").append(this.tablePath().toString()).append("]").toString());
        Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> AuditTableFile.$anonfun$initNewTable$3(this, BoxesRunTime.unboxToBoolean((Object)x$7))).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> AuditTableFile.$anonfun$initNewTable$4(this, BoxesRunTime.unboxToBoolean((Object)x$8))).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> AuditTableFile.$anonfun$initNewTable$5(this, BoxesRunTime.unboxToBoolean((Object)x$9))).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> AuditTableFile.$anonfun$initNewTable$6(this, BoxesRunTime.unboxToBoolean((Object)x$10))).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> AuditTableFile.$anonfun$initNewTable$7(this, BoxesRunTime.unboxToBoolean((Object)x$11))).map((Function1 & Serializable & scala.Serializable)x$12 -> AuditTableFile$.MODULE$.setRegions(this, (Seq<AuditTableRegionInfo>)((Seq)Nil$.MODULE$), (Option<Seq<AuditTableRegionInfo>>)None$.MODULE$));
        return res;
    }

    @Override
    public Try<AuditTable> updateTableInfo(AuditTableInfo tableInfo) {
        return this.storageOps().writeAuditTableInfo(this.baseFolder(), tableInfo).map((Function1 & Serializable & scala.Serializable)info -> new AuditTableFile((AuditTableInfo)info, this.regions(), this.storageOps(), this.baseFolder(), this.newRegionID()));
    }

    @Override
    public Option<Dataset<?>> allBetween(Option<Timestamp> from, Option<Timestamp> to) {
        Option<Seq<String>> regionIDs = this.activeRegionIDs();
        return regionIDs.flatMap((Function1 & Serializable & scala.Serializable)ids -> {
            Option<Dataset<?>> df = this.storageOps().openParquet(this.tablePath(), (Seq<Path>)Predef$.MODULE$.wrapRefArray((Object[])new Path[0]));
            return df.map((Function1 & Serializable & scala.Serializable)rows -> {
                Dataset auditRows = rows.filter(rows.apply(AuditTableFile$.MODULE$.STORE_TYPE_COLUMN()).isin((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AuditTableFile$.MODULE$.HOT_PARTITION(), AuditTableFile$.MODULE$.COLD_PARTITION()})).$amp$amp((Object)rows.apply(AuditTableFile$.MODULE$.STORE_REGION_COLUMN()).isin(ids)));
                return auditRows.filter(auditRows.apply(AuditTableFile$.MODULE$.DE_LAST_UPDATED_COLUMN()).between(from.getOrElse((Function0 & Serializable & scala.Serializable)() -> AuditTableFile$.MODULE$.lowTimestamp()), to.getOrElse((Function0 & Serializable & scala.Serializable)() -> AuditTableFile$.MODULE$.highTimestamp())));
            });
        });
    }

    public Option<Seq<String>> activeRegionIDs() {
        if (this.regions().isEmpty()) {
            return None$.MODULE$;
        }
        return new Some(((TraversableLike)this.regions().filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AuditTableFile.$anonfun$activeRegionIDs$1(x$13)))).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.store_region(), Seq$.MODULE$.canBuildFrom()));
    }

    public Seq<AuditTableRegionInfo> regionsToCompact(long smallRegionRowThreshold, boolean recompactAll) {
        if (recompactAll || !this.tableInfo().retain_history()) {
            return this.regions();
        }
        Seq r2 = (Seq)this.regions().filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)AuditTableFile.$anonfun$regionsToCompact$1(smallRegionRowThreshold, r)));
        if (r2.length() < 2 && !r2.exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)AuditTableFile.$anonfun$regionsToCompact$2(x$15)))) {
            return (Seq)Nil$.MODULE$;
        }
        return r2;
    }

    public Try<AuditTableFile> compactRegions(Seq<AuditTableRegionInfo> toCompact, Timestamp compactTS, Function2<Dataset<?>, Object, Object> compactionPartitioner) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            AuditTableFile auditTableFile;
            if (toCompact.isEmpty()) {
                auditTableFile = new AuditTableFile(this.tableInfo(), this.regions(), this.storageOps(), this.baseFolder(), this.newRegionID());
            } else {
                Seq ids = (Seq)toCompact.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.store_region(), Seq$.MODULE$.canBuildFrom());
                String regionID = (String)this.newRegionID().apply((Object)this);
                Path newRegionPath = new Path(this.coldPath(), new StringBuilder(1).append(AuditTableFile$.MODULE$.STORE_REGION_COLUMN()).append("=").append(regionID).toString());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Compacting regions ").append(ids.mkString("[", ", ", "]")).append(" in path [").append(newRegionPath.toString()).append("]").toString());
                if (this.storageOps().pathExists(newRegionPath)) {
                    throw new StorageException(new StringBuilder(51).append("Can not compact table [").append(this.tableName()).append("], as path [").append(newRegionPath.toString()).append("] already exists").toString(), StorageException$.MODULE$.apply$default$2());
                }
                Seq regionPaths = (Seq)toCompact.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    AuditTableRegionInfo auditTableRegionInfo = x0$1;
                    String string = auditTableRegionInfo.store_type();
                    String string2 = AuditTableFile$.MODULE$.HOT_PARTITION();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return new Path(this.hotPath(), new StringBuilder(1).append(AuditTableFile$.MODULE$.STORE_REGION_COLUMN()).append("=").append(auditTableRegionInfo.store_region()).toString());
                    }
                    String string3 = auditTableRegionInfo.store_type();
                    String string4 = AuditTableFile$.MODULE$.COLD_PARTITION();
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        return new Path(this.coldPath(), new StringBuilder(1).append(AuditTableFile$.MODULE$.STORE_REGION_COLUMN()).append("=").append(auditTableRegionInfo.store_region()).toString());
                    }
                    throw new StorageException(new StringBuilder(31).append("Unknown store type ").append(auditTableRegionInfo.store_type()).append(" for region ").append(auditTableRegionInfo.store_type()).toString(), StorageException$.MODULE$.apply$default$2());
                }, Seq$.MODULE$.canBuildFrom());
                Option data = this.storageOps().openParquet((Path)regionPaths.head(), (Seq<Path>)((Seq)regionPaths.tail())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Dataset dataset = x0$2;
                    if (!this.tableInfo().retain_history()) {
                        return this.deduplicate(dataset);
                    }
                    return dataset;
                });
                Option newRegionSet = data.map((Function1 & Serializable & scala.Serializable)rows -> {
                    AuditTableFile$.MODULE$.clearTableRegionCache(this);
                    int currentNumPartitions = rows.rdd().getNumPartitions();
                    int newNumPartitions = BoxesRunTime.unboxToInt((Object)compactionPartitioner.apply(rows, ((TraversableOnce)toCompact.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.count()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                    Dataset rowsToCompactRepartitioned = newNumPartitions > currentNumPartitions ? rows.repartition(newNumPartitions) : rows.coalesce(newNumPartitions);
                    this.storageOps().atomicWriteAndCleanup(this.tableInfo().table_name(), rowsToCompactRepartitioned, newRegionPath, (Seq<Path>)regionPaths, compactTS);
                    Tuple2<Object, Timestamp> tuple2 = this.calcRegionStats((Dataset)this.storageOps().openParquet(newRegionPath, (Seq<Path>)Predef$.MODULE$.wrapRefArray((Object[])new Path[0])).get());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long count = tuple2._1$mcJ$sp();
                    Timestamp max_latest_ts = (Timestamp)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)count), (Object)max_latest_ts);
                    long count2 = tuple22._1$mcJ$sp();
                    Timestamp max_latest_ts2 = (Timestamp)tuple22._2();
                    Set idSet = ids.toSet();
                    Seq remainingRegions = (Seq)this.regions().filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)AuditTableFile.$anonfun$compactRegions$8(idSet, r)));
                    AuditTableRegionInfo region = new AuditTableRegionInfo(this.tableInfo().table_name(), AuditTableFile$.MODULE$.COLD_PARTITION(), regionID, compactTS, false, count2, max_latest_ts2);
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Compacted region ").append(region.toString()).append(" was created.").toString());
                    return (Seq)remainingRegions.$colon$plus((Object)region, Seq$.MODULE$.canBuildFrom());
                });
                auditTableFile = (AuditTableFile)newRegionSet.fold((Function0 & Serializable & scala.Serializable)() -> this, (Function1 & Serializable & scala.Serializable)r -> AuditTableFile$.MODULE$.setRegions(this, (Seq<AuditTableRegionInfo>)r, (Option<Seq<AuditTableRegionInfo>>)None$.MODULE$));
            }
            AuditTableFile res = auditTableFile;
            return res;
        });
    }

    public Tuple2<Object, Timestamp> calcRegionStats(Dataset<?> ds) {
        return (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ds.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.count(ds.apply(AuditTableFile$.MODULE$.DE_LAST_UPDATED_COLUMN())), functions$.MODULE$.max(ds.apply(AuditTableFile$.MODULE$.DE_LAST_UPDATED_COLUMN()))})).collect())).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(r.getAs(0), Option$.MODULE$.apply(r.getAs(1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> AuditTableFile$.MODULE$.lowTimestamp())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).head();
    }

    public void markToUpdate() {
        if (this.wasModified()) {
            throw new StorageException(new StringBuilder(34).append("Table [").append(this.tableName()).append("] can no longer be updated.").toString(), StorageException$.MODULE$.apply$default$2());
        }
        this.wasModified_$eq(true);
    }

    public static final /* synthetic */ Try $anonfun$initNewTable$3(AuditTableFile $this, boolean x$7) {
        if ($this.storageOps().pathExists($this.tablePath())) {
            return new Failure((Throwable)new StorageException(new StringBuilder(34).append("Table [").append($this.tableInfo().table_name()).append("] already exists in path [").append($this.tablePath().toString()).append("]").toString(), StorageException$.MODULE$.apply$default$2()));
        }
        return new Success((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ Try $anonfun$initNewTable$4(AuditTableFile $this, boolean x$8) {
        if ($this.tableInfo().primary_keys().isEmpty()) {
            return new Failure((Throwable)new StorageException(new StringBuilder(55).append("Table [").append($this.tableInfo().table_name()).append("] must have at least one column in primary keys.").toString(), StorageException$.MODULE$.apply$default$2()));
        }
        return new Success((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ Try $anonfun$initNewTable$5(AuditTableFile $this, boolean x$9) {
        if ($this.storageOps().mkdirs($this.hotPath())) {
            return new Success((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        return new Failure((Throwable)new StorageException(new StringBuilder(55).append("Table [").append($this.tableInfo().table_name()).append("] can not be initialised, can not create folder ").append($this.hotPath().toString()).toString(), StorageException$.MODULE$.apply$default$2()));
    }

    public static final /* synthetic */ Try $anonfun$initNewTable$6(AuditTableFile $this, boolean x$10) {
        if ($this.storageOps().mkdirs($this.coldPath())) {
            return new Success((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        return new Failure((Throwable)new StorageException(new StringBuilder(55).append("Table [").append($this.tableInfo().table_name()).append("] can not be initialised, can not create folder ").append($this.coldPath().toString()).toString(), StorageException$.MODULE$.apply$default$2()));
    }

    public static final /* synthetic */ Try $anonfun$initNewTable$7(AuditTableFile $this, boolean x$11) {
        return $this.storageOps().writeAuditTableInfo($this.baseFolder(), $this.tableInfo());
    }

    public static final /* synthetic */ boolean $anonfun$activeRegionIDs$1(AuditTableRegionInfo x$13) {
        return !x$13.is_deprecated();
    }

    private static final boolean coldNeedsCompacting$1(AuditTableRegionInfo r, long smallRegionRowThreshold$2) {
        String string = r.store_type();
        String string2 = AuditTableFile$.MODULE$.COLD_PARTITION();
        return !(string != null ? !string.equals(string2) : string2 != null) && r.count() < smallRegionRowThreshold$2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hotNeedsCompacting$1(AuditTableRegionInfo r) {
        if (r.is_deprecated()) return false;
        String string = r.store_type();
        String string2 = AuditTableFile$.MODULE$.HOT_PARTITION();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$regionsToCompact$1(long smallRegionRowThreshold$2, AuditTableRegionInfo r) {
        return AuditTableFile.coldNeedsCompacting$1(r, smallRegionRowThreshold$2) || AuditTableFile.hotNeedsCompacting$1(r);
    }

    public static final /* synthetic */ boolean $anonfun$regionsToCompact$2(AuditTableRegionInfo x$15) {
        String string = x$15.store_type();
        String string2 = AuditTableFile$.MODULE$.HOT_PARTITION();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$compactRegions$8(Set idSet$1, AuditTableRegionInfo r) {
        return !idSet$1.contains((Object)r.store_region());
    }

    public AuditTableFile(AuditTableInfo tableInfo, Seq<AuditTableRegionInfo> regions, FileStorageOps storageOps, Path baseFolder, Function1<AuditTableFile, String> newRegionID) {
        this.tableInfo = tableInfo;
        this.regions = regions;
        this.storageOps = storageOps;
        this.baseFolder = baseFolder;
        this.newRegionID = newRegionID;
        Logging.$init$((Logging)this);
        this.wasModified = false;
        this.tablePath = new Path(baseFolder, tableInfo.table_name());
        this.regionInfoBasePath = new Path(baseFolder, AuditTableFile$.MODULE$.REGION_INFO_DIRECTORY());
        this.coldPath = new Path(this.tablePath(), new StringBuilder(1).append(AuditTableFile$.MODULE$.STORE_TYPE_COLUMN()).append("=").append(AuditTableFile$.MODULE$.COLD_PARTITION()).toString());
        this.hotPath = new Path(this.tablePath(), new StringBuilder(1).append(AuditTableFile$.MODULE$.STORE_TYPE_COLUMN()).append("=").append(AuditTableFile$.MODULE$.HOT_PARTITION()).toString());
        this.metaBasePath = new Path(this.tablePath(), "_metadata");
    }
}

