/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodata.waimak.storage;

import com.coxautodata.waimak.dataflow.FlowContext;
import com.coxautodata.waimak.log.Level;
import com.coxautodata.waimak.log.Logging;
import com.coxautodata.waimak.storage.AuditTable;
import com.coxautodata.waimak.storage.AuditTableFile;
import com.coxautodata.waimak.storage.AuditTableFile$;
import com.coxautodata.waimak.storage.AuditTableInfo;
import com.coxautodata.waimak.storage.AuditTableRegionInfo;
import com.coxautodata.waimak.storage.CompactionPartitionerGenerator$;
import com.coxautodata.waimak.storage.FileStorageOps;
import com.coxautodata.waimak.storage.FileStorageOpsWithStaging;
import com.coxautodata.waimak.storage.StorageActions$;
import com.coxautodata.waimak.storage.StorageException;
import com.coxautodata.waimak.storage.StorageException$;
import java.io.Serializable;
import java.net.URI;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class Storage$
implements Logging {
    public static Storage$ MODULE$;
    private final Logger com$coxautodata$waimak$log$Logging$$log;

    static {
        new Storage$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public <A> A logAndReturn(A a, Function1<A, String> message, Level level) {
        return (A)Logging.logAndReturn$((Logging)this, a, message, (Level)level);
    }

    public <A> A logAndReturn(A a, String msg, Level level) {
        return (A)Logging.logAndReturn$((Logging)this, a, (String)msg, (Level)level);
    }

    public Logger com$coxautodata$waimak$log$Logging$$log() {
        return this.com$coxautodata$waimak$log$Logging$$log;
    }

    public final void com$coxautodata$waimak$log$Logging$_setter_$com$coxautodata$waimak$log$Logging$$log_$eq(Logger x$1) {
        this.com$coxautodata$waimak$log$Logging$$log = x$1;
    }

    public Try<AuditTable> createFileTable(SparkSession sparkSession, Path basePath, AuditTableInfo tableInfo) {
        FileStorageOps fileStorageOps = this.createFops(sparkSession, basePath);
        Try<AuditTableFile> table2 = AuditTableFile$.MODULE$.createTable(sparkSession, fileStorageOps, basePath, tableInfo, (Function1<AuditTableFile, String>)(Function1 & Serializable & scala.Serializable)table -> AuditTableFile$.MODULE$.nextLongRegion((AuditTableFile)table));
        return table2;
    }

    public Tuple2<Map<String, Try<AuditTable>>, Seq<String>> openFileTables(SparkSession sparkSession, Path basePath, Seq<String> tableNames, boolean includeHot) {
        FileStorageOps fileStorageOps = this.createFops(sparkSession, basePath);
        Tuple2<Map<String, Try<AuditTableFile>>, Seq<String>> res = AuditTableFile$.MODULE$.openTables(sparkSession, fileStorageOps, basePath, tableNames, includeHot, (Function1<AuditTableFile, String>)(Function1 & Serializable & scala.Serializable)table -> AuditTableFile$.MODULE$.nextLongRegion((AuditTableFile)table));
        return res;
    }

    public boolean openFileTables$default$4() {
        return true;
    }

    public Seq<AuditTable> getOrCreateFileTables(SparkSession sparkSession, Path basePath, Seq<String> tableNames, Option<Function1<String, AuditTableInfo>> metadataRetrieval, Function0<Object> updateTableMetadata, boolean includeHot) {
        Tuple2<Map<String, Try<AuditTable>>, Seq<String>> tuple2 = this.openFileTables(sparkSession, basePath, tableNames, includeHot);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map existingTables = (Map)tuple2._1();
        Seq missingTables = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingTables, (Object)missingTables);
        Map existingTables2 = (Map)tuple22._1();
        Seq missingTables2 = (Seq)tuple22._2();
        if (missingTables2.nonEmpty() && metadataRetrieval.isEmpty()) {
            throw new StorageException(new StringBuilder(119).append("The following tables were not found in the storage layer and could not be created as no metadata function was defined: ").append(missingTables2.mkString(",")).toString(), StorageException$.MODULE$.apply$default$2());
        }
        if (updateTableMetadata.apply$mcZ$sp() && metadataRetrieval.isEmpty()) {
            throw new StorageException(new StringBuilder(52).append(StorageActions$.MODULE$.UPDATE_TABLE_METADATA()).append(" is set to true but no metadata function was defined").toString(), StorageException$.MODULE$.apply$default$2());
        }
        Map existingTablesWithUpdatedMetadata = updateTableMetadata.apply$mcZ$sp() ? existingTables2.mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.flatMap((Function1 & Serializable & scala.Serializable)table -> table.updateTableInfo((AuditTableInfo)((Function1)metadataRetrieval.get()).apply((Object)table.tableName())))).toMap(Predef$.MODULE$.$conforms()) : existingTables2;
        Map createdTables = ((TraversableOnce)missingTables2.map((Function1 & Serializable & scala.Serializable)tableName -> {
            AuditTableInfo tableInfo = (AuditTableInfo)((Function1)metadataRetrieval.get()).apply(tableName);
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Creating table ").append(tableInfo.table_name()).append(" with metadata ").append(tableInfo).toString());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tableName), MODULE$.createFileTable(sparkSession, basePath, tableInfo));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        StorageActions$.MODULE$.handleTableErrors((Map<String, Try<Object>>)createdTables, "Unable to perform create");
        StorageActions$.MODULE$.handleTableErrors((Map<String, Try<Object>>)existingTables2, "Unable to perform read");
        StorageActions$.MODULE$.handleTableErrors((Map<String, Try<Object>>)existingTablesWithUpdatedMetadata, "Unable to update metadata");
        Map allTables = ((TraversableOnce)((TraversableLike)((TraversableLike)existingTablesWithUpdatedMetadata.values().map((Function1 & Serializable & scala.Serializable)x$3 -> (AuditTable)x$3.get(), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)createdTables.values().map((Function1 & Serializable & scala.Serializable)x$4 -> (AuditTable)x$4.get(), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.tableName()), t), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return (Seq)tableNames.map((Function1)allTables, Seq$.MODULE$.canBuildFrom());
    }

    public boolean getOrCreateFileTables$default$6() {
        return true;
    }

    public void writeToFileTable(FlowContext flowContext, AuditTable table, Dataset<?> toAppend, String lastUpdatedCol, ZonedDateTime appendDateTime, Function3<Seq<AuditTableRegionInfo>, Object, ZonedDateTime, Object> doCompaction) {
        boolean recompactAll = flowContext.getBoolean(StorageActions$.MODULE$.RECOMPACT_ALL(), StorageActions$.MODULE$.RECOMPACT_ALL_DEFAULT());
        Function2<Dataset<?>, Object, Object> compactionPartitioner = CompactionPartitionerGenerator$.MODULE$.getImplementation(flowContext);
        Duration trashMaxAge = Duration.ofMillis(flowContext.getLong(StorageActions$.MODULE$.TRASH_MAX_AGE_MS(), StorageActions$.MODULE$.TRASH_MAX_AGE_MS_DEFAULT()));
        long smallRegionRowThreshold = flowContext.getLong(StorageActions$.MODULE$.SMALL_REGION_ROW_THRESHOLD(), StorageActions$.MODULE$.SMALL_REGION_ROW_THRESHOLD_DEFAULT());
        this.writeToFileTable(table, toAppend, lastUpdatedCol, appendDateTime, doCompaction, recompactAll, trashMaxAge, smallRegionRowThreshold, compactionPartitioner);
    }

    public void writeToFileTable(AuditTable table, Dataset<?> toAppend, String lastUpdatedCol, ZonedDateTime appendDateTime, Function3<Seq<AuditTableRegionInfo>, Object, ZonedDateTime, Object> doCompaction, boolean recompactAll, Duration trashMaxAge, long smallRegionRowThreshold, Function2<Dataset<?>, Object, Object> compactionPartitioner) {
        Timestamp appendTimestamp = Timestamp.valueOf(appendDateTime.withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime());
        boolean bl = false;
        Success success = null;
        Try<Tuple2<AuditTable, Object>> try_ = table.append(toAppend, (Column)toAppend.sparkSession().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).$((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lastUpdatedCol})), appendTimestamp);
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Tuple2 tuple2 = (Tuple2)success.value();
            if (tuple2 != null) {
                AuditTable t = (AuditTable)tuple2._1();
                long c = tuple2._2$mcJ$sp();
                if (recompactAll || BoxesRunTime.unboxToBoolean((Object)doCompaction.apply(t.regions(), (Object)BoxesRunTime.boxToLong((long)c), (Object)appendDateTime))) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Compaction has been triggered on table [").append(table.tableName()).append("], with compaction timestamp [").append(appendTimestamp).append("].").toString());
                    Timestamp x$1 = appendTimestamp;
                    Duration x$2 = trashMaxAge;
                    Function2<Dataset<?>, Object, Object> x$3 = compactionPartitioner;
                    long x$4 = smallRegionRowThreshold;
                    boolean x$5 = recompactAll;
                    Try<AuditTable> try_2 = t.compact(x$1, x$2, x$4, x$3, x$5);
                    if (!(try_2 instanceof Success)) {
                        if (try_2 instanceof Failure) {
                            Failure failure = (Failure)try_2;
                            Throwable e = failure.exception();
                            throw new StorageException(new StringBuilder(56).append("Failed to compact table [").append(table.tableName()).append("], with compaction timestamp [").append(appendTimestamp).append("]").toString(), e);
                        }
                        throw new MatchError(try_2);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (bl) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw new StorageException(new StringBuilder(62).append("Error appending data to table [").append(table.tableName()).append("], using last updated column [").append(lastUpdatedCol).append("]").toString(), e);
        }
        throw new MatchError(try_);
    }

    public FileStorageOps createFops(SparkSession sparkSession, Path basePath) {
        return new FileStorageOpsWithStaging(FileSystem.get((URI)basePath.toUri(), (Configuration)sparkSession.sparkContext().hadoopConfiguration()), sparkSession, new Path(basePath, ".tmp"), new Path(basePath, ".Trash"));
    }

    private Storage$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

