/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodata.waimak.storage;

import com.coxautodata.waimak.dataflow.spark.SparkDataFlow;
import com.coxautodata.waimak.log.Level;
import com.coxautodata.waimak.log.Logging;
import com.coxautodata.waimak.storage.AuditTableFile$;
import com.coxautodata.waimak.storage.AuditTableRegionInfo;
import com.coxautodata.waimak.storage.StorageActions;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

public final class StorageActions$
implements Logging {
    public static StorageActions$ MODULE$;
    private final String storageParamPrefix;
    private final String TRASH_MAX_AGE_MS;
    private final long TRASH_MAX_AGE_MS_DEFAULT;
    private final String SMALL_REGION_ROW_THRESHOLD;
    private final long SMALL_REGION_ROW_THRESHOLD_DEFAULT;
    private final String COMPACTION_PARTITIONER_IMPLEMENTATION;
    private final String COMPACTION_PARTITIONER_IMPLEMENTATION_DEFAULT;
    private final String BYTES_PER_PARTITION;
    private final long BYTES_PER_PARTITION_DEFAULT;
    private final String MAX_RECORDS_TO_SAMPLE;
    private final long MAX_RECORDS_TO_SAMPLE_DEFAULT;
    private final String CELLS_PER_PARTITION;
    private final long CELLS_PER_PARTITION_DEFAULT;
    private final String RECOMPACT_ALL;
    private final boolean RECOMPACT_ALL_DEFAULT;
    private final String UPDATE_TABLE_METADATA;
    private final boolean UPDATE_TABLE_METADATA_DEFAULT;
    private final Logger com$coxautodata$waimak$log$Logging$$log;

    static {
        new StorageActions$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public <A> A logAndReturn(A a, Function1<A, String> message, Level level) {
        return (A)Logging.logAndReturn$((Logging)this, a, message, (Level)level);
    }

    public <A> A logAndReturn(A a, String msg, Level level) {
        return (A)Logging.logAndReturn$((Logging)this, a, (String)msg, (Level)level);
    }

    public Logger com$coxautodata$waimak$log$Logging$$log() {
        return this.com$coxautodata$waimak$log$Logging$$log;
    }

    public final void com$coxautodata$waimak$log$Logging$_setter_$com$coxautodata$waimak$log$Logging$$log_$eq(Logger x$1) {
        this.com$coxautodata$waimak$log$Logging$$log = x$1;
    }

    public String storageParamPrefix() {
        return this.storageParamPrefix;
    }

    public String TRASH_MAX_AGE_MS() {
        return this.TRASH_MAX_AGE_MS;
    }

    public long TRASH_MAX_AGE_MS_DEFAULT() {
        return this.TRASH_MAX_AGE_MS_DEFAULT;
    }

    public String SMALL_REGION_ROW_THRESHOLD() {
        return this.SMALL_REGION_ROW_THRESHOLD;
    }

    public long SMALL_REGION_ROW_THRESHOLD_DEFAULT() {
        return this.SMALL_REGION_ROW_THRESHOLD_DEFAULT;
    }

    public String COMPACTION_PARTITIONER_IMPLEMENTATION() {
        return this.COMPACTION_PARTITIONER_IMPLEMENTATION;
    }

    public String COMPACTION_PARTITIONER_IMPLEMENTATION_DEFAULT() {
        return this.COMPACTION_PARTITIONER_IMPLEMENTATION_DEFAULT;
    }

    public String BYTES_PER_PARTITION() {
        return this.BYTES_PER_PARTITION;
    }

    public long BYTES_PER_PARTITION_DEFAULT() {
        return this.BYTES_PER_PARTITION_DEFAULT;
    }

    public String MAX_RECORDS_TO_SAMPLE() {
        return this.MAX_RECORDS_TO_SAMPLE;
    }

    public long MAX_RECORDS_TO_SAMPLE_DEFAULT() {
        return this.MAX_RECORDS_TO_SAMPLE_DEFAULT;
    }

    public String CELLS_PER_PARTITION() {
        return this.CELLS_PER_PARTITION;
    }

    public long CELLS_PER_PARTITION_DEFAULT() {
        return this.CELLS_PER_PARTITION_DEFAULT;
    }

    public String RECOMPACT_ALL() {
        return this.RECOMPACT_ALL;
    }

    public boolean RECOMPACT_ALL_DEFAULT() {
        return this.RECOMPACT_ALL_DEFAULT;
    }

    public String UPDATE_TABLE_METADATA() {
        return this.UPDATE_TABLE_METADATA;
    }

    public boolean UPDATE_TABLE_METADATA_DEFAULT() {
        return this.UPDATE_TABLE_METADATA_DEFAULT;
    }

    public void handleTableErrors(Map<String, Try<Object>> tableResults, String errorMessageBase) {
        Map tableErrors = ((MapLike)tableResults.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StorageActions$.$anonfun$handleTableErrors$1(x$1)))).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> (Throwable)x$2.failed().get());
        if (tableErrors.nonEmpty()) {
            tableErrors.foreach((Function1 & Serializable & scala.Serializable)kv -> {
                StorageActions$.MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append(errorMessageBase$1).append(" for table ").append(kv._1()).toString(), (Throwable)kv._2());
                return BoxedUnit.UNIT;
            });
            throw new RuntimeException(new StringBuilder(13).append(errorMessageBase).append(" for tables: ").append(tableErrors.keySet()).toString());
        }
    }

    public Function3<Seq<AuditTableRegionInfo>, Object, ZonedDateTime, Object> runSingleCompactionDuringWindow(int windowStartHours, int windowEndHours) {
        return (Function3 & Serializable & scala.Serializable)(regions, x$3, compactionDateTime) -> BoxesRunTime.boxToBoolean((boolean)StorageActions$.$anonfun$runSingleCompactionDuringWindow$1(windowEndHours, windowStartHours, regions, BoxesRunTime.unboxToLong((Object)x$3), compactionDateTime));
    }

    public StorageActions.StorageActionImplicits StorageActionImplicits(SparkDataFlow sparkDataFlow) {
        return new StorageActions.StorageActionImplicits(sparkDataFlow);
    }

    public static final /* synthetic */ boolean $anonfun$handleTableErrors$1(Tuple2 x$1) {
        return ((Try)x$1._2()).isFailure();
    }

    public static final /* synthetic */ boolean $anonfun$runSingleCompactionDuringWindow$2(AuditTableRegionInfo x$4) {
        String string = x$4.store_type();
        String string2 = AuditTableFile$.MODULE$.HOT_PARTITION();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$runSingleCompactionDuringWindow$1(int windowEndHours$1, int windowStartHours$1, Seq regions, long x$3, ZonedDateTime compactionDateTime) {
        ZonedDateTime maybeEnd = compactionDateTime.withHour(windowEndHours$1).withMinute(0).withSecond(0).withNano(0);
        ZonedDateTime end = maybeEnd.isBefore(compactionDateTime) ? maybeEnd.plusDays(1L).withHour(windowEndHours$1).withMinute(0).withSecond(0).withNano(0) : maybeEnd;
        ZonedDateTime maybeStart = end.withHour(windowStartHours$1);
        ZonedDateTime start = maybeStart.isAfter(end) ? maybeStart.plusDays(-1L).withHour(windowStartHours$1).withMinute(0).withSecond(0).withNano(0) : maybeStart;
        boolean hotRegionExists = regions.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StorageActions$.$anonfun$runSingleCompactionDuringWindow$2(x$4)));
        Option latestCold = ((TraversableLike)((SeqLike)((SeqLike)regions.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends AuditTableRegionInfo, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                String string = A1.store_type();
                String string2 = AuditTableFile$.MODULE$.COLD_PARTITION();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return (B1)A1.created_on().toLocalDateTime().atZone(ZoneOffset.UTC);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(AuditTableRegionInfo x1) {
                AuditTableRegionInfo auditTableRegionInfo = x1;
                String string = auditTableRegionInfo.store_type();
                String string2 = AuditTableFile$.MODULE$.COLD_PARTITION();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }, Seq$.MODULE$.canBuildFrom())).sortWith((Function2 & Serializable & scala.Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)x$5.isBefore(x$6)))).reverse()).headOption();
        if (compactionDateTime.isBefore(start)) {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(102).append("Current timestamp [").append(compactionDateTime).append("] is not in compaction window therefore will not compact. Next window is: [").append(start).append(" until ").append(end).append("]").toString());
            return false;
        }
        if (!hotRegionExists) {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("In compaction window [").append(start).append(" until ").append(end).append("], however not hot region exists therefore skipping compaction").toString());
            return false;
        }
        if (latestCold.nonEmpty() && !((ChronoZonedDateTime)latestCold.get()).isBefore(start) && !((ChronoZonedDateTime)latestCold.get()).isAfter(end)) {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("In compaction window [").append(start).append(" until ").append(end).append("], however a compaction was already done in the window at: ").append(latestCold.get()).toString());
            return false;
        }
        MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Valid compaction in the window [").append(start).append(" until ").append(end).append("], a compaction will be triggered.").toString());
        return true;
    }

    private StorageActions$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.storageParamPrefix = "spark.waimak.storage";
        this.TRASH_MAX_AGE_MS = new StringBuilder(14).append(this.storageParamPrefix()).append(".trashMaxAgeMs").toString();
        this.TRASH_MAX_AGE_MS_DEFAULT = 86400000L;
        this.SMALL_REGION_ROW_THRESHOLD = new StringBuilder(24).append(this.storageParamPrefix()).append(".smallRegionRowThreshold").toString();
        this.SMALL_REGION_ROW_THRESHOLD_DEFAULT = 50000000L;
        this.COMPACTION_PARTITIONER_IMPLEMENTATION = new StringBuilder(36).append(this.storageParamPrefix()).append(".compactionPartitionerImplementation").toString();
        this.COMPACTION_PARTITIONER_IMPLEMENTATION_DEFAULT = "com.coxautodata.waimak.storage.TotalBytesPartitioner";
        this.BYTES_PER_PARTITION = new StringBuilder(18).append(this.storageParamPrefix()).append(".bytesPerPartition").toString();
        this.BYTES_PER_PARTITION_DEFAULT = 250000000L;
        this.MAX_RECORDS_TO_SAMPLE = new StringBuilder(19).append(this.storageParamPrefix()).append(".maxRecordsToSample").toString();
        this.MAX_RECORDS_TO_SAMPLE_DEFAULT = 1000L;
        this.CELLS_PER_PARTITION = new StringBuilder(18).append(this.storageParamPrefix()).append(".cellsPerPartition").toString();
        this.CELLS_PER_PARTITION_DEFAULT = 2500000L;
        this.RECOMPACT_ALL = new StringBuilder(13).append(this.storageParamPrefix()).append(".recompactAll").toString();
        this.RECOMPACT_ALL_DEFAULT = false;
        this.UPDATE_TABLE_METADATA = new StringBuilder(15).append(this.storageParamPrefix()).append(".updateMetadata").toString();
        this.UPDATE_TABLE_METADATA_DEFAULT = false;
    }
}

