/*
 * Decompiled with CFR 0.152.
 */
package craterdog.primitives;

import craterdog.utils.Base32Utils;
import craterdog.utils.ByteUtils;
import craterdog.utils.RandomUtils;

public final class Tag
implements Comparable<Tag> {
    private static final int DEFAULT_TAG_SIZE = 20;
    private final int tagSize;
    private final int hash;
    private final String string;

    public Tag() {
        this.tagSize = 20;
        byte[] bytes = RandomUtils.generateRandomBytes((int)this.tagSize);
        this.hash = ByteUtils.bytesToInt((byte[])bytes);
        this.string = Base32Utils.encode((byte[])bytes);
    }

    public Tag(int tagSizeInBytes) {
        this.tagSize = tagSizeInBytes;
        byte[] bytes = RandomUtils.generateRandomBytes((int)this.tagSize);
        this.hash = ByteUtils.bytesToInt((byte[])bytes);
        this.string = Base32Utils.encode((byte[])bytes);
    }

    public Tag(byte[] bytes) {
        this.tagSize = bytes.length;
        this.hash = ByteUtils.bytesToInt((byte[])bytes);
        this.string = Base32Utils.encode((byte[])bytes);
    }

    public Tag(String value) {
        try {
            this.string = value;
            byte[] bytes = Base32Utils.decode((String)this.string);
            this.tagSize = bytes.length;
            this.hash = ByteUtils.bytesToInt((byte[])bytes);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(value, e);
        }
    }

    public String toString() {
        return this.string;
    }

    public byte[] toBytes() {
        return Base32Utils.decode((String)this.string);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tag)) {
            return false;
        }
        Tag that = (Tag)object;
        if (this.hash != that.hash) {
            return false;
        }
        return this.string.equals(that.string);
    }

    @Override
    public int compareTo(Tag tag) {
        return Integer.signum(this.string.compareTo(tag.string));
    }

    public static int calculateStringSize(int tagSize) {
        int numberOfBits = tagSize * 8;
        int stringSize = numberOfBits / 5;
        return stringSize += numberOfBits % 5 > 0 ? 1 : 0;
    }
}

