/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.validation.Constraint;
import javax.validation.Valid;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import net.sf.oval.Check;
import net.sf.oval.Validator;
import net.sf.oval.collection.CollectionFactory;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstructorConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodReturnValueConfiguration;
import net.sf.oval.configuration.pojo.elements.ParameterConfiguration;
import net.sf.oval.constraint.AssertFalseCheck;
import net.sf.oval.constraint.AssertNullCheck;
import net.sf.oval.constraint.AssertTrueCheck;
import net.sf.oval.constraint.AssertValidCheck;
import net.sf.oval.constraint.DigitsCheck;
import net.sf.oval.constraint.FutureCheck;
import net.sf.oval.constraint.MatchPatternCheck;
import net.sf.oval.constraint.MaxCheck;
import net.sf.oval.constraint.MinCheck;
import net.sf.oval.constraint.NotNullCheck;
import net.sf.oval.constraint.PastCheck;
import net.sf.oval.constraint.SizeCheck;
import net.sf.oval.guard.Guarded;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationAnnotationsConfigurer
implements Configurer {
    private static final Log LOG = Log.getLog(BeanValidationAnnotationsConfigurer.class);

    private List<ParameterConfiguration> _createParameterConfiguration(Annotation[][] paramAnnotations, Class<?>[] parameterTypes) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<ParameterConfiguration> paramCfg = cf.createList(paramAnnotations.length);
        List<Check> paramChecks = cf.createList(2);
        int i = 0;
        while (i < paramAnnotations.length) {
            Annotation[] annotationArray = paramAnnotations[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                this.initializeChecks(annotation, paramChecks);
                ++n2;
            }
            ParameterConfiguration pc = new ParameterConfiguration();
            paramCfg.add(pc);
            pc.type = parameterTypes[i];
            if (paramChecks.size() > 0) {
                pc.checks = paramChecks;
                paramChecks = cf.createList(2);
            }
            ++i;
        }
        return paramCfg;
    }

    protected void configureConstructorParameterChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        Constructor<?>[] constructorArray = classCfg.type.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> ctor = constructorArray[n2];
            List<ParameterConfiguration> paramCfg = this._createParameterConfiguration(ctor.getParameterAnnotations(), ctor.getParameterTypes());
            if (paramCfg.size() > 0) {
                if (classCfg.constructorConfigurations == null) {
                    classCfg.constructorConfigurations = cf.createSet(2);
                }
                ConstructorConfiguration cc = new ConstructorConfiguration();
                cc.parameterConfigurations = paramCfg;
                cc.postCheckInvariants = false;
                classCfg.constructorConfigurations.add(cc);
            }
            ++n2;
        }
    }

    protected void configureFieldChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<Check> checks = cf.createList(2);
        Field[] fieldArray = classCfg.type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Annotation[] annotationArray = field.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                this.initializeChecks(annotation, checks);
                ++n4;
            }
            if (checks.size() > 0) {
                if (classCfg.fieldConfigurations == null) {
                    classCfg.fieldConfigurations = cf.createSet(2);
                }
                FieldConfiguration fc = new FieldConfiguration();
                fc.name = field.getName();
                fc.checks = checks;
                classCfg.fieldConfigurations.add(fc);
                checks = cf.createList(2);
            }
            ++n2;
        }
    }

    protected void configureMethodChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<Check> returnValueChecks = cf.createList(2);
        Method[] methodArray = classCfg.type.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Annotation[] annotationArray = ReflectionUtils.getAnnotations(method, Boolean.TRUE.equals(classCfg.inspectInterfaces));
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                this.initializeChecks(annotation, returnValueChecks);
                ++n4;
            }
            List<ParameterConfiguration> paramCfg = this._createParameterConfiguration(ReflectionUtils.getParameterAnnotations(method, Boolean.TRUE.equals(classCfg.inspectInterfaces)), method.getParameterTypes());
            if (paramCfg.size() > 0 || returnValueChecks.size() > 0) {
                if (classCfg.methodConfigurations == null) {
                    classCfg.methodConfigurations = cf.createSet(2);
                }
                MethodConfiguration mc = new MethodConfiguration();
                mc.name = method.getName();
                mc.parameterConfigurations = paramCfg;
                mc.isInvariant = ReflectionUtils.isGetter(method);
                if (returnValueChecks.size() > 0) {
                    mc.returnValueConfiguration = new MethodReturnValueConfiguration();
                    mc.returnValueConfiguration.checks = returnValueChecks;
                    returnValueChecks = cf.createList(2);
                }
                classCfg.methodConfigurations.add(mc);
            }
            ++n2;
        }
    }

    @Override
    public ClassConfiguration getClassConfiguration(Class<?> clazz) {
        ClassConfiguration classCfg = new ClassConfiguration();
        classCfg.type = clazz;
        Guarded guarded = clazz.getAnnotation(Guarded.class);
        if (guarded == null) {
            classCfg.applyFieldConstraintsToConstructors = false;
            classCfg.applyFieldConstraintsToSetters = false;
            classCfg.assertParametersNotNull = false;
            classCfg.checkInvariants = false;
            classCfg.inspectInterfaces = false;
        } else {
            classCfg.applyFieldConstraintsToConstructors = guarded.applyFieldConstraintsToConstructors();
            classCfg.applyFieldConstraintsToSetters = guarded.applyFieldConstraintsToSetters();
            classCfg.assertParametersNotNull = guarded.assertParametersNotNull();
            classCfg.checkInvariants = guarded.checkInvariants();
            classCfg.inspectInterfaces = guarded.inspectInterfaces();
        }
        this.configureFieldChecks(classCfg);
        this.configureConstructorParameterChecks(classCfg);
        this.configureMethodChecks(classCfg);
        return classCfg;
    }

    @Override
    public ConstraintSetConfiguration getConstraintSetConfiguration(String constraintSetId) {
        return null;
    }

    protected void initializeChecks(Annotation annotation, Collection<Check> checks) {
        int n;
        MinCheck minCheck;
        MaxCheck maxCheck;
        assert (annotation != null);
        assert (checks != null);
        if (!(annotation instanceof Valid) && annotation.annotationType().getAnnotation(Constraint.class) == null) {
            return;
        }
        Class[] groups = null;
        AbstractAnnotationCheck check = null;
        if (annotation instanceof NotNull) {
            groups = ((NotNull)annotation).groups();
            check = new NotNullCheck();
        } else if (annotation instanceof Null) {
            groups = ((Null)annotation).groups();
            check = new AssertNullCheck();
        } else if (annotation instanceof Valid) {
            check = new AssertValidCheck();
        } else if (annotation instanceof AssertTrue) {
            groups = ((AssertTrue)annotation).groups();
            check = new AssertTrueCheck();
        } else if (annotation instanceof AssertFalse) {
            groups = ((AssertFalse)annotation).groups();
            check = new AssertFalseCheck();
        } else if (annotation instanceof DecimalMax) {
            groups = ((DecimalMax)annotation).groups();
            maxCheck = new MaxCheck();
            maxCheck.setMax(Double.parseDouble(((DecimalMax)annotation).value()));
            check = maxCheck;
        } else if (annotation instanceof DecimalMin) {
            groups = ((DecimalMin)annotation).groups();
            minCheck = new MinCheck();
            minCheck.setMin(Double.parseDouble(((DecimalMin)annotation).value()));
            check = minCheck;
        } else if (annotation instanceof Max) {
            groups = ((Max)annotation).groups();
            maxCheck = new MaxCheck();
            maxCheck.setMax(((Max)annotation).value());
            check = maxCheck;
        } else if (annotation instanceof Min) {
            groups = ((Min)annotation).groups();
            minCheck = new MinCheck();
            minCheck.setMin(((Min)annotation).value());
            check = minCheck;
        } else if (annotation instanceof Future) {
            groups = ((Future)annotation).groups();
            check = new FutureCheck();
        } else if (annotation instanceof Past) {
            groups = ((Past)annotation).groups();
            check = new PastCheck();
        } else if (annotation instanceof Pattern) {
            groups = ((Pattern)annotation).groups();
            MatchPatternCheck matchPatternCheck = new MatchPatternCheck();
            int iflag = 0;
            Pattern.Flag[] flagArray = ((Pattern)annotation).flags();
            int n2 = flagArray.length;
            n = 0;
            while (n < n2) {
                Pattern.Flag flag = flagArray[n];
                iflag |= flag.getValue();
                ++n;
            }
            matchPatternCheck.setPattern(((Pattern)annotation).regexp(), iflag);
            check = matchPatternCheck;
        } else if (annotation instanceof Digits) {
            groups = ((Digits)annotation).groups();
            DigitsCheck digitsCheck = new DigitsCheck();
            digitsCheck.setMaxFraction(((Digits)annotation).fraction());
            digitsCheck.setMaxInteger(((Digits)annotation).integer());
            check = digitsCheck;
        } else if (annotation instanceof Size) {
            groups = ((Size)annotation).groups();
            SizeCheck sizeCheck = new SizeCheck();
            sizeCheck.setMax(((Size)annotation).max());
            sizeCheck.setMin(((Size)annotation).min());
            check = sizeCheck;
        }
        if (check != null) {
            String message;
            Method getMessage = ReflectionUtils.getMethod(annotation.getClass(), "message", null);
            if (getMessage != null && (message = (String)ReflectionUtils.invokeMethod(getMessage, annotation, null)) != null && !message.startsWith("{javax.validation.constraints.")) {
                check.setMessage(message);
            }
            if (groups != null && groups.length > 0) {
                String[] profiles = new String[groups.length];
                int i = 0;
                int l = groups.length;
                while (i < l) {
                    profiles[i] = groups[i].getName();
                    ++i;
                }
                check.setProfiles(profiles);
            }
            checks.add(check);
            return;
        }
        Annotation[] list = null;
        if (annotation instanceof AssertFalse.List) {
            list = ((AssertFalse.List)annotation).value();
        } else if (annotation instanceof AssertTrue.List) {
            list = ((AssertTrue.List)annotation).value();
        } else if (annotation instanceof DecimalMax.List) {
            list = ((DecimalMax.List)annotation).value();
        } else if (annotation instanceof DecimalMin.List) {
            list = ((DecimalMin.List)annotation).value();
        } else if (annotation instanceof Digits.List) {
            list = ((Digits.List)annotation).value();
        } else if (annotation instanceof Future.List) {
            list = ((Future.List)annotation).value();
        } else if (annotation instanceof Max.List) {
            list = ((Max.List)annotation).value();
        } else if (annotation instanceof Min.List) {
            list = ((Min.List)annotation).value();
        } else if (annotation instanceof NotNull.List) {
            list = ((NotNull.List)annotation).value();
        } else if (annotation instanceof Null.List) {
            list = ((Null.List)annotation).value();
        } else if (annotation instanceof Past.List) {
            list = ((Past.List)annotation).value();
        } else if (annotation instanceof Pattern.List) {
            list = ((Pattern.List)annotation).value();
        } else if (annotation instanceof Size.List) {
            list = ((Size.List)annotation).value();
        }
        if (list != null) {
            Annotation[] annotationArray = list;
            n = list.length;
            int n3 = 0;
            while (n3 < n) {
                Annotation anno = annotationArray[n3];
                this.initializeChecks(anno, checks);
                ++n3;
            }
        } else {
            LOG.warn("Ignoring unsupported bean validation constraint annotation {1}", annotation);
            return;
        }
    }
}

