/*
 * Decompiled with CFR 0.152.
 */
package craterdog.utils;

public final class Base02Utils {
    private static final String lookupTable = "01";

    public static String encode(byte[] bytes) {
        return Base02Utils.encode(bytes, null);
    }

    public static String encode(byte[] bytes, String indentation) {
        StringBuilder result = new StringBuilder();
        int length = bytes.length;
        if (length == 0) {
            return "";
        }
        for (int i = 0; i < length; ++i) {
            if (indentation != null && length > 10 && i % 10 == 0) {
                result.append("\n");
                result.append(indentation);
            }
            for (int j = 0; j < 8; ++j) {
                int bit = (bytes[i] & 1 << 7 - j) >>> 7 - j;
                result.append(bit);
            }
        }
        return result.toString();
    }

    public static byte[] decode(String base2) {
        String string = base2.replaceAll("\\s", "");
        int length = string.length();
        byte[] bytes = new byte[(int)Math.ceil(length / 8)];
        for (int i = 0; i < bytes.length; ++i) {
            int b = 0;
            for (int j = 0; j < 8; ++j) {
                char character = string.charAt(i * 8 + j);
                int bit = lookupTable.indexOf(character);
                if (bit < 0) {
                    throw new NumberFormatException("Attempted to decode a string that is not base 2: " + string);
                }
                b = b << 1 | bit;
            }
            bytes[i] = (byte)b;
        }
        return bytes;
    }

    private Base02Utils() {
    }
}

