/*
 * Decompiled with CFR 0.152.
 */
package craterdog.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;

public final class ByteUtils {
    public static byte[] booleanToBytes(boolean b) {
        byte[] buffer = new byte[1];
        ByteUtils.booleanToBytes(b, buffer);
        return buffer;
    }

    public static int booleanToBytes(boolean b, byte[] buffer) {
        return ByteUtils.booleanToBytes(b, buffer, 0);
    }

    public static int booleanToBytes(boolean b, byte[] buffer, int index) {
        int length = 1;
        buffer[index] = (byte)(b ? 255 : 0);
        return length;
    }

    public static boolean bytesToBoolean(byte[] buffer) {
        return ByteUtils.bytesToBoolean(buffer, 0);
    }

    public static boolean bytesToBoolean(byte[] buffer, int index) {
        return buffer[index] != 0;
    }

    public static byte[] shortToBytes(short s) {
        byte[] buffer = new byte[2];
        ByteUtils.shortToBytes(s, buffer, 0);
        return buffer;
    }

    public static int shortToBytes(short s, byte[] buffer) {
        return ByteUtils.shortToBytes(s, buffer, 0);
    }

    public static int shortToBytes(short s, byte[] buffer, int index) {
        int length = 2;
        for (int i = 0; i < length; ++i) {
            buffer[index + length - i - 1] = (byte)(s >> i * 8);
        }
        return length;
    }

    public static short bytesToShort(byte[] buffer) {
        return ByteUtils.bytesToShort(buffer, 0);
    }

    public static short bytesToShort(byte[] buffer, int index) {
        int length = 2;
        short integer = 0;
        for (int i = 0; i < length; ++i) {
            integer = (short)(integer | (buffer[index + length - i - 1] & 0xFF) << i * 8);
        }
        return integer;
    }

    public static byte[] intToBytes(int i) {
        byte[] buffer = new byte[4];
        ByteUtils.intToBytes(i, buffer, 0);
        return buffer;
    }

    public static int intToBytes(int i, byte[] buffer) {
        return ByteUtils.intToBytes(i, buffer, 0);
    }

    public static int intToBytes(int i, byte[] buffer, int index) {
        int length = buffer.length - index;
        if (length > 4) {
            length = 4;
        }
        for (int j = 0; j < length; ++j) {
            buffer[index + length - j - 1] = (byte)(i >> j * 8);
        }
        return length;
    }

    public static int bytesToInt(byte[] buffer) {
        return ByteUtils.bytesToInt(buffer, 0);
    }

    public static int bytesToInt(byte[] buffer, int index) {
        int length = buffer.length - index;
        if (length > 4) {
            length = 4;
        }
        int integer = 0;
        for (int i = 0; i < length; ++i) {
            integer |= (buffer[index + length - i - 1] & 0xFF) << i * 8;
        }
        return integer;
    }

    public static byte[] longToBytes(long l) {
        byte[] buffer = new byte[8];
        ByteUtils.longToBytes(l, buffer, 0);
        return buffer;
    }

    public static int longToBytes(long l, byte[] buffer) {
        return ByteUtils.longToBytes(l, buffer, 0);
    }

    public static int longToBytes(long l, byte[] buffer, int index) {
        int length = buffer.length - index;
        if (length > 8) {
            length = 8;
        }
        for (int i = 0; i < length; ++i) {
            buffer[index + length - i - 1] = (byte)(l >> i * 8);
        }
        return length;
    }

    public static long bytesToLong(byte[] buffer) {
        return ByteUtils.bytesToLong(buffer, 0);
    }

    public static long bytesToLong(byte[] buffer, int index) {
        int length = buffer.length - index;
        if (length > 8) {
            length = 8;
        }
        long l = 0L;
        for (int i = 0; i < length; ++i) {
            l |= ((long)buffer[index + length - i - 1] & 0xFFL) << i * 8;
        }
        return l;
    }

    public static byte[] bigIntegerToBytes(BigInteger integer) {
        return integer.toByteArray();
    }

    public static int bigIntegerToBytes(BigInteger integer, byte[] buffer) {
        return ByteUtils.bigIntegerToBytes(integer, buffer, 0);
    }

    public static int bigIntegerToBytes(BigInteger integer, byte[] buffer, int index) {
        int length = 4 + (integer.bitLength() + 8) / 8;
        System.arraycopy(ByteUtils.intToBytes(length), 0, buffer, index, 4);
        System.arraycopy(integer.toByteArray(), 0, buffer, index += 4, length - 4);
        return length;
    }

    public static BigInteger bytesToBigInteger(byte[] buffer) {
        return new BigInteger(buffer);
    }

    public static BigInteger bytesToBigInteger(byte[] buffer, int index) {
        int length = ByteUtils.bytesToInt(buffer, index);
        byte[] bytes = new byte[length];
        System.arraycopy(buffer, index += 4, bytes, 0, length);
        return new BigInteger(bytes);
    }

    public static byte[] doubleToBytes(double d) {
        byte[] buffer = new byte[8];
        ByteUtils.doubleToBytes(d, buffer, 0);
        return buffer;
    }

    public static int doubleToBytes(double d, byte[] buffer) {
        return ByteUtils.doubleToBytes(d, buffer, 0);
    }

    public static int doubleToBytes(double s, byte[] buffer, int index) {
        long bits = Double.doubleToRawLongBits(s);
        int length = ByteUtils.longToBytes(bits, buffer, index);
        return length;
    }

    public static double bytesToDouble(byte[] buffer) {
        return ByteUtils.bytesToDouble(buffer, 0);
    }

    public static double bytesToDouble(byte[] buffer, int index) {
        long bits = ByteUtils.bytesToLong(buffer, index);
        double real = Double.longBitsToDouble(bits);
        return real;
    }

    public static byte[] bigDecimalToBytes(BigDecimal decimal) {
        String string = decimal.toString();
        return ByteUtils.stringToBytes(string);
    }

    public static int bigDecimalToBytes(BigDecimal decimal, byte[] buffer) {
        return ByteUtils.bigDecimalToBytes(decimal, buffer, 0);
    }

    public static int bigDecimalToBytes(BigDecimal decimal, byte[] buffer, int index) {
        BigInteger intVal = decimal.unscaledValue();
        int length = 12 + (intVal.bitLength() + 8) / 8;
        int scale = decimal.scale();
        System.arraycopy(ByteUtils.intToBytes(scale), 0, buffer, index, 4);
        int precision = decimal.precision();
        System.arraycopy(ByteUtils.intToBytes(precision), 0, buffer, index += 4, 4);
        System.arraycopy(ByteUtils.bigIntegerToBytes(intVal), 0, buffer, index += 4, length - 8);
        return length;
    }

    public static BigDecimal bytesToBigDecimal(byte[] buffer) {
        String string = ByteUtils.bytesToString(buffer);
        return new BigDecimal(string);
    }

    public static BigDecimal bytesToBigDecimal(byte[] buffer, int index) {
        int scale = ByteUtils.bytesToInt(buffer, index);
        int precision = ByteUtils.bytesToInt(buffer, index += 4);
        BigInteger intVal = ByteUtils.bytesToBigInteger(buffer, index += 4);
        return new BigDecimal(intVal, scale, new MathContext(precision));
    }

    public static byte[] stringToBytes(String string) {
        return string.getBytes();
    }

    public static int stringToBytes(String string, byte[] buffer) {
        return ByteUtils.stringToBytes(string, buffer, 0);
    }

    public static int stringToBytes(String string, byte[] buffer, int index) {
        byte[] bytes = string.getBytes();
        int length = bytes.length;
        System.arraycopy(bytes, 0, buffer, index, length);
        return length;
    }

    public static String bytesToString(byte[] buffer) {
        return ByteUtils.bytesToString(buffer, 0, buffer.length);
    }

    public static String bytesToString(byte[] buffer, int index, int length) {
        return new String(buffer, index, length);
    }

    public static int byteToUnsigned(byte b) {
        int unsigned = b & 0xFF;
        return unsigned;
    }

    public static int hashCode(byte[] bytes) {
        int hash = Arrays.hashCode(bytes);
        return hash;
    }

    public static byte[] copy(byte[] bytes) {
        byte[] result = Arrays.copyOf(bytes, bytes.length);
        return result;
    }

    public static boolean equals(byte[] first, byte[] second) {
        return Arrays.equals(first, second);
    }

    public static int compare(byte[] first, byte[] second) {
        int firstLength = first.length;
        int secondLength = second.length;
        int shorterLength = Math.min(firstLength, secondLength);
        for (int i = 0; i < shorterLength; ++i) {
            int result = Byte.compare(first[i], second[i]);
            if (result == 0) continue;
            return Integer.signum(result);
        }
        if (firstLength < secondLength) {
            return -1;
        }
        if (firstLength > secondLength) {
            return 1;
        }
        return 0;
    }

    private ByteUtils() {
    }
}

