/*
 * Decompiled with CFR 0.152.
 */
package craterdog.utils;

import java.util.Comparator;

public class NaturalComparator<T>
implements Comparator<T> {
    @Override
    public int compare(T object1, T object2) {
        if (object1 != null) {
            if (object2 == null) {
                return 1;
            }
            if (object1 instanceof Comparable) {
                Comparable comparable1 = (Comparable)object1;
                return comparable1.compareTo(object2);
            }
            if (object1.getClass().isArray()) {
                Object[] array1 = (Object[])object1;
                Object[] array2 = (Object[])object2;
                return NaturalComparator.compareArrays(array1, array2);
            }
            String string1 = object1.toString();
            String string2 = object2.toString();
            return string1.compareTo(string2);
        }
        if (object2 != null) {
            return -1;
        }
        return 0;
    }

    private static int compareArrays(Object[] array1, Object[] array2) {
        NaturalComparator<Object> comparator = new NaturalComparator<Object>();
        int length = Math.min(array1.length, array2.length);
        for (int i = 0; i < length; ++i) {
            int result = comparator.compare(array1[i], array2[i]);
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(array1.length, array2.length);
    }
}

