/*
 * Decompiled with CFR 0.152.
 */
package craterdog.utils;

import craterdog.utils.RandomUtils;
import java.util.Arrays;
import java.util.Date;

public final class UniversalHashFunction {
    private static final int WORD_WIDTH = 32;
    private final int d;
    private final int a;
    private final int b;

    public UniversalHashFunction() {
        this(32);
    }

    public UniversalHashFunction(int hashWidth) {
        this.d = 32 - hashWidth;
        this.a = RandomUtils.pickRandomInt() & Integer.MAX_VALUE | 1;
        this.b = RandomUtils.pickRandomIndex(1 << this.d);
    }

    public UniversalHashFunction(int hashWidth, int a, int b) {
        this.d = 32 - hashWidth;
        this.a = a;
        this.b = b;
    }

    public int hashValue(Object object) {
        int x;
        if (object instanceof Boolean || object instanceof Character || object instanceof String || object instanceof Number || object instanceof Date) {
            x = object.hashCode();
        } else if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            x = Arrays.toString(array).hashCode();
        } else {
            x = object.toString().hashCode();
        }
        int hash = this.a * x + this.b >>> this.d;
        return hash;
    }
}

