/*
 * Decompiled with CFR 0.152.
 */
package craterdog.security;

import craterdog.primitives.Tag;
import craterdog.security.RsaAesMessageCryptex;
import craterdog.security.RsaCertificateManager;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class CertificateAuthorityGenerator {
    static XLogger logger = XLoggerFactory.getXLogger(CertificateAuthorityGenerator.class);
    private static final String CA_ALIAS = "Signer";

    public static void main(String[] args) {
        String environment = args[0];
        String organization = args.length > 1 ? args[1] : "Crater Dog Technologies\u2122";
        String country = args.length > 2 ? args[2] : "US";
        String filePrefix = environment + "-CA";
        try (FileOutputStream output = new FileOutputStream(filePrefix + ".p12");
             FileWriter pwFile = new FileWriter(filePrefix + ".pw");){
            logger.info("Generating a new key pair for the CA...");
            RsaAesMessageCryptex cryptex = new RsaAesMessageCryptex();
            RsaCertificateManager manager = new RsaCertificateManager();
            KeyPair caKeyPair = cryptex.generateKeyPair();
            PublicKey caPublicKey = caKeyPair.getPublic();
            PrivateKey caPrivateKey = caKeyPair.getPrivate();
            logger.info("Generating a self-signed CA certificate...");
            StringBuilder subjectBuilder = new StringBuilder();
            subjectBuilder.append("CN=");
            subjectBuilder.append(organization);
            subjectBuilder.append(" ");
            subjectBuilder.append(environment);
            subjectBuilder.append(" Private Certificate Authority, O=");
            subjectBuilder.append(organization);
            subjectBuilder.append(", C=");
            subjectBuilder.append(country);
            String caSubject = subjectBuilder.toString();
            BigInteger caSerialNumber = new BigInteger(new Tag(16).toBytes());
            long lifetime = 946080000000L;
            X509Certificate caCertificate = manager.createCertificateAuthority(caPrivateKey, caPublicKey, caSubject, caSerialNumber, lifetime);
            caCertificate.verify(caPublicKey);
            logger.info("Creating the CA key store...");
            char[] caPassword = new Tag(16).toString().toCharArray();
            KeyStore caKeyStore = manager.createPkcs12KeyStore(CA_ALIAS, caPassword, caPrivateKey, caCertificate);
            logger.info("Writing out the key store and password to files...");
            manager.saveKeyStore((OutputStream)output, caKeyStore, caPassword);
            pwFile.write(caPassword);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            logger.error("An error occurred while attempting to generate the certificate authority:", (Throwable)e);
            System.exit(1);
        }
        System.exit(0);
    }
}

