/*
 * Decompiled with CFR 0.152.
 */
package craterdog.security;

import craterdog.primitives.Tag;
import craterdog.security.RsaCertificateManager;
import craterdog.utils.RandomUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class ClientCertificateSigner {
    static XLogger logger = XLoggerFactory.getXLogger(ClientCertificateSigner.class);
    private static final String CA_ALIAS = "Signer";

    public static void main(String[] args) {
        String environment = args[0];
        String clientCertificatePrefix = args[1] + "-" + environment;
        String caKeyStorePrefix = args[2] + File.separator + environment + "-CA";
        try (FileReader pwReader = new FileReader(caKeyStorePrefix + ".pw");
             FileInputStream caInput = new FileInputStream(caKeyStorePrefix + ".p12");
             PemReader csrReader = new PemReader((Reader)new FileReader(clientCertificatePrefix + ".csr"));
             PemWriter pemWriter = new PemWriter((Writer)new FileWriter(clientCertificatePrefix + ".pem"));){
            logger.info("Loading the private certificate authority keys...");
            int size = new Tag(16).toString().length();
            char[] caPassword = new char[size];
            pwReader.read(caPassword);
            RsaCertificateManager manager = new RsaCertificateManager();
            KeyStore caKeyStore = manager.retrieveKeyStore((InputStream)caInput, caPassword);
            PrivateKey caPrivateKey = manager.retrievePrivateKey(caKeyStore, CA_ALIAS, caPassword);
            X509Certificate caCertificate = manager.retrieveCertificate(caKeyStore, CA_ALIAS);
            logger.info("Reading in the certificate signing request...");
            byte[] requestBytes = csrReader.readPemObject().getContent();
            PKCS10CertificationRequest csr = new PKCS10CertificationRequest(requestBytes);
            logger.info("Generating and signing a new client certificate...");
            long lifetime = 946080000000L;
            BigInteger serialNumber = new BigInteger(RandomUtils.generateRandomBytes((int)16));
            X509Certificate clientCertificate = manager.signCertificateRequest(caPrivateKey, caCertificate, csr, serialNumber, lifetime);
            clientCertificate.verify(caCertificate.getPublicKey());
            logger.info("Writing out the certificates to a file...");
            pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", clientCertificate.getEncoded()));
            pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", caCertificate.getEncoded()));
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            logger.error("An error occurred while attempting to generate the client certificate:", (Throwable)e);
            System.exit(1);
        }
        System.exit(0);
    }
}

