/*
 * Decompiled with CFR 0.152.
 */
package craterdog.security;

import craterdog.primitives.Tag;
import craterdog.security.RsaCertificateManager;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class CertificateAuthorityGenerator {
    static XLogger logger = XLoggerFactory.getXLogger(CertificateAuthorityGenerator.class);
    private static final String CA_ALIAS = "Signer";

    public static void main(String[] args) {
        String environment = args[0];
        String filePrefix = environment + "-CA";
        try (FileOutputStream output = new FileOutputStream(filePrefix + ".p12");
             FileWriter pwFile = new FileWriter(filePrefix + ".pw");){
            logger.info("Generating a new key pair for the CA...");
            RsaCertificateManager manager = new RsaCertificateManager();
            KeyPair caKeyPair = manager.generateKeyPair();
            PublicKey caPublicKey = caKeyPair.getPublic();
            PrivateKey caPrivateKey = caKeyPair.getPrivate();
            logger.info("Generating a self-signed CA certificate...");
            String caSubject = "CN=Crater Dog Technologies " + environment + " Private Certificate Authority, O=Crater Dog Technologies, C=US";
            BigInteger caSerialNumber = new BigInteger(new Tag().toBytes());
            long lifetime = 946080000000L;
            X509Certificate caCertificate = manager.createCertificateAuthority(caPrivateKey, caPublicKey, caSubject, caSerialNumber, lifetime);
            caCertificate.verify(caPublicKey);
            logger.info("Creating the CA key store...");
            char[] caPassword = new Tag().toString().toCharArray();
            KeyStore caKeyStore = manager.createPkcs12KeyStore(CA_ALIAS, caPassword, caPrivateKey, caCertificate);
            logger.info("Writing out the key store and password to files...");
            manager.saveKeyStore((OutputStream)output, caKeyStore, caPassword);
            pwFile.write(caPassword);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            logger.info("An error occurred while attempting to generate the certificate authority:", (Throwable)e);
            System.exit(1);
        }
        System.exit(0);
    }
}

