/*
 * Decompiled with CFR 0.152.
 */
package craterdog.primitives;

public final class Angle
implements Comparable<Angle> {
    static final double EPSILON = 1.0E-15;
    private final double value;
    public static final Angle PI = new Angle(Math.PI);

    public Angle() {
        this.value = 0.0;
    }

    public Angle(double value) {
        this.value = Angle.normalize(value);
    }

    @Override
    public int compareTo(Angle angle) {
        if (angle == null) {
            return 1;
        }
        return new Double(this.value).compareTo(angle.value);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Angle)) {
            return false;
        }
        Angle that = (Angle)obj;
        return this.value - that.value < 1.0E-15;
    }

    public int hashCode() {
        return new Double(this.value).hashCode();
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public double toDouble() {
        return this.value;
    }

    public static Angle invert(Angle angle) {
        return new Angle(angle.value - Math.PI);
    }

    public static Angle negate(Angle angle) {
        return new Angle(-angle.value);
    }

    public static Angle sum(Angle angle1, Angle angle2) {
        return new Angle(angle1.value + angle2.value);
    }

    public static Angle difference(Angle angle1, Angle angle2) {
        return new Angle(angle1.value - angle2.value);
    }

    public static Angle product(Angle angle, double multiplier) {
        return new Angle(angle.value * multiplier);
    }

    public static Angle quotient(Angle angle, double divisor) {
        return new Angle(angle.value / divisor);
    }

    public static double sine(Angle angle) {
        double result = Angle.lock(Math.sin(angle.value));
        return result;
    }

    public static Angle arcsine(double ratio) {
        return new Angle(Math.asin(ratio));
    }

    public static double cosine(Angle angle) {
        double result = Angle.lock(Math.cos(angle.value));
        return result;
    }

    public static Angle arccosine(double ratio) {
        return new Angle(Math.acos(ratio));
    }

    public static double tangent(Angle angle) {
        double result = Angle.lock(Math.tan(angle.value));
        return result;
    }

    public static Angle arctangent(double ratio) {
        return new Angle(Math.atan(ratio));
    }

    public static Angle arctangent(double y, double x) {
        return new Angle(Math.atan2(y, x));
    }

    private static double normalize(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new RuntimeException("Attempted to normalize an illegal angle value: " + Double.toString(value));
        }
        double twoPi = Math.PI * 2;
        double result = value % twoPi;
        if (result > Math.PI) {
            result -= twoPi;
        }
        if (result <= -Math.PI) {
            result += twoPi;
        }
        return result;
    }

    private static double lock(double value) {
        if (value <= -1.633123935319537E16) {
            return Double.NEGATIVE_INFINITY;
        }
        if (value >= 1.633123935319537E16) {
            return Double.POSITIVE_INFINITY;
        }
        if (value > -3.141592653589794 && value < -3.1415926535897922) {
            return -Math.PI;
        }
        if (value > 3.1415926535897922 && value < 3.141592653589794) {
            return Math.PI;
        }
        if (value > -2.718281828459046 && value < -2.718281828459044) {
            return -2.718281828459045;
        }
        if (value > 2.718281828459044 && value < 2.718281828459046) {
            return Math.E;
        }
        if (value > -1.000000000000001 && value < -0.999999999999999) {
            return -1.0;
        }
        if (value > 0.999999999999999 && value < 1.000000000000001) {
            return 1.0;
        }
        if (value <= 1.2246467991473532E-16 && value >= -1.2246467991473532E-16) {
            return 0.0;
        }
        return value;
    }
}

