/*
 * Decompiled with CFR 0.152.
 */
package craterdog.primitives;

import craterdog.core.Composite;
import craterdog.core.Sequential;
import craterdog.utils.Base02Utils;
import craterdog.utils.Base16Utils;
import craterdog.utils.Base32Utils;
import craterdog.utils.Base64Utils;
import craterdog.utils.ByteUtils;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class BinaryString
implements Comparable<BinaryString>,
Sequential<Byte>,
Composite {
    private final byte[] bytes;

    public BinaryString() {
        this.bytes = new byte[0];
    }

    public BinaryString(byte[] bytes) {
        this.bytes = Arrays.copyOf(bytes, bytes.length);
    }

    public BinaryString(Byte[] bytes) {
        int size = bytes.length;
        this.bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            this.bytes[i] = bytes[i];
        }
    }

    public BinaryString(String string, int base) {
        switch (base) {
            case 2: {
                this.bytes = Base02Utils.decode((String)string);
                break;
            }
            case 16: {
                this.bytes = Base16Utils.decode((String)string);
                break;
            }
            case 32: {
                this.bytes = Base32Utils.decode((String)string);
                break;
            }
            case 64: {
                this.bytes = Base64Utils.decode((String)string);
                break;
            }
            default: {
                throw new NumberFormatException("Base " + base + " binary strings not supported.");
            }
        }
    }

    public BinaryString(BitSet bits) {
        this.bytes = bits.toByteArray();
    }

    @Override
    public int compareTo(BinaryString that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        int result = 0;
        Iterator<Byte> thisIterator = this.iterator();
        Iterator<Byte> thatIterator = that.iterator();
        while (thisIterator.hasNext() && thatIterator.hasNext()) {
            Byte thisElement = thisIterator.next();
            Byte thatElement = thatIterator.next();
            result = Integer.compare(ByteUtils.byteToUnsigned((byte)thisElement), ByteUtils.byteToUnsigned((byte)thatElement));
            if (result == 0) continue;
            break;
        }
        if (result == 0) {
            result = Integer.compare(this.getNumberOfElements(), that.getNumberOfElements());
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BinaryString)) {
            return false;
        }
        BinaryString that = (BinaryString)object;
        if (this == that) {
            return true;
        }
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return this.toString(64);
    }

    public String toString(String indentation) {
        return this.toString(64, indentation);
    }

    public String toString(int base) {
        return this.toString(base, "");
    }

    public String toString(int base, String indentation) {
        switch (base) {
            case 2: {
                return Base02Utils.encode((byte[])this.bytes, (String)indentation);
            }
            case 16: {
                return Base16Utils.encode((byte[])this.bytes, (String)indentation);
            }
            case 32: {
                return Base32Utils.encode((byte[])this.bytes, (String)indentation);
            }
            case 64: {
                return Base64Utils.encode((byte[])this.bytes, (String)indentation);
            }
        }
        throw new NumberFormatException("Base " + base + " binary strings not supported.");
    }

    public byte[] toBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public int getNumberOfElements() {
        return this.bytes.length;
    }

    public Byte[] toArray() {
        Byte[] array = new Byte[this.bytes.length];
        int index = 0;
        Iterator<Byte> iterator = this.iterator();
        while (iterator.hasNext()) {
            Byte b = iterator.next();
            array[index++] = b;
        }
        return array;
    }

    public Iterator<Byte> iterator() {
        return new BinaryIterator();
    }

    private final class BinaryIterator
    implements Iterator<Byte> {
        int index = 0;

        private BinaryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < BinaryString.this.bytes.length;
        }

        @Override
        public Byte next() {
            if (this.index == BinaryString.this.bytes.length) {
                throw new NoSuchElementException();
            }
            Byte element = BinaryString.this.bytes[this.index++];
            return element;
        }
    }
}

