/*
 * Decompiled with CFR 0.152.
 */
package craterdog.primitives;

import craterdog.utils.RandomUtils;

public final class Probability
implements Comparable<Probability> {
    private final double value;

    public Probability() {
        this.value = RandomUtils.pickRandomProbability();
    }

    public Probability(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new NumberFormatException("Attempted to set the value of a probability outside the range of 0.0 - 1.0: " + value);
        }
        this.value = value;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public int compareTo(Probability probability) {
        if (probability == null) {
            return 1;
        }
        return new Double(this.value).compareTo(probability.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Probability)) {
            return false;
        }
        Probability that = (Probability)obj;
        return this.value == that.value;
    }

    public int hashCode() {
        int hash = new Double(this.value).hashCode();
        return hash;
    }

    public boolean toBoolean() {
        return this.value > 0.5;
    }

    public double toDouble() {
        return this.value;
    }

    public static boolean coinToss(Probability probability) {
        double toss = RandomUtils.pickRandomProbability();
        return probability.value > toss;
    }

    public static Probability not(Probability probability) {
        return new Probability(1.0 - probability.value);
    }

    public static Probability and(Probability probability1, Probability probability2) {
        return new Probability(probability1.value * probability2.value);
    }

    public static Probability sans(Probability probability1, Probability probability2) {
        return Probability.and(probability1, Probability.not(probability2));
    }

    public static Probability or(Probability probability1, Probability probability2) {
        return new Probability(probability1.value + probability2.value - Probability.and((Probability)probability1, (Probability)probability2).value);
    }

    public static Probability xor(Probability probability1, Probability probability2) {
        return new Probability(Probability.sans((Probability)probability1, (Probability)probability2).value + Probability.sans((Probability)probability2, (Probability)probability1).value);
    }
}

