/*
 * Decompiled with CFR 0.152.
 */
package craterdog.primitives;

import craterdog.core.Sequential;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class TextString
implements Comparable<TextString>,
CharSequence,
Sequential<Character> {
    private final String value;

    public TextString() {
        this.value = "";
    }

    public TextString(String value) {
        this.value = value;
    }

    public TextString(CharSequence value) {
        this.value = value.toString();
    }

    public TextString(char[] value) {
        this.value = String.copyValueOf(value);
    }

    public TextString(Character[] value) {
        int size = value.length;
        char[] array = new char[size];
        for (int i = 0; i < size; ++i) {
            array[i] = value[i].charValue();
        }
        this.value = new String(array);
    }

    @Override
    public int compareTo(TextString that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.value.compareTo(that.value);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TextString)) {
            return false;
        }
        TextString that = (TextString)object;
        if (this == that) {
            return true;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new TextString(this.value.subSequence(start, end));
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public int getNumberOfElements() {
        return this.value.length();
    }

    public Character[] toArray() {
        Character[] array = new Character[this.value.length()];
        int index = 0;
        Iterator<Character> iterator = this.iterator();
        while (iterator.hasNext()) {
            Character c = iterator.next();
            array[index++] = c;
        }
        return array;
    }

    public Iterator<Character> iterator() {
        return new TextIterator();
    }

    private final class TextIterator
    implements Iterator<Character> {
        int index = 0;

        private TextIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < TextString.this.length();
        }

        @Override
        public Character next() {
            if (this.index == TextString.this.length()) {
                throw new NoSuchElementException();
            }
            Character element = Character.valueOf(TextString.this.value.charAt(this.index++));
            return element;
        }
    }
}

