/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Locale;
import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.NotEqual;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotEqualCheck
extends AbstractAnnotationCheck<NotEqual> {
    private static final long serialVersionUID = 1L;
    private boolean ignoreCase;
    private String testString;
    private transient String testStringLowerCase;

    @Override
    public void configure(NotEqual constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setIgnoreCase(constraintAnnotation.ignoreCase());
        this.setTestString(constraintAnnotation.value());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("ignoreCase", Boolean.toString(this.ignoreCase));
        messageVariables.put("testString", this.testString);
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public String getTestString() {
        return this.testString;
    }

    private String getTestStringLowerCase() {
        if (this.testStringLowerCase == null && this.testString != null) {
            this.testStringLowerCase = this.testString.toLowerCase(Locale.getDefault());
        }
        return this.testStringLowerCase;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        if (this.ignoreCase) {
            return !valueToValidate.toString().toLowerCase(Locale.getDefault()).equals(this.getTestStringLowerCase());
        }
        return !valueToValidate.toString().equals(this.testString);
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.requireMessageVariablesRecreation();
    }

    public void setTestString(String testString) {
        this.testString = testString;
        this.requireMessageVariablesRecreation();
    }
}

