/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.ExpressionLanguage;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ObjectCache;
import net.sf.oval.internal.util.ThreadLocalObjectCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageGroovyImpl
implements ExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageGroovyImpl.class);
    private static final GroovyShell GROOVY_SHELL = new GroovyShell();
    private final ThreadLocalObjectCache<String, Script> threadScriptCache = new ThreadLocalObjectCache();

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        LOG.debug("Evaluating Groovy expression: {1}", expression);
        try {
            ObjectCache scriptCache = (ObjectCache)this.threadScriptCache.get();
            Script script = (Script)scriptCache.get(expression);
            if (script == null) {
                script = GROOVY_SHELL.parse(expression);
                scriptCache.put(expression, script);
            }
            Binding binding = new Binding();
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                binding.setVariable(entry.getKey(), entry.getValue());
            }
            script.setBinding(binding);
            return script.run();
        }
        catch (Exception ex) {
            throw new ExpressionEvaluationException("Evaluating script with Groovy failed.", ex);
        }
    }

    @Override
    public boolean evaluateAsBoolean(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        Object result = this.evaluate(expression, values);
        if (!(result instanceof Boolean)) {
            throw new ExpressionEvaluationException("The script must return a boolean value.");
        }
        return (Boolean)result;
    }
}

