/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.localization.message;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.oval.Validator;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.localization.message.MessageResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleMessageResolver
implements MessageResolver {
    private static final Log LOG = Log.getLog(ResourceBundleMessageResolver.class);
    public static final ResourceBundleMessageResolver INSTANCE = new ResourceBundleMessageResolver();
    private final Map<ResourceBundle, List<String>> messageBundleKeys = Validator.getCollectionFactory().createMap(8);
    private final Map<Locale, ArrayList<ResourceBundle>> messageBundlesByLocale = Validator.getCollectionFactory().createMap(8);

    public boolean addMessageBundle(ResourceBundle messageBundle) {
        return this.addMessageBundle(messageBundle, messageBundle.getLocale());
    }

    protected boolean addMessageBundle(ResourceBundle messageBundle, Locale locale) {
        ArrayList<ResourceBundle> messageBundles = this.getMessageBundlesForLocale(locale);
        if (messageBundles.contains(messageBundle)) {
            return false;
        }
        messageBundles.add(0, messageBundle);
        if (!this.messageBundleKeys.containsKey(messageBundle)) {
            List keys = Validator.getCollectionFactory().createList();
            Enumeration<String> keysEnum = messageBundle.getKeys();
            while (keysEnum.hasMoreElements()) {
                keys.add(keysEnum.nextElement());
            }
            this.messageBundleKeys.put(messageBundle, keys);
        }
        return true;
    }

    @Override
    public String getMessage(String key) {
        Locale l = Validator.getLocaleProvider().getLocale();
        String msg = this.getMessage(key, l);
        if (msg == null && !l.equals(Locale.getDefault())) {
            msg = this.getMessage(key, Locale.getDefault());
        }
        return msg;
    }

    protected String getMessage(String key, Locale locale) {
        ArrayList<ResourceBundle> messageBundles = this.getMessageBundlesForLocale(locale);
        for (ResourceBundle bundle : messageBundles) {
            List<String> keys = this.messageBundleKeys.get(bundle);
            if (!keys.contains(key)) continue;
            return bundle.getString(key);
        }
        return null;
    }

    private ArrayList<ResourceBundle> getMessageBundlesForLocale(Locale locale) {
        Assert.argumentNotNull("locale", locale);
        ArrayList<ResourceBundle> mbs = this.messageBundlesByLocale.get(locale);
        if (mbs == null) {
            mbs = new ArrayList();
            this.messageBundlesByLocale.put(locale, mbs);
            try {
                this.addMessageBundle(ResourceBundle.getBundle("net/sf/oval/Messages", locale), locale);
            }
            catch (MissingResourceException ex) {
                LOG.debug("No message bundle net.sf.oval.Messages for locale %s found.", (Object)ex, locale);
            }
        }
        return mbs;
    }

    public boolean removeMessageBundle(ResourceBundle messageBundle) {
        ArrayList<ResourceBundle> messageBundles = this.getMessageBundlesForLocale(messageBundle.getLocale());
        if (!messageBundles.contains(messageBundle)) {
            return false;
        }
        messageBundles.remove(messageBundle);
        this.messageBundleKeys.remove(messageBundle);
        return true;
    }
}

