/*
 * Decompiled with CFR 0.152.
 */
package craterdog.utils;

public final class Base16Utils {
    private static final String lookupTable = "0123456789ABCDEF";

    public static String encode(byte[] bytes) {
        return Base16Utils.encode(bytes, null);
    }

    public static String encode(byte[] bytes, String indentation) {
        StringBuilder result = new StringBuilder();
        int length = bytes.length;
        if (length == 0) {
            return "";
        }
        for (int i = 0; i < length; ++i) {
            if (indentation != null && length > 40 && i % 40 == 0) {
                result.append("\n");
                result.append(indentation);
            }
            int nibble = (bytes[i] & 0xF0) >>> 4;
            result.append(lookupTable.charAt(nibble));
            nibble = bytes[i] & 0xF;
            result.append(lookupTable.charAt(nibble));
        }
        return result.toString();
    }

    public static byte[] decode(String base16) {
        String string = base16.replaceAll("\\s", "");
        int length = string.length();
        byte[] bytes = new byte[(int)Math.ceil(length / 2)];
        for (int i = 0; i < bytes.length; ++i) {
            char firstCharacter = string.charAt(i * 2);
            int firstNibble = lookupTable.indexOf(firstCharacter);
            if (firstNibble < 0) {
                throw new NumberFormatException("Attempted to decode a string that is not base 16: " + string);
            }
            char secondCharacter = string.charAt(i * 2 + 1);
            int secondNibble = lookupTable.indexOf(secondCharacter);
            if (secondNibble < 0) {
                throw new NumberFormatException("Attempted to decode a string that is not base 16: " + string);
            }
            bytes[i] = (byte)(firstNibble << 4 | secondNibble);
        }
        return bytes;
    }

    private Base16Utils() {
    }
}

