/*
 * Decompiled with CFR 0.152.
 */
package craterdog.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public abstract class CertificateManager {
    static final XLogger logger = XLoggerFactory.getXLogger(CertificateManager.class);
    private static final String KEY_STORE_FORMAT = "PKCS12";

    public abstract String getAsymmetricKeyType();

    public abstract int getAsymmetricalKeySize();

    public abstract String getHashAlgorithm();

    public abstract String getAsymmetricSignatureAlgorithm();

    public abstract KeyPair generateKeyPair();

    public final void saveKeyStore(OutputStream output, KeyStore keyStore, char[] password) throws IOException {
        logger.entry(new Object[0]);
        try {
            keyStore.store(output, password);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            RuntimeException exception = new RuntimeException("An unexpected exception occurred while attempting to save a keystore.", e);
            logger.throwing((Throwable)exception);
            throw exception;
        }
        logger.exit();
    }

    public final KeyStore retrieveKeyStore(InputStream input, char[] password) throws IOException {
        logger.entry(new Object[0]);
        try {
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_FORMAT);
            keyStore.load(input, password);
            logger.exit();
            return keyStore;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            RuntimeException exception = new RuntimeException("An unexpected exception occurred while attempting to retrieve a keystore.", e);
            logger.throwing((Throwable)exception);
            throw exception;
        }
    }

    public final X509Certificate retrieveCertificate(KeyStore keyStore, String certificateName) {
        try {
            logger.entry(new Object[0]);
            X509Certificate certificate = (X509Certificate)keyStore.getCertificate(certificateName);
            logger.exit();
            return certificate;
        }
        catch (KeyStoreException e) {
            RuntimeException exception = new RuntimeException("An unexpected exception occurred while attempting to retrieve a certificate.", e);
            logger.throwing((Throwable)exception);
            throw exception;
        }
    }

    public final PrivateKey retrievePrivateKey(KeyStore keyStore, String keyName, char[] password) {
        try {
            logger.entry(new Object[0]);
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyName, password);
            logger.exit();
            return privateKey;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            RuntimeException exception = new RuntimeException("An unexpected exception occurred while attempting to retrieve a private key.", e);
            logger.throwing((Throwable)exception);
            throw exception;
        }
    }

    public abstract X509Certificate createCertificateAuthority(PrivateKey var1, PublicKey var2, String var3, BigInteger var4, long var5);

    public abstract X509Certificate createCertificate(PrivateKey var1, X509Certificate var2, PublicKey var3, String var4, BigInteger var5, long var6);

    public final KeyStore createPkcs12KeyStore(String keyName, char[] password, PrivateKey privateKey, X509Certificate certificate) {
        logger.entry(new Object[0]);
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        certificates.add(certificate);
        KeyStore keyStore = this.createPkcs12KeyStore(keyName, password, privateKey, certificates);
        logger.exit();
        return keyStore;
    }

    public final KeyStore createPkcs12KeyStore(String keyName, char[] password, PrivateKey privateKey, List<X509Certificate> certificates) {
        try {
            logger.entry(new Object[0]);
            Certificate[] chain = new X509Certificate[certificates.size()];
            chain = certificates.toArray(chain);
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_FORMAT);
            keyStore.load(null, null);
            keyStore.setKeyEntry(keyName, privateKey, password, chain);
            logger.exit();
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            RuntimeException exception = new RuntimeException("An unexpected exception occurred while attempting to create a new keystore.", e);
            logger.throwing((Throwable)exception);
            throw exception;
        }
    }

    public abstract String encodePublicKey(PublicKey var1);

    public abstract PublicKey decodePublicKey(String var1);

    public abstract String encodeCertificate(X509Certificate var1);

    public abstract X509Certificate decodeCertificate(String var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String encodeKeyStore(KeyStore keyStore, char[] password) {
        logger.entry(new Object[0]);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            keyStore.store(out, password);
            out.flush();
            byte[] bytes = out.toByteArray();
            String encodedKeyStore = Base64.encodeBase64String((byte[])bytes);
            logger.exit();
            String string = encodedKeyStore;
            return string;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            RuntimeException exception = new RuntimeException("An unexpected exception occurred while attempting to encode a keystore.", e);
            logger.throwing((Throwable)exception);
            throw exception;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final KeyStore decodeKeyStore(String base64String, char[] password) {
        logger.entry(new Object[0]);
        byte[] bytes = Base64.decodeBase64((String)base64String);
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_FORMAT);
            keyStore.load(in, password);
            logger.exit();
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            RuntimeException exception = new RuntimeException("An unexpected exception occurred while attempting to decode a keystore.", e);
            logger.throwing((Throwable)exception);
            throw exception;
        }
    }
}

