/*
 * Decompiled with CFR 0.152.
 */
package craterdog.security;

import craterdog.utils.Base64Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import org.apache.commons.io.IOUtils;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public abstract class MessageCryptex {
    static XLogger logger = XLoggerFactory.getXLogger(MessageCryptex.class);

    public final String encodeBytes(byte[] bytes) {
        logger.entry(new Object[0]);
        String base64String = Base64Utils.encode((byte[])bytes);
        logger.exit();
        return base64String;
    }

    public final String encodeBytes(byte[] bytes, String indentation) {
        logger.entry(new Object[0]);
        String base64String = Base64Utils.encode((byte[])bytes, (String)indentation);
        logger.exit();
        return base64String;
    }

    public final byte[] decodeString(String base64String) {
        logger.entry(new Object[0]);
        byte[] decodedBytes = Base64Utils.decode((String)base64String);
        logger.exit();
        return decodedBytes;
    }

    public abstract String getHashAlgorithm();

    public abstract String hashString(String var1);

    public abstract String getSymmetricKeyType();

    public abstract int getSymmetricKeySize();

    public abstract String getSymmetricEncryptionAlgorithm();

    public abstract SecretKey generateSharedKey();

    /*
     * Enabled aggressive exception aggregation
     */
    public final byte[] encryptString(SecretKey sharedKey, String string) {
        logger.entry(new Object[0]);
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes("UTF-8"));){
            byte[] byArray;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                this.encryptStream(sharedKey, input, output);
                output.flush();
                byte[] encryptedString = output.toByteArray();
                logger.exit();
                byArray = encryptedString;
            }
            return byArray;
        }
        catch (IOException e) {
            RuntimeException exception = new RuntimeException("An unexpected exception occured while trying to encrypt a string.", e);
            logger.error(exception.toString());
            throw exception;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final String decryptString(SecretKey sharedKey, byte[] encryptedString) {
        logger.entry(new Object[0]);
        try (ByteArrayInputStream input = new ByteArrayInputStream(encryptedString);){
            String string;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                this.decryptStream(sharedKey, input, output);
                output.flush();
                String string2 = output.toString("UTF-8");
                logger.exit();
                string = string2;
            }
            return string;
        }
        catch (IOException e) {
            RuntimeException exception = new RuntimeException("An unexpected exception occured while trying to decrypt a string.", e);
            logger.error(exception.toString());
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encryptStream(SecretKey sharedKey, InputStream input, OutputStream output) throws IOException {
        logger.entry(new Object[0]);
        CipherOutputStream cipherOutput = null;
        byte[] buffer = new byte[2048];
        try {
            int bytesRead;
            logger.debug("Creating a special output stream to do the work...");
            cipherOutput = this.encryptionOutputStream(sharedKey, output);
            logger.debug("Reading from the input and writing to the encrypting output stream...");
            while ((bytesRead = input.read(buffer)) != -1) {
                cipherOutput.write(buffer, 0, bytesRead);
            }
            cipherOutput.flush();
        }
        finally {
            logger.debug("Purging any plaintext hanging around in memory...");
            Arrays.fill(buffer, (byte)0);
            if (cipherOutput != null) {
                cipherOutput.close();
            }
        }
        logger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decryptStream(SecretKey sharedKey, InputStream input, OutputStream output) throws IOException {
        logger.entry(new Object[0]);
        try (CipherInputStream cipherInput = null;){
            logger.debug("Creating a special input stream to do the work...");
            cipherInput = this.decryptionInputStream(sharedKey, input);
            logger.debug("Reading bytes, decrypting them, and writing them out...");
            IOUtils.copy((InputStream)cipherInput, (OutputStream)output);
            output.flush();
        }
        logger.exit();
    }

    public abstract CipherOutputStream encryptionOutputStream(SecretKey var1, OutputStream var2) throws IOException;

    public abstract CipherInputStream decryptionInputStream(SecretKey var1, InputStream var2) throws IOException;

    public abstract String getAsymmetricKeyType();

    public abstract int getAsymmetricKeySize();

    public abstract String getAsymmetricSignatureAlgorithm();

    public abstract String getAsymmetricEncryptionAlgorithm();

    public abstract KeyPair generateKeyPair();

    public final String encodePublicKey(PublicKey key) {
        return this.encodePublicKey(key, "");
    }

    public abstract String encodePublicKey(PublicKey var1, String var2);

    public abstract PublicKey decodePublicKey(String var1);

    public abstract String getPasswordEncodingType();

    public abstract SecretKey generatePasswordKey(char[] var1);

    public final String encodePrivateKey(PrivateKey privateKey, SecretKey passwordKey) {
        return this.encodePrivateKey(privateKey, passwordKey, "");
    }

    public abstract String encodePrivateKey(PrivateKey var1, SecretKey var2, String var3);

    public abstract PrivateKey decodePrivateKey(String var1, SecretKey var2);

    public abstract byte[] signBytes(PrivateKey var1, byte[] var2);

    public abstract boolean bytesAreValid(PublicKey var1, byte[] var2, byte[] var3);

    public abstract byte[] encryptSharedKey(PublicKey var1, SecretKey var2);

    public abstract SecretKey decryptSharedKey(PrivateKey var1, byte[] var2);
}

