/*
 * Decompiled with CFR 0.152.
 */
package craterdog.security;

import craterdog.security.MessageCryptex;
import craterdog.utils.RandomUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;

public final class RsaAesMessageCryptex
extends MessageCryptex {
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final String PASSWORD_ENCODING_TYPE = "PBEWithSHA1AndDESede";
    private static final String SYMMETRIC_KEY_TYPE = "AES";
    private static final int SYMMETRIC_KEY_SIZE = 128;
    private static final AlgorithmParameterSpec SYMMETRIC_IV_PARAMETER = new IvParameterSpec(new byte[16]);
    private static final String SYMMETRIC_ENCRYPTION_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String ASYMMETRIC_KEY_TYPE = "RSA";
    private static final int ASYMMETRIC_KEY_SIZE = 2048;
    private static final String ASYMMETRIC_SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String ASYMMETRIC_ENCRYPTION_ALGORITHM = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

    public String getHashAlgorithm() {
        return HASH_ALGORITHM;
    }

    public String hashString(String string) {
        try {
            logger.entry(new Object[0]);
            byte[] bytes = string.getBytes();
            MessageDigest hasher = MessageDigest.getInstance(HASH_ALGORITHM);
            byte[] hash = hasher.digest(bytes);
            String hashString = this.encodeBytes(hash);
            logger.exit();
            return hashString;
        }
        catch (NoSuchAlgorithmException e) {
            String message = "An unexpected exception occurred while attempting to hash a string.";
            RuntimeException exception = new RuntimeException(message, e);
            logger.error(message, (Throwable)exception);
            throw exception;
        }
    }

    public String getSymmetricKeyType() {
        return SYMMETRIC_KEY_TYPE;
    }

    public int getSymmetricKeySize() {
        return 128;
    }

    public String getSymmetricEncryptionAlgorithm() {
        return SYMMETRIC_ENCRYPTION_ALGORITHM;
    }

    public SecretKey generateSharedKey() {
        try {
            logger.entry(new Object[0]);
            KeyGenerator keyGenerator = KeyGenerator.getInstance(SYMMETRIC_KEY_TYPE);
            keyGenerator.init(128, RandomUtils.generator);
            SecretKey sharedKey = keyGenerator.generateKey();
            logger.exit();
            return sharedKey;
        }
        catch (GeneralSecurityException e) {
            String message = "An exception occured while trying to generate a shared key.";
            RuntimeException exception = new RuntimeException(message, e);
            logger.error(message, (Throwable)exception);
            throw exception;
        }
    }

    public CipherOutputStream encryptionOutputStream(SecretKey sharedKey, OutputStream output) throws IOException {
        try {
            logger.entry(new Object[0]);
            logger.debug("Creating and initializing the encryption engine...");
            Cipher cipher = Cipher.getInstance(SYMMETRIC_ENCRYPTION_ALGORITHM);
            cipher.init(1, (Key)sharedKey, SYMMETRIC_IV_PARAMETER);
            logger.debug("Creating a special output stream to do the work...");
            CipherOutputStream cipherOutputStream = new CipherOutputStream(output, cipher);
            logger.exit();
            return cipherOutputStream;
        }
        catch (GeneralSecurityException e) {
            String message = "An exception occured while trying to encrypt a stream.";
            RuntimeException exception = new RuntimeException(message, e);
            logger.error(message, (Throwable)exception);
            throw exception;
        }
    }

    public CipherInputStream decryptionInputStream(SecretKey sharedKey, InputStream input) throws IOException {
        try {
            logger.entry(new Object[0]);
            logger.debug("Creating and initializing the decryption engine...");
            Cipher cipher = Cipher.getInstance(SYMMETRIC_ENCRYPTION_ALGORITHM);
            cipher.init(2, (Key)sharedKey, SYMMETRIC_IV_PARAMETER);
            logger.debug("Creating a special input stream to do the work...");
            CipherInputStream cipherInputStream = new CipherInputStream(input, cipher);
            logger.exit();
            return cipherInputStream;
        }
        catch (GeneralSecurityException e) {
            String message = "An exception occured while trying to decrypt a stream.";
            RuntimeException exception = new RuntimeException(message, e);
            logger.error(message, (Throwable)exception);
            throw exception;
        }
    }

    public String getAsymmetricKeyType() {
        return ASYMMETRIC_KEY_TYPE;
    }

    public int getAsymmetricKeySize() {
        return 2048;
    }

    public String getAsymmetricSignatureAlgorithm() {
        return ASYMMETRIC_SIGNATURE_ALGORITHM;
    }

    public String getAsymmetricEncryptionAlgorithm() {
        return ASYMMETRIC_ENCRYPTION_ALGORITHM;
    }

    public KeyPair generateKeyPair() {
        try {
            logger.entry(new Object[0]);
            KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance(ASYMMETRIC_KEY_TYPE);
            keyGenerator.initialize(2048, RandomUtils.generator);
            KeyPair keyPair = keyGenerator.generateKeyPair();
            logger.exit();
            return keyPair;
        }
        catch (GeneralSecurityException e) {
            String message = "An unexpected exception occurred while attempting to generate a new key pair.";
            RuntimeException exception = new RuntimeException(message, e);
            logger.error(message, (Throwable)exception);
            throw exception;
        }
    }

    public String encodePublicKey(PublicKey key, String indentation) {
        logger.entry(new Object[0]);
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.append(indentation).append("-----BEGIN PUBLIC KEY-----\n");
            buffer.append(this.encodeBytes(key.getEncoded(), indentation));
            buffer.append("\n").append(indentation).append("-----END PUBLIC KEY-----");
            String result = buffer.toString();
            logger.exit();
            return result;
        }
        catch (Exception e) {
            String message = "An unexpected exception occurred while attempting to encode a public key.";
            RuntimeException exception = new RuntimeException(message, e);
            logger.error(message, (Throwable)exception);
            throw exception;
        }
    }

    public PublicKey decodePublicKey(String pem) {
        logger.entry(new Object[0]);
        try {
            logger.debug("Unwrapping the PEM encoding...");
            String base64Encoded = pem.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
            byte[] keyBytes = this.decodeString(base64Encoded);
            logger.debug("Decoding the public key...");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory factory = KeyFactory.getInstance(ASYMMETRIC_KEY_TYPE);
            PublicKey result = factory.generatePublic(keySpec);
            logger.exit();
            return result;
        }
        catch (GeneralSecurityException e) {
            String message = "An unexpected exception occurred while attempting to decode a public key.";
            RuntimeException exception = new RuntimeException(message, e);
            logger.error(message, (Throwable)exception);
            throw exception;
        }
    }

    public String getPasswordEncodingType() {
        return PASSWORD_ENCODING_TYPE;
    }

    public SecretKey generatePasswordKey(char[] password) {
        try {
            logger.entry(new Object[0]);
            SecretKeyFactory passwordFactory = SecretKeyFactory.getInstance(PASSWORD_ENCODING_TYPE);
            PBEKeySpec passwordSpec = new PBEKeySpec(password);
            SecretKey passwordKey = passwordFactory.generateSecret(passwordSpec);
            passwordSpec.clearPassword();
            logger.exit();
            SecretKey secretKey = passwordKey;
            return secretKey;
        }
        catch (GeneralSecurityException e) {
            String message = "An unexpected exception occurred while attempting to generate a password key.";
            RuntimeException exception = new RuntimeException(message, e);
            logger.error(message, (Throwable)exception);
            throw exception;
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    public String encodePrivateKey(PrivateKey privateKey, SecretKey passwordKey, String indentation) {
        String string;
        block7: {
            logger.entry(new Object[0]);
            byte[] keyBytes = null;
            try {
                logger.debug("Encrypting the private key using the secret key...");
                Cipher cipher = Cipher.getInstance(PASSWORD_ENCODING_TYPE);
                cipher.init(1, passwordKey);
                keyBytes = privateKey.getEncoded();
                byte[] encryptedBytes = cipher.doFinal(keyBytes);
                logger.debug("Encoding the encrypted bytes in PKCS8 format...");
                AlgorithmParameters params = cipher.getParameters();
                EncryptedPrivateKeyInfo encryptedKeyInfo = new EncryptedPrivateKeyInfo(params, encryptedBytes);
                try {
                    passwordKey.destroy();
                }
                catch (DestroyFailedException destroyFailedException) {
                    // empty catch block
                }
                logger.debug("Wrapping the encrypted bytes in PEM encoding...");
                StringBuilder buffer = new StringBuilder();
                buffer.append(indentation).append("-----BEGIN ENCRYPTED PRIVATE KEY-----\n");
                buffer.append(this.encodeBytes(encryptedKeyInfo.getEncoded(), indentation));
                buffer.append("\n").append(indentation).append("-----END ENCRYPTED PRIVATE KEY-----");
                String pem = buffer.toString();
                logger.exit();
                string = pem;
                if (keyBytes == null) break block7;
            }
            catch (IOException | GeneralSecurityException e) {
                try {
                    String message = "An unexpected exception occurred while attempting to encode a private key.";
                    RuntimeException exception = new RuntimeException(message, e);
                    logger.error(message, (Throwable)exception);
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (keyBytes != null) {
                        Arrays.fill(keyBytes, (byte)0);
                    }
                    throw throwable;
                }
            }
            Arrays.fill(keyBytes, (byte)0);
        }
        return string;
    }

    public PrivateKey decodePrivateKey(String pem, SecretKey passwordKey) {
        logger.entry(new Object[0]);
        try {
            logger.debug("Unwrapping the PEM encoding...");
            String base64Encoded = pem.replace("-----BEGIN ENCRYPTED PRIVATE KEY-----", "").replace("-----END ENCRYPTED PRIVATE KEY-----", "");
            byte[] encryptedBytes = this.decodeString(base64Encoded);
            EncryptedPrivateKeyInfo encryptedKeyInfo = new EncryptedPrivateKeyInfo(encryptedBytes);
            logger.debug("Decrypting the encrypted bytes from PKCS8 format...");
            PKCS8EncodedKeySpec pkcs8KeySpec = encryptedKeyInfo.getKeySpec(passwordKey);
            KeyFactory keyFactory = KeyFactory.getInstance(ASYMMETRIC_KEY_TYPE);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            logger.exit();
            PrivateKey privateKey2 = privateKey;
            return privateKey2;
        }
        catch (IOException | GeneralSecurityException e) {
            String message = "An unexpected exception occurred while attempting to decode a private key.";
            RuntimeException exception = new RuntimeException(message, e);
            logger.error(message, (Throwable)exception);
            throw exception;
        }
        finally {
            try {
                passwordKey.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {}
        }
    }

    public byte[] signBytes(PrivateKey privateKey, byte[] bytes) {
        try {
            logger.entry(new Object[0]);
            Signature signer = Signature.getInstance(ASYMMETRIC_SIGNATURE_ALGORITHM);
            signer.initSign(privateKey);
            signer.update(bytes);
            byte[] signature = signer.sign();
            logger.exit();
            return signature;
        }
        catch (GeneralSecurityException e) {
            String message = "An exception occured while trying to sign bytes.";
            RuntimeException exception = new RuntimeException(message, e);
            logger.error(message, (Throwable)exception);
            throw exception;
        }
    }

    public boolean bytesAreValid(PublicKey certificate, byte[] bytes, byte[] signature) {
        try {
            logger.entry(new Object[0]);
            Signature signer = Signature.getInstance(ASYMMETRIC_SIGNATURE_ALGORITHM);
            signer.initVerify(certificate);
            signer.update(bytes);
            boolean isValid = signer.verify(signature);
            logger.exit();
            return isValid;
        }
        catch (GeneralSecurityException e) {
            String message = "An exception occured while trying to validate signed bytes.";
            RuntimeException exception = new RuntimeException(message, e);
            logger.error(message, (Throwable)exception);
            throw exception;
        }
    }

    public byte[] encryptSharedKey(PublicKey publicKey, SecretKey sharedKey) {
        byte[] byArray;
        block5: {
            byte[] keyBytes = null;
            try {
                logger.entry(new Object[0]);
                Cipher cipher = Cipher.getInstance(ASYMMETRIC_ENCRYPTION_ALGORITHM);
                cipher.init(1, publicKey);
                keyBytes = sharedKey.getEncoded();
                byte[] encryptedKey = cipher.doFinal(keyBytes);
                logger.exit();
                byArray = encryptedKey;
                if (keyBytes == null) break block5;
            }
            catch (GeneralSecurityException e) {
                try {
                    String message = "An exception occured while trying to encrypt a shared key.";
                    RuntimeException exception = new RuntimeException(message, e);
                    logger.error(message, (Throwable)exception);
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (keyBytes != null) {
                        Arrays.fill(keyBytes, (byte)0);
                    }
                    throw throwable;
                }
            }
            Arrays.fill(keyBytes, (byte)0);
        }
        return byArray;
    }

    public SecretKey decryptSharedKey(PrivateKey privateKey, byte[] encryptedKey) {
        SecretKeySpec secretKeySpec;
        block5: {
            byte[] keyBytes = null;
            try {
                logger.entry(new Object[0]);
                Cipher cipher = Cipher.getInstance(ASYMMETRIC_ENCRYPTION_ALGORITHM);
                cipher.init(2, privateKey);
                keyBytes = cipher.doFinal(encryptedKey);
                SecretKeySpec sharedKey = new SecretKeySpec(keyBytes, SYMMETRIC_KEY_TYPE);
                logger.exit();
                secretKeySpec = sharedKey;
                if (keyBytes == null) break block5;
            }
            catch (GeneralSecurityException e) {
                try {
                    String message = "An exception occured while trying to decrypt a shared key.";
                    RuntimeException exception = new RuntimeException(message, e);
                    logger.error(message, (Throwable)exception);
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (keyBytes != null) {
                        Arrays.fill(keyBytes, (byte)0);
                    }
                    throw throwable;
                }
            }
            Arrays.fill(keyBytes, (byte)0);
        }
        return secretKeySpec;
    }
}

