/*
 * Decompiled with CFR 0.152.
 */
package craterdog.utils;

public final class Base02Utils {
    private static final String lookupTable = "01";

    public static String encode(byte[] bytes) {
        return Base02Utils.encode(bytes, null);
    }

    public static String encode(byte[] bytes, String indentation) {
        StringBuilder result = new StringBuilder();
        int length = bytes.length;
        if (length == 0) {
            return "";
        }
        if (indentation != null) {
            result.append(indentation);
        }
        Base02Utils.encodeByte(bytes, 0, result);
        for (int i = 1; i < length; ++i) {
            if (i % 10 == 0) {
                result.append("\n");
                if (indentation != null) {
                    result.append(indentation);
                }
            }
            Base02Utils.encodeByte(bytes, i, result);
        }
        return result.toString();
    }

    public static byte[] decode(String base2) {
        String string = base2.replaceAll("\\s", "");
        int length = string.length();
        byte[] bytes = new byte[(int)Math.ceil((double)length / 8.0)];
        for (int i = 0; i < bytes.length; ++i) {
            Base02Utils.decodeByte(string, i, bytes);
        }
        return bytes;
    }

    private static void encodeByte(byte[] bytes, int byteIndex, StringBuilder result) {
        for (int i = 0; i < 8; ++i) {
            int bit = (bytes[byteIndex] & 1 << 7 - i) >>> 7 - i;
            result.append(bit);
        }
    }

    private static void decodeByte(String string, int byteIndex, byte[] bytes) {
        int b = 0;
        for (int i = 0; i < 8; ++i) {
            char character = string.charAt(byteIndex * 8 + i);
            int bit = lookupTable.indexOf(character);
            if (bit < 0) {
                throw new NumberFormatException("Attempted to decode a string that is not base 2: " + string);
            }
            b = b << 1 | bit;
        }
        bytes[byteIndex] = (byte)b;
    }

    private Base02Utils() {
    }
}

