/*
 * Decompiled with CFR 0.152.
 */
package craterdog.utils;

public final class Base16Utils {
    private static final String lookupTable = "0123456789ABCDEF";

    public static String encode(byte[] bytes) {
        return Base16Utils.encode(bytes, null);
    }

    public static String encode(byte[] bytes, String indentation) {
        StringBuilder result = new StringBuilder();
        int length = bytes.length;
        if (length == 0) {
            return "";
        }
        if (indentation != null) {
            result.append(indentation);
        }
        Base16Utils.encodeByte(bytes, 0, result);
        for (int i = 1; i < length; ++i) {
            if (i % 40 == 0) {
                result.append("\n");
                if (indentation != null) {
                    result.append(indentation);
                }
            }
            Base16Utils.encodeByte(bytes, i, result);
        }
        return result.toString();
    }

    public static byte[] decode(String base16) {
        String string = base16.replaceAll("\\s", "");
        int length = string.length();
        byte[] bytes = new byte[(int)Math.ceil((double)length / 2.0)];
        for (int i = 0; i < bytes.length; ++i) {
            Base16Utils.decodeByte(string, i, bytes);
        }
        return bytes;
    }

    private static void encodeByte(byte[] bytes, int byteIndex, StringBuilder result) {
        int nibble = (bytes[byteIndex] & 0xF0) >>> 4;
        result.append(lookupTable.charAt(nibble));
        nibble = bytes[byteIndex] & 0xF;
        result.append(lookupTable.charAt(nibble));
    }

    private static void decodeByte(String string, int byteIndex, byte[] bytes) {
        char firstCharacter = string.charAt(byteIndex * 2);
        int firstNibble = lookupTable.indexOf(firstCharacter);
        if (firstNibble < 0) {
            throw new NumberFormatException("Attempted to decode a string that is not base 16: " + string);
        }
        char secondCharacter = string.charAt(byteIndex * 2 + 1);
        int secondNibble = lookupTable.indexOf(secondCharacter);
        if (secondNibble < 0) {
            throw new NumberFormatException("Attempted to decode a string that is not base 16: " + string);
        }
        bytes[byteIndex] = (byte)(firstNibble << 4 | secondNibble);
    }

    private Base16Utils() {
    }
}

