/*
 * Decompiled with CFR 0.152.
 */
package craterdog.utils;

public final class Base32Utils {
    private static final String lookupTable = "0123456789ABCDFGHJKLMNPQRSTVWXYZ";

    public static String encode(byte[] bytes) {
        return Base32Utils.encode(bytes, null);
    }

    public static String encode(byte[] bytes, String indentation) {
        StringBuilder result = new StringBuilder();
        int length = bytes.length;
        if (length == 0) {
            return "";
        }
        if (indentation != null) {
            result.append(indentation);
        }
        Base32Utils.encodeBytes(bytes[0], bytes[0], 0, result);
        for (int i = 1; i < length; ++i) {
            if (i % 50 == 0) {
                result.append("\n");
                if (indentation != null) {
                    result.append(indentation);
                }
            }
            Base32Utils.encodeBytes(bytes[i - 1], bytes[i], i, result);
        }
        Base32Utils.encodeLastByte(bytes[length - 1], length - 1, result);
        return result.toString();
    }

    public static byte[] decode(String base32) {
        String string = base32.replaceAll("\\s", "");
        int length = string.length();
        byte[] bytes = new byte[(int)((double)length * 5.0 / 8.0)];
        for (int i = 0; i < length - 1; ++i) {
            char character = string.charAt(i);
            byte chunk = (byte)lookupTable.indexOf(character);
            if (chunk < 0) {
                throw new NumberFormatException("Attempted to decode a string that is not base 32: " + string);
            }
            Base32Utils.decodeCharacter(chunk, i, bytes, 0);
        }
        if (length > 0) {
            char character = string.charAt(length - 1);
            byte chunk = (byte)lookupTable.indexOf(character);
            if (chunk < 0) {
                throw new NumberFormatException("Attempted to decode a string that is not base 32: " + string);
            }
            Base32Utils.decodeLastCharacter(chunk, length - 1, bytes, 0);
        }
        return bytes;
    }

    private static void encodeBytes(byte previous, byte current, int byteIndex, StringBuilder output) {
        int offset = byteIndex % 5;
        switch (offset) {
            case 0: {
                int chunk = (current & 0xF8) >>> 3;
                output.append(lookupTable.charAt(chunk));
                break;
            }
            case 1: {
                int chunk = (previous & 7) << 2 | (current & 0xC0) >>> 6;
                output.append(lookupTable.charAt(chunk));
                chunk = (current & 0x3E) >>> 1;
                output.append(lookupTable.charAt(chunk));
                break;
            }
            case 2: {
                int chunk = (previous & 1) << 4 | (current & 0xF0) >>> 4;
                output.append(lookupTable.charAt(chunk));
                break;
            }
            case 3: {
                int chunk = (previous & 0xF) << 1 | (current & 0x80) >>> 7;
                output.append(lookupTable.charAt(chunk));
                chunk = (current & 0x7C) >>> 2;
                output.append(lookupTable.charAt(chunk));
                break;
            }
            case 4: {
                int chunk = (previous & 3) << 3 | (current & 0xE0) >>> 5;
                output.append(lookupTable.charAt(chunk));
                chunk = current & 0x1F;
                output.append(lookupTable.charAt(chunk));
            }
        }
    }

    private static void encodeLastByte(byte last, int byteIndex, StringBuilder output) {
        int offset = byteIndex % 5;
        switch (offset) {
            case 0: {
                int chunk = (last & 7) << 2;
                output.append(lookupTable.charAt(chunk));
                break;
            }
            case 1: {
                int chunk = (last & 1) << 4;
                output.append(lookupTable.charAt(chunk));
                break;
            }
            case 2: {
                int chunk = (last & 0xF) << 1;
                output.append(lookupTable.charAt(chunk));
                break;
            }
            case 3: {
                int chunk = (last & 3) << 3;
                output.append(lookupTable.charAt(chunk));
                break;
            }
        }
    }

    private static void decodeCharacter(byte chunk, int characterIndex, byte[] bytes, int index) {
        int byteIndex = index + characterIndex * 5 / 8;
        int offset = characterIndex % 8;
        switch (offset) {
            case 0: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk << 3);
                break;
            }
            case 1: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk >>> 2);
                int n2 = byteIndex + 1;
                bytes[n2] = (byte)(bytes[n2] | chunk << 6);
                break;
            }
            case 2: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk << 1);
                break;
            }
            case 3: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk >>> 4);
                int n3 = byteIndex + 1;
                bytes[n3] = (byte)(bytes[n3] | chunk << 4);
                break;
            }
            case 4: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk >>> 1);
                int n4 = byteIndex + 1;
                bytes[n4] = (byte)(bytes[n4] | chunk << 7);
                break;
            }
            case 5: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk << 2);
                break;
            }
            case 6: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk >>> 3);
                int n5 = byteIndex + 1;
                bytes[n5] = (byte)(bytes[n5] | chunk << 5);
                break;
            }
            case 7: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk);
            }
        }
    }

    private static void decodeLastCharacter(byte chunk, int characterIndex, byte[] bytes, int index) {
        int byteIndex = index + characterIndex * 5 / 8;
        int offset = characterIndex % 8;
        switch (offset) {
            case 1: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk >>> 2);
                break;
            }
            case 3: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk >>> 4);
                break;
            }
            case 4: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk >>> 1);
                break;
            }
            case 6: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk >>> 3);
                break;
            }
            case 7: {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | chunk);
            }
        }
    }

    private Base32Utils() {
    }
}

