/*
 * Decompiled with CFR 0.152.
 */
package craterdog.security;

import craterdog.security.MessageCryptex;
import craterdog.security.RsaAesMessageCryptex;
import craterdog.utils.Base64Utils;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.util.StringValueResolver;

public class EncryptedPropertyConfigurer
extends PropertySourcesPlaceholderConfigurer {
    private static final MessageCryptex cryptex = new RsaAesMessageCryptex();
    private static final String ENCRYPTED_NOTATION = "{AES-128}";
    private static final String DEFAULT_ENCODED_KEY = "XbZHQYKRQcBoBXqU0G43Rw==";
    private final SecretKey key;

    public EncryptedPropertyConfigurer() {
        this.key = new SecretKeySpec(Base64Utils.decode((String)DEFAULT_ENCODED_KEY), cryptex.getSymmetricKeyType());
    }

    public EncryptedPropertyConfigurer(String encodedKey) {
        this.key = new SecretKeySpec(Base64Utils.decode((String)encodedKey), cryptex.getSymmetricKeyType());
    }

    public String encryptPropertyValue(String propertyValue) {
        byte[] bytes = cryptex.encryptString(this.key, propertyValue);
        String encryptedValue = Base64Utils.encode((byte[])bytes);
        return ENCRYPTED_NOTATION + encryptedValue;
    }

    protected void doProcessProperties(ConfigurableListableBeanFactory beanFactoryToProcess, StringValueResolver valueResolver) {
        StringValueResolver valueConvertingResolver = strVal -> this.convertPropertyValue(valueResolver.resolveStringValue(strVal));
        super.doProcessProperties(beanFactoryToProcess, valueConvertingResolver);
    }

    protected String convertPropertyValue(String propertyValue) {
        if (StringUtils.isNotBlank((CharSequence)propertyValue) && propertyValue.startsWith(ENCRYPTED_NOTATION)) {
            propertyValue = propertyValue.substring(ENCRYPTED_NOTATION.length());
            byte[] bytes = Base64Utils.decode((String)propertyValue);
            propertyValue = cryptex.decryptString(this.key, bytes);
        }
        return propertyValue;
    }
}

