/*
 * Decompiled with CFR 0.152.
 */
package craterdog.security;

import craterdog.security.MessageCryptex;
import craterdog.utils.Base64Utils;
import craterdog.utils.RandomUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class RsaAesMessageCryptex
extends MessageCryptex {
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final String ENCODING_TYPE = "AES-128-CBC-PKCS7";
    private static final String SYMMETRIC_KEY_TYPE = "AES";
    private static final int SYMMETRIC_KEY_SIZE = 128;
    private static final String SYMMETRIC_ENCRYPTION_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String ASYMMETRIC_KEY_TYPE = "RSA";
    private static final int ASYMMETRIC_KEY_SIZE = 2048;
    private static final String ASYMMETRIC_SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String ASYMMETRIC_ENCRYPTION_ALGORITHM = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

    public String getHashAlgorithm() {
        return HASH_ALGORITHM;
    }

    public String hashString(String string) {
        try {
            logger.entry(new Object[0]);
            byte[] bytes = string.getBytes();
            MessageDigest hasher = MessageDigest.getInstance(HASH_ALGORITHM);
            byte[] hash = hasher.digest(bytes);
            String hashString = Base64Utils.encode((byte[])hash);
            logger.exit();
            return hashString;
        }
        catch (NoSuchAlgorithmException e) {
            RuntimeException exception = new RuntimeException("An unexpected exception occurred while attempting to hash a string.", e);
            logger.error(exception.toString());
            throw exception;
        }
    }

    public String getEncodingType() {
        return ENCODING_TYPE;
    }

    public String getSymmetricKeyType() {
        return SYMMETRIC_KEY_TYPE;
    }

    public int getSymmetricKeySize() {
        return 128;
    }

    public SecretKey generateSharedKey() {
        try {
            logger.entry(new Object[0]);
            KeyGenerator keyGenerator = KeyGenerator.getInstance(SYMMETRIC_KEY_TYPE);
            keyGenerator.init(128, RandomUtils.generator);
            SecretKey sharedKey = keyGenerator.generateKey();
            logger.exit();
            return sharedKey;
        }
        catch (GeneralSecurityException e) {
            RuntimeException exception = new RuntimeException("An exception occured while trying to generate a shared key.", e);
            logger.error(exception.toString());
            throw exception;
        }
    }

    public String getSymmetricEncryptionAlgorithm() {
        return SYMMETRIC_ENCRYPTION_ALGORITHM;
    }

    public CipherOutputStream encryptionOutputStream(SecretKey sharedKey, OutputStream output) throws IOException {
        try {
            logger.entry(new Object[0]);
            logger.debug("Creating and initializing the encryption engine...");
            Cipher cipher = Cipher.getInstance(SYMMETRIC_ENCRYPTION_ALGORITHM);
            byte[] fixedIV = new byte[16];
            IvParameterSpec ivSpec = new IvParameterSpec(fixedIV);
            cipher.init(1, (Key)sharedKey, ivSpec);
            logger.debug("Creating a special output stream to do the work...");
            CipherOutputStream cipherOutputStream = new CipherOutputStream(output, cipher);
            logger.exit();
            return cipherOutputStream;
        }
        catch (GeneralSecurityException e) {
            RuntimeException exception = new RuntimeException("An exception occured while trying to encrypt a stream.", e);
            logger.error(exception.toString());
            throw exception;
        }
    }

    public CipherInputStream decryptionInputStream(SecretKey sharedKey, InputStream input) throws IOException {
        try {
            logger.entry(new Object[0]);
            logger.debug("Creating and initializing the decryption engine...");
            Cipher cipher = Cipher.getInstance(SYMMETRIC_ENCRYPTION_ALGORITHM);
            byte[] fixedIV = new byte[16];
            IvParameterSpec ivSpec = new IvParameterSpec(fixedIV);
            cipher.init(2, (Key)sharedKey, ivSpec);
            logger.debug("Creating a special input stream to do the work...");
            CipherInputStream cipherInputStream = new CipherInputStream(input, cipher);
            logger.exit();
            return cipherInputStream;
        }
        catch (GeneralSecurityException e) {
            RuntimeException exception = new RuntimeException("An exception occured while trying to decrypt a stream.", e);
            logger.error(exception.toString());
            throw exception;
        }
    }

    public String getAsymmetricKeyType() {
        return ASYMMETRIC_KEY_TYPE;
    }

    public int getAsymmetricKeySize() {
        return 2048;
    }

    public KeyPair generateKeyPair() {
        try {
            logger.entry(new Object[0]);
            KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance(ASYMMETRIC_KEY_TYPE);
            keyGenerator.initialize(2048, RandomUtils.generator);
            KeyPair keyPair = keyGenerator.generateKeyPair();
            logger.exit();
            return keyPair;
        }
        catch (NoSuchAlgorithmException e) {
            RuntimeException exception = new RuntimeException("An unexpected exception occurred while attempting to generate a new key pair.", e);
            logger.error(exception.toString());
            throw exception;
        }
    }

    public String getAsymmetricSignatureAlgorithm() {
        return ASYMMETRIC_SIGNATURE_ALGORITHM;
    }

    public byte[] signBytes(PrivateKey privateKey, byte[] bytes) {
        try {
            logger.entry(new Object[0]);
            Signature signer = Signature.getInstance(ASYMMETRIC_SIGNATURE_ALGORITHM);
            signer.initSign(privateKey);
            signer.update(bytes);
            byte[] signature = signer.sign();
            logger.exit();
            return signature;
        }
        catch (GeneralSecurityException e) {
            RuntimeException exception = new RuntimeException("An exception occured while trying to sign bytes.", e);
            logger.error(exception.toString());
            throw exception;
        }
    }

    public boolean bytesAreValid(PublicKey certificate, byte[] bytes, byte[] signature) {
        try {
            logger.entry(new Object[0]);
            Signature signer = Signature.getInstance(ASYMMETRIC_SIGNATURE_ALGORITHM);
            signer.initVerify(certificate);
            signer.update(bytes);
            boolean isValid = signer.verify(signature);
            logger.exit();
            return isValid;
        }
        catch (GeneralSecurityException e) {
            RuntimeException exception = new RuntimeException("An exception occured while trying to validate signed bytes.", e);
            logger.error(exception.toString());
            throw exception;
        }
    }

    public String getAsymmetricEncryptionAlgorithm() {
        return ASYMMETRIC_ENCRYPTION_ALGORITHM;
    }

    public byte[] encryptSharedKey(PublicKey publicKey, SecretKey sharedKey) {
        try {
            logger.entry(new Object[0]);
            Cipher cipher = Cipher.getInstance(ASYMMETRIC_ENCRYPTION_ALGORITHM);
            cipher.init(1, publicKey);
            byte[] encryptedKey = cipher.doFinal(sharedKey.getEncoded());
            logger.exit();
            return encryptedKey;
        }
        catch (GeneralSecurityException e) {
            RuntimeException exception = new RuntimeException("An exception occured while trying to encrypt a shared key.", e);
            logger.error(exception.toString());
            throw exception;
        }
    }

    public SecretKey decryptSharedKey(PrivateKey privateKey, byte[] encryptedKey) {
        try {
            logger.entry(new Object[0]);
            Cipher cipher = Cipher.getInstance(ASYMMETRIC_ENCRYPTION_ALGORITHM);
            cipher.init(2, privateKey);
            byte[] decryptedKey = cipher.doFinal(encryptedKey);
            SecretKeySpec sharedKey = new SecretKeySpec(decryptedKey, SYMMETRIC_KEY_TYPE);
            logger.exit();
            return sharedKey;
        }
        catch (GeneralSecurityException e) {
            RuntimeException exception = new RuntimeException("An exception occured while trying to decrypt a shared key.", e);
            logger.error(exception.toString());
            throw exception;
        }
    }
}

