/*
 * Decompiled with CFR 0.152.
 */
package com.daedafusion.hibernate;

import com.daedafusion.configuration.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javassist.util.proxy.ProxyFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.hibernate.service.ServiceRegistry;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class HibernateSessionFactory {
    private static final Logger log = Logger.getLogger(HibernateSessionFactory.class);
    private static HibernateSessionFactory ourInstance = new HibernateSessionFactory();
    private SessionFactory sessionFactory;

    public static HibernateSessionFactory getInstance() {
        return ourInstance;
    }

    private HibernateSessionFactory() {
        try {
            InputStream resource = Configuration.getInstance().getResource("hibernate.cfg.xml");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(resource);
            ClassLoaderHelper.overridenClassLoader = HibernateSessionFactory.class.getClassLoader();
            ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

                public ClassLoader get(ProxyFactory pf) {
                    return HibernateSessionFactory.class.getClassLoader();
                }
            };
            org.hibernate.cfg.Configuration config = new org.hibernate.cfg.Configuration();
            config.configure(doc);
            String resourceKeys = Configuration.getInstance().getString("hibernateMappingResources", null);
            if (resourceKeys != null) {
                String[] keys;
                for (String k : keys = resourceKeys.split(",")) {
                    InputStream r = Configuration.getInstance().getResource(k);
                    DocumentBuilder b = factory.newDocumentBuilder();
                    Document d = b.parse(r);
                    config.addDocument(d);
                }
            }
            config.setProperty("hibernate.connection.url", Configuration.getInstance().getString("databaseJdbc", "localhost"));
            config.setProperty("hibernate.connection.username", Configuration.getInstance().getString("databaseUsername", "root"));
            config.setProperty("hibernate.connection.password", Configuration.getInstance().getString("databasePassword", ""));
            StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)config.getProperties()).build();
            this.sessionFactory = config.buildSessionFactory((ServiceRegistry)serviceRegistry);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.error((Object)"Error initializing Hibernate configuration", (Throwable)e);
        }
    }

    public Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public void shutdown() {
        this.sessionFactory.close();
    }
}

