/*
 * Decompiled with CFR 0.152.
 */
package com.daedafusion.hibernate.dao;

import com.daedafusion.hibernate.HibernateSessionFactory;
import com.daedafusion.hibernate.dao.GenericDAO;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.LockOptions;
import org.hibernate.Session;

public abstract class AbstractDAO<T, ID extends Serializable>
implements GenericDAO<T, ID> {
    private static final Logger log = Logger.getLogger(AbstractDAO.class);
    private Class<T> persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private Session session;

    protected AbstractDAO() {
    }

    public void setSession(Session s) {
        this.session = s;
    }

    protected Session getSession() {
        if (this.session == null) {
            this.session = HibernateSessionFactory.getInstance().getSession();
        }
        return this.session;
    }

    protected Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public T findById(ID id) {
        return (T)this.getSession().load(this.getPersistentClass(), id);
    }

    @Override
    public T findById(ID id, boolean lock) {
        if (lock) {
            return (T)this.getSession().load(this.getPersistentClass(), id, LockOptions.UPGRADE);
        }
        return this.findById(id);
    }

    @Override
    public Collection<T> findAll() {
        Criteria crit = this.getSession().createCriteria(this.getPersistentClass());
        return new LinkedHashSet(crit.list());
    }

    @Override
    public T makePersistent(T entity) {
        this.getSession().saveOrUpdate(entity);
        return entity;
    }

    @Override
    public void makeTransient(T entity) {
        this.getSession().delete(entity);
    }
}

