/*
 * Decompiled with CFR 0.152.
 */
package com.daedafusion.hibernate.listener;

import com.daedafusion.hibernate.HibernateSessionFactory;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Logger;
import org.hibernate.StaleObjectStateException;

public class HibernateSessionFilter
implements Filter {
    private static final Logger log = Logger.getLogger(HibernateSessionFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        HibernateSessionFactory.getInstance();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HibernateSessionFactory.getInstance().getSession();
        try {
            chain.doFilter(request, response);
        }
        catch (StaleObjectStateException e) {
            HibernateSessionFactory.getInstance().getSession().getTransaction().rollback();
            throw e;
        }
        catch (Exception t) {
            try {
                if (HibernateSessionFactory.getInstance().getSession().getTransaction().isActive()) {
                    HibernateSessionFactory.getInstance().getSession().getTransaction().rollback();
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not rollback transaction after exception", (Throwable)e);
            }
            throw t;
        }
        finally {
            HibernateSessionFactory.getInstance().getSession().close();
        }
    }

    public void destroy() {
        HibernateSessionFactory.getInstance().shutdown();
    }
}

