package com.daikit.graphql.meta.custommethod;

import java.util.List;

/**
 * GraphQL dynamic method argument {@link List} of entities meta data
 *
 * @author Thibaut Caselli
 */
public class GQLMethodArgumentListEnumMetaData extends GQLAbstractMethodArgumentMetaData {

	private Class<?> enumClass;

	// *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	// CONSTRUCTORS
	// *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

	/**
	 * Default constructor
	 */
	public GQLMethodArgumentListEnumMetaData() {
		// Nothing done
	}

	/**
	 * Constructor passing name and entity class and keeping default values for
	 * other attributes.
	 *
	 * @param name
	 *            the name for the method argument. This name will be used for
	 *            building GraphQL schema query or mutation for this method
	 * @param enumClass
	 *            the enumeration class
	 */
	public GQLMethodArgumentListEnumMetaData(final String name, final Class<? extends Enum<?>> enumClass) {
		super(name);
		this.enumClass = enumClass;
	}

	// *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	// METHODS
	// *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

	@Override
	protected void appendToString(final StringBuilder stringBuilder) {
		stringBuilder.append("{METHOD-ARGUMENT-LIST-ENUM(").append(enumClass == null ? "" : enumClass.getSimpleName())
				.append(")}");
		super.appendToString(stringBuilder);
	}

	// *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	// GETTERS / SETTERS
	// *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

	/**
	 * Get the enumeration class
	 *
	 * @return the enumClass
	 */
	public Class<?> getEnumClass() {
		return enumClass;
	}

	/**
	 * Set the enumeration class
	 *
	 * @param enumClass
	 *            the enumClass to set
	 * @return this instance
	 */
	public GQLMethodArgumentListEnumMetaData setEnumClass(final Class<?> enumClass) {
		this.enumClass = enumClass;
		return this;
	}

}
