package com.daikit.graphql.meta.internal;

import com.daikit.graphql.meta.entity.GQLEntityMetaData;

/**
 * Meta data computed informations for concrete {@link GQLEntityMetaData}
 *
 * @author Thibaut Caselli
 */
public class GQLConcreteEntityMetaDataInfos extends GQLAbstractEntityMetaDataInfos {

	// *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	// CONSTRUCTORS
	// *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

	/**
	 * Constructor
	 *
	 * @param entity
	 *            the {@link GQLEntityMetaData}
	 */
	public GQLConcreteEntityMetaDataInfos(final GQLEntityMetaData entity) {
		super(entity);
	}

	// *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	// METHODS
	// *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder();
		sb.append("(INFOS-CONCRETE[").append(getEntity() == null ? "" : getEntity().toString()).append("])");
		return sb.toString();
	}

	// *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	// GETTERS / SETTERS
	// *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

}
