/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.spring;

import com.daikit.graphql.spring.IGQLControllerRequestHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@ConditionalOnClass(value={IGQLControllerRequestHandler.class})
public class GQLController {
    @Autowired
    private IGQLControllerRequestHandler requestHandler;

    @RequestMapping(value={"/graphql/introspection"}, produces={"application/json"})
    public void introspection(HttpServletResponse response) {
        try {
            this.requestHandler.handleIntropsectionRequest(response);
        }
        catch (Exception e) {
            this.requestHandler.handleError(response, e);
        }
    }

    @RequestMapping(value={"/graphql/introspectionfragments"}, produces={"application/json"})
    public void introspectionFragments(HttpServletResponse response) {
        try {
            this.requestHandler.handleIntrospectionFragmentsRequest(response);
        }
        catch (Exception e) {
            this.requestHandler.handleError(response, e);
        }
    }

    @RequestMapping(value={"/graphql"}, method={RequestMethod.POST}, consumes={"application/json", "multipart/form-data"}, produces={"application/json"})
    public void query(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.requestHandler.handleQueryRequest(request, response);
        }
        catch (Exception e) {
            this.requestHandler.handleError(response, e);
        }
    }
}

