/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.spring;

import com.daikit.graphql.data.output.GQLExecutionResult;
import com.daikit.graphql.exception.GQLException;
import com.daikit.graphql.execution.GQLErrorProcessor;
import com.daikit.graphql.spring.IGQLControllerRequestHandler;
import com.daikit.graphql.spring.web.GQLIOUtils;
import com.daikit.graphql.spring.web.GQLRequestHandler;
import com.daikit.graphql.utils.Message;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class GQLDefaultControllerRequestHandler
implements IGQLControllerRequestHandler {
    @Autowired
    private GQLErrorProcessor gqlErrorProcessor;
    @Autowired
    private GQLRequestHandler gqlRequestHandler;
    @Autowired
    private ObjectWriter gqlObjectWriter;

    @Override
    public void handleIntropsectionRequest(HttpServletResponse response) {
        try {
            this.gqlRequestHandler.handleIntrospectionRequest(response);
        }
        catch (Exception e) {
            this.handleError(response, e);
        }
    }

    @Override
    public void handleIntrospectionFragmentsRequest(HttpServletResponse response) {
        try {
            this.gqlRequestHandler.handleIntrospectionFragmentsRequest(response);
        }
        catch (Exception e) {
            this.handleError(response, e);
        }
    }

    @Override
    public void handleQueryRequest(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.gqlRequestHandler.handleRequest(request, response);
        }
        catch (Exception e) {
            this.handleError(response, e);
        }
    }

    @Override
    public void handleError(HttpServletResponse response, Exception e) {
        try {
            GQLIOUtils.writeInResponse(response, this.gqlObjectWriter.writeValueAsString((Object)new GQLExecutionResult(this.gqlErrorProcessor.handleError((Throwable)e))));
        }
        catch (JsonProcessingException e1) {
            throw new GQLException(Message.format((String)"An error happened while writing error result {}", (Object[])new Object[]{e1.getMessage()}), (Throwable)e1);
        }
    }
}

