/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.spring;

import com.daikit.graphql.config.GQLSchemaConfig;
import com.daikit.graphql.execution.GQLErrorProcessor;
import com.daikit.graphql.execution.GQLExecutor;
import com.daikit.graphql.spring.GQLDefaultControllerRequestHandler;
import com.daikit.graphql.spring.IGQLControllerRequestHandler;
import com.daikit.graphql.spring.SpringDataGraphqlProperties;
import com.daikit.graphql.spring.web.GQLRequestHandler;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={SpringDataGraphqlProperties.class})
public class SpringDataGraphqlAutoConfiguration {
    @Autowired
    private SpringDataGraphqlProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public WebMvcConfigurer webConfigurer() {
        return new WebMvcConfigurer(){

            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                registry.addResourceHandler(new String[]{"/graphiql/**"}).addResourceLocations(new String[]{"classpath:/static/graphiql/"});
                registry.addResourceHandler(new String[]{"/images/**"}).addResourceLocations(new String[]{"classpath:/static/images/"});
            }

            public void addCorsMappings(CorsRegistry registry) {
                registry.addMapping("/**").allowCredentials(true);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public IGQLControllerRequestHandler createDefaultRequestHandler() {
        return new GQLDefaultControllerRequestHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper createGQLObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectWriter createGraphQLObjectWriter(@Autowired ObjectMapper objectMapper) {
        return objectMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
    }

    @Bean
    @ConditionalOnMissingBean
    public GQLErrorProcessor createGQLErrorProcessor() {
        return new GQLErrorProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public GQLRequestHandler createGQLRequestHandler(@Autowired ObjectMapper gqlObjectMapper, @Autowired GQLExecutor executor) {
        return new GQLRequestHandler(gqlObjectMapper, executor);
    }

    @Bean
    @ConditionalOnMissingBean
    public GQLSchemaConfig createSchemaConfig() {
        GQLSchemaConfig schemaConfig = new GQLSchemaConfig();
        this.properties.initializeConfig(schemaConfig);
        return schemaConfig;
    }
}

