/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.spring.web;

import com.daikit.graphql.data.output.GQLExecutionResult;
import com.daikit.graphql.exception.GQLException;
import com.daikit.graphql.utils.Message;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Scanner;
import java.util.TimeZone;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.MediaType;

public class GQLIOUtils {
    public static String readInputStream(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter("\\A");
        String read = scanner.hasNext() ? scanner.next() : "";
        scanner.close();
        return read;
    }

    public static void writeInResponse(HttpServletResponse response, ObjectMapper objectMapper, GQLExecutionResult result) {
        try {
            GQLIOUtils.writeInResponse(response, objectMapper.writeValueAsString((Object)result));
        }
        catch (IOException e) {
            throw new GQLException(Message.format((String)"An error happened while writing response. [{}]", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    public static void writeInResponse(HttpServletResponse response, String content) {
        byte[] bytes = content.getBytes();
        response.setContentType(MediaType.APPLICATION_JSON.toString());
        response.setContentLength(bytes.length);
        response.setBufferSize(bytes.length);
        GQLIOUtils.setCacheExpireDate(response, 0);
        GQLIOUtils.setNotCacheable(response);
        try {
            response.getOutputStream().write(bytes);
        }
        catch (IOException e) {
            throw new GQLException(Message.format((String)"An error happened while writing response. [{}]", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    public static void setCacheExpireDate(HttpServletResponse response, int seconds) {
        if (response != null) {
            long nowPlusExpiration = new Date().getTime() + Long.valueOf(seconds) * 1000L;
            response.setHeader("Cache-Control", "PUBLIC, max-age=" + seconds);
            SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            response.setHeader("Expires", httpDateFormat.format(nowPlusExpiration));
        }
    }

    public static void setNotCacheable(HttpServletResponse response) {
        if (response != null) {
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("X-Cacheable", "NO: !obj.cacheable");
        }
    }
}

