/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.spring.web;

import com.daikit.graphql.data.output.GQLExecutionResult;
import com.daikit.graphql.exception.GQLException;
import com.daikit.graphql.execution.GQLExecutor;
import com.daikit.graphql.introspection.GQLIntrospection;
import com.daikit.graphql.spring.web.GQLIOUtils;
import com.daikit.graphql.spring.web.GQLRequestInputData;
import com.daikit.graphql.spring.web.GQLSpringConstants;
import com.daikit.graphql.utils.Assert;
import com.daikit.graphql.utils.Message;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class GQLRequestHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String NEWLINE = System.getProperty("line.separator");
    public static String GQL_FILENAME_PREFIX = "TMP_";
    private final Supplier<ObjectMapper> objectMapper;
    private final Supplier<GQLExecutor> executor;
    private final ObjectMapper loggerMapper = new ObjectMapper();

    public GQLRequestHandler(ObjectMapper objectMapper, GQLExecutor executor) {
        this.objectMapper = () -> objectMapper;
        this.executor = () -> executor;
    }

    public GQLRequestHandler(Supplier<ObjectMapper> objectMapper, Supplier<GQLExecutor> executor) {
        this.objectMapper = objectMapper;
        this.executor = executor;
    }

    public void handleIntrospectionRequest(HttpServletResponse response) {
        GQLIOUtils.writeInResponse(response, this.objectMapper.get(), (GQLExecutionResult)GQLIntrospection.getAllTypes(query -> this.executor.get().execute(query)));
    }

    public void handleIntrospectionFragmentsRequest(HttpServletResponse response) {
        GQLExecutionResult result = (GQLExecutionResult)GQLIntrospection.getFragments(query -> this.executor.get().execute(query));
        Map<String, Object> resultSchema = this.map(this.map(result.getData()).get("__schema"));
        resultSchema.put("types", this.list(resultSchema.get("types")).stream().filter(map -> map.get("possibleTypes") != null).collect(Collectors.toList()));
        GQLIOUtils.writeInResponse(response, this.objectMapper.get(), result);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> variables;
        GQLRequestInputData inputData;
        String requestBody;
        boolean multipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (multipart) {
            requestBody = ((String[])request.getParameterMap().get("operations"))[0];
        } else {
            try {
                requestBody = GQLIOUtils.readInputStream((InputStream)request.getInputStream());
            }
            catch (IOException e) {
                throw new GQLException(Message.format((String)"An error happened while reading the request. [{}]", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        GQLExecutionResult result = null;
        try {
            inputData = (GQLRequestInputData)this.objectMapper.get().readValue(requestBody, GQLRequestInputData.class);
            variables = this.readVariables(inputData, request, multipart);
        }
        catch (IOException e) {
            throw new GQLException(Message.format((String)"An error happened while reading request body to JSON. [{}]", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
        }
        result = this.executor.get().execute(this.sanitize(inputData.getQuery().asText()), inputData.getOperationName(), null, variables);
        if (result.getErrorDetails() != null) {
            try {
                this.debugError(result);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        GQLIOUtils.writeInResponse(response, this.objectMapper.get(), result);
    }

    private Map<String, Object> map(Object object) {
        return (Map)object;
    }

    private List<Map<String, Object>> list(Object object) {
        return (List)object;
    }

    private void debugError(GQLExecutionResult result) throws JsonProcessingException {
        this.logger.error(Message.format((String)"An error happened while running GQL Query : type [{}] message [{}] errors [{}]", (Object[])new Object[]{result.getErrorDetails().getType(), result.getErrorDetails().getMessage(), this.toJSONForLog(result.getErrors())}));
    }

    private Map<String, Object> readVariables(GQLRequestInputData inputData, HttpServletRequest request, boolean multipart) throws IOException, JsonParseException, JsonMappingException {
        Map variables = null;
        if (inputData.getVariables() != null) {
            String asText;
            variables = inputData.getVariables() instanceof TextNode ? (StringUtils.isNotEmpty((CharSequence)(asText = inputData.getVariables().asText())) ? (Map)this.objectMapper.get().readValue(inputData.getVariables().asText(), Map.class) : Collections.emptyMap()) : (Map)this.objectMapper.get().convertValue((Object)inputData.getVariables(), Map.class);
        }
        if (variables == null) {
            variables = Collections.emptyMap();
        }
        if (multipart) {
            this.updateVariableFromMultipart(request, variables);
        }
        return variables;
    }

    private void updateVariableFromMultipart(HttpServletRequest request, Map<String, Object> variables) throws IOException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Assert.assertTrue((!multipartRequest.getMultiFileMap().isEmpty() ? 1 : 0) != 0, (String)"Multipart request should contain file(s).", (Object[])new Object[0]);
        Map<String, List<String>> fileMappings = this.splitFileMappings(((String[])request.getParameterMap().get("map"))[0]);
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry<String, List<String>> fileMappingEntry : fileMappings.entrySet()) {
            String fileMappingKey = fileMappingEntry.getKey();
            List<String> fileMappingPath = fileMappingEntry.getValue();
            Object varProperty = variables;
            for (int j = 0; j < fileMappingPath.size() - 1; ++j) {
                String currentPathFragment = fileMappingPath.get(j);
                if (varProperty instanceof Map) {
                    varProperty = varProperty.get(currentPathFragment);
                    continue;
                }
                if (!(varProperty instanceof List)) continue;
                varProperty = ((List)varProperty).get(Integer.parseInt(currentPathFragment));
            }
            MultipartFile multipartFile = (MultipartFile)fileMap.get(fileMappingKey);
            File temporaryFile = File.createTempFile(GQL_FILENAME_PREFIX, GQLSpringConstants.TEMP_FILE_NAME_SEPARATOR + multipartFile.getOriginalFilename());
            multipartFile.transferTo(temporaryFile);
            String currentPathFragment = fileMappingPath.get(fileMappingPath.size() - 1);
            if (varProperty instanceof Map) {
                ((Map)varProperty).put(currentPathFragment, temporaryFile);
                continue;
            }
            if (!(varProperty instanceof List)) continue;
            ((List)varProperty).set(Integer.parseInt(currentPathFragment), temporaryFile);
        }
    }

    private String sanitize(String inputDataQuery) {
        return inputDataQuery.replace("\\r", "").replace("\\n", this.NEWLINE).replace("\\t", "   ").replace("\\\"", "\"");
    }

    private Map<String, List<String>> splitFileMappings(String map) {
        String[] mapSplits;
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (String mapSplit : mapSplits = map.substring(1, map.length() - 1).split(",")) {
            String[] entrySplits = mapSplit.split(":");
            String key = entrySplits[0].substring(1, entrySplits[0].length() - 1);
            String baseValue = entrySplits[1].substring(2, entrySplits[1].length() - 2);
            List value = Stream.of(StringUtils.split((String)baseValue.substring("variables.".length()), (String)".")).collect(Collectors.toList());
            ret.put(key, value);
        }
        return ret;
    }

    private String toJSONForLog(Object value) throws JsonProcessingException {
        return this.loggerMapper.writeValueAsString(value);
    }
}

