/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.client.binding;

import akka.NotUsed;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import com.daml.ledger.api.refinements.ApiTypes$;
import com.daml.ledger.api.v1.event.ArchivedEvent;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.event.Event;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset;
import com.daml.ledger.api.v1.transaction.Transaction;
import com.daml.ledger.client.binding.Contract;
import com.daml.ledger.client.binding.DomainArchivedEvent;
import com.daml.ledger.client.binding.DomainCreatedEvent;
import com.daml.ledger.client.binding.DomainEvent;
import com.daml.ledger.client.binding.DomainTransaction;
import com.daml.ledger.client.binding.DomainTransactionMapper$;
import com.daml.ledger.client.binding.DomainTransactionMapper$EmptyEvent$;
import com.daml.ledger.client.binding.EventDecoderError;
import com.google.protobuf.timestamp.Timestamp;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalaz.Applicative;
import scalaz.std.either$;
import scalaz.std.list$;

@ScalaSignature(bytes="\u0006\u0005\tEw!\u0002\u001a4\u0011\u0003qd!\u0002!4\u0011\u0003\t\u0005\"\u0002%\u0002\t\u0003IU\u0001\u0002&\u0002\u0001-CQA\\\u0001\u0005\u0002=4\u0011\"a\u0006\u0002!\u0003\rJ#!\u0007\u0007\r\u00055\u0015ARAH\u0011)\t\tJ\u0002BK\u0002\u0013\u0005\u00111\u0013\u0005\u000b\u0003G3!\u0011#Q\u0001\n\u0005U\u0005B\u0002%\u0007\t\u0003\t)\u000bC\u0005\u0002,\u001a\t\t\u0011\"\u0001\u0002.\"I\u0011\u0011\u0017\u0004\u0012\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003g1\u0011\u0011!C!\u0003kA\u0011\"a\u0012\u0007\u0003\u0003%\t!!\u0013\t\u0013\u0005Ec!!A\u0005\u0002\u0005%\u0007\"CA0\r\u0005\u0005I\u0011IA1\u0011%\tyGBA\u0001\n\u0003\ti\rC\u0005\u0002R\u001a\t\t\u0011\"\u0011\u0002T\"I\u00111\u0010\u0004\u0002\u0002\u0013\u0005\u0013Q\u0010\u0005\n\u0003\u007f2\u0011\u0011!C!\u0003\u0003C\u0011\"a6\u0007\u0003\u0003%\t%!7\b\u0013\u0005u\u0017!!A\t\n\u0005}g!CAG\u0003\u0005\u0005\t\u0012BAq\u0011\u0019Ae\u0003\"\u0001\u0002z\"I\u0011q\u0010\f\u0002\u0002\u0013\u0015\u0013\u0011\u0011\u0005\t]Z\t\t\u0011\"!\u0002|\"I\u0011q \f\u0002\u0002\u0013\u0005%\u0011\u0001\u0005\n\u0003\u00073\u0012\u0011!C\u0005\u0003\u000b;qA!\u0004\u0002\u0011\u001b\u000b\tDB\u0004\u0002*\u0005Ai)a\u000b\t\r!kB\u0011AA\u0018\u0011%\t\u0019$HA\u0001\n\u0003\n)\u0004C\u0005\u0002Hu\t\t\u0011\"\u0001\u0002J!I\u0011\u0011K\u000f\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u0003?j\u0012\u0011!C!\u0003CB\u0011\"a\u001c\u001e\u0003\u0003%\t!!\u001d\t\u0013\u0005mT$!A\u0005B\u0005u\u0004\"CA@;\u0005\u0005I\u0011IAA\u0011%\t\u0019)HA\u0001\n\u0013\t)IB\u0003Ag\u0001\u0011y\u0001\u0003\u0006\u0002\u0012\u001d\u0012\t\u0011)A\u0005\u0005CAa\u0001S\u0014\u0005\u0002\te\u0002b\u0002B O\u0011\u0005!\u0011\t\u0005\b\u0005\u0007:C\u0011\u0002B#\u0011\u001d\u0011\tf\nC\u0005\u0005'BqAa\u001d(\t\u0013\u0011)\bC\u0004\u0003\u0012\u001e\"IAa%\t\u000f\tmu\u0005\"\u0003\u0003\u001e\"9!qU\u0014\u0005\n\t%\u0006b\u0002B^O\u0011%!QX\u0001\u0018\t>l\u0017-\u001b8Ue\u0006t7/Y2uS>tW*\u00199qKJT!\u0001N\u001b\u0002\u000f\tLg\u000eZ5oO*\u0011agN\u0001\u0007G2LWM\u001c;\u000b\u0005aJ\u0014A\u00027fI\u001e,'O\u0003\u0002;w\u0005!A-Y7m\u0015\u0005a\u0014aA2p[\u000e\u0001\u0001CA \u0002\u001b\u0005\u0019$a\u0006#p[\u0006Lg\u000e\u0016:b]N\f7\r^5p]6\u000b\u0007\u000f]3s'\t\t!\t\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u00121\u0002R3d_\u0012,'\u000fV=qKB!1\t\u0014(Y\u0013\tiEIA\u0005Gk:\u001cG/[8ocA\u0011qJV\u0007\u0002!*\u0011\u0011KU\u0001\u0006KZ,g\u000e\u001e\u0006\u0003'R\u000b!A^\u0019\u000b\u0005U;\u0014aA1qS&\u0011q\u000b\u0015\u0002\r\u0007J,\u0017\r^3e\u000bZ,g\u000e\u001e\t\u00053\u0006$wM\u0004\u0002[?:\u00111LX\u0007\u00029*\u0011Q,P\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015K!\u0001\u0019#\u0002\u000fA\f7m[1hK&\u0011!m\u0019\u0002\u0007\u000b&$\b.\u001a:\u000b\u0005\u0001$\u0005CA f\u0013\t17GA\tFm\u0016tG\u000fR3d_\u0012,'/\u0012:s_J\u0004\"\u0001[6\u000f\u0005}J\u0017B\u000164\u0003!\u0019uN\u001c;sC\u000e$\u0018B\u00017n\u0005\u0015ye-\u00118z\u0015\tQ7'A\u0003baBd\u0017\u0010F\u0002q\u0003\u001f\u0001r!\u001d={\u0003\u0003\t9!D\u0001s\u0015\t\u0019H/\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\t)h/\u0001\u0004tiJ,\u0017-\u001c\u0006\u0002o\u0006!\u0011m[6b\u0013\tI(O\u0001\u0003GY><\bCA>\u007f\u001b\u0005a(BA?S\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\u0005}d(a\u0003+sC:\u001c\u0018m\u0019;j_:\u00042aPA\u0002\u0013\r\t)a\r\u0002\u0012\t>l\u0017-\u001b8Ue\u0006t7/Y2uS>t\u0007\u0003BA\u0005\u0003\u0017i\u0011A^\u0005\u0004\u0003\u001b1(a\u0002(piV\u001bX\r\u001a\u0005\b\u0003#!\u0001\u0019AA\n\u0003\u001d!WmY8eKJ\u00042!!\u0006\u0004\u001b\u0005\t!\u0001F%oaV$h+\u00197jI\u0006$\u0018n\u001c8FeJ|'o\u0005\u0004\u0006\u0005\u0006m\u0011\u0011\u0005\t\u0004\u0007\u0006u\u0011bAA\u0010\t\n9\u0001K]8ek\u000e$\bcA-\u0002$%\u0019\u0011QE2\u0003\u0019M+'/[1mSj\f'\r\\3*\u0007\u0015ibA\u0001\u0006F[B$\u00180\u0012<f]R\u001c\u0002\"\b\"\u0002.\u0005m\u0011\u0011\u0005\t\u0004\u0003+)ACAA\u0019!\r\t)\"H\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0005Y\u0006twM\u0003\u0002\u0002B\u0005!!.\u0019<b\u0013\u0011\t)%a\u000f\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u0005E\u0002D\u0003\u001bJ1!a\u0014E\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)&a\u0017\u0011\u0007\r\u000b9&C\u0002\u0002Z\u0011\u00131!\u00118z\u0011%\ti&IA\u0001\u0002\u0004\tY%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003G\u0002b!!\u001a\u0002l\u0005USBAA4\u0015\r\tI\u0007R\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA7\u0003O\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111OA=!\r\u0019\u0015QO\u0005\u0004\u0003o\"%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003;\u001a\u0013\u0011!a\u0001\u0003+\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u0017\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003o\tAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a\"\u0011\t\u0005e\u0012\u0011R\u0005\u0005\u0003\u0017\u000bYD\u0001\u0004PE*,7\r\u001e\u0002\u001f%\u0016\fX/\u001b:fI\u001aKW\r\u001c3E_\u0016\u001chj\u001c;Fq&\u001cH/\u0012:s_J\u001c\u0002B\u0002\"\u0002.\u0005m\u0011\u0011E\u0001\u0006M&,G\u000eZ\u000b\u0003\u0003+\u0003B!a&\u0002 :!\u0011\u0011TAN!\tYF)C\u0002\u0002\u001e\u0012\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA#\u0003CS1!!(E\u0003\u00191\u0017.\u001a7eAQ!\u0011qUAU!\r\t)B\u0002\u0005\b\u0003#K\u0001\u0019AAK\u0003\u0011\u0019w\u000e]=\u0015\t\u0005\u001d\u0016q\u0016\u0005\n\u0003#S\u0001\u0013!a\u0001\u0003+\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00026*\"\u0011QSA\\W\t\tI\f\u0005\u0003\u0002<\u0006\u0015WBAA_\u0015\u0011\ty,!1\u0002\u0013Ut7\r[3dW\u0016$'bAAb\t\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0017Q\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G\u0003BA+\u0003\u0017D\u0011\"!\u0018\u000f\u0003\u0003\u0005\r!a\u0013\u0015\t\u0005M\u0014q\u001a\u0005\n\u0003;\u0002\u0012\u0011!a\u0001\u0003+\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qGAk\u0011%\ti&EA\u0001\u0002\u0004\tY%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003g\nY\u000eC\u0005\u0002^Q\t\t\u00111\u0001\u0002V\u0005q\"+Z9vSJ,GMR5fY\u0012$u.Z:O_R,\u00050[:u\u000bJ\u0014xN\u001d\t\u0004\u0003+12#\u0002\f\u0002d\u0006=\b\u0003CAs\u0003W\f)*a*\u000e\u0005\u0005\u001d(bAAu\t\u00069!/\u001e8uS6,\u0017\u0002BAw\u0003O\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\t\t0a>\u000e\u0005\u0005M(\u0002BA{\u0003\u007f\t!![8\n\t\u0005\u0015\u00121\u001f\u000b\u0003\u0003?$B!a*\u0002~\"9\u0011\u0011S\rA\u0002\u0005U\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0007\u0011I\u0001E\u0003D\u0005\u000b\t)*C\u0002\u0003\b\u0011\u0013aa\u00149uS>t\u0007\"\u0003B\u00065\u0005\u0005\t\u0019AAT\u0003\rAH\u0005M\u0001\u000b\u000b6\u0004H/_#wK:$8\u0003B\u0014C\u0005#\u0001BAa\u0005\u0003\u001e5\u0011!Q\u0003\u0006\u0005\u0005/\u0011I\"\u0001\u0007tG\u0006d\u0017\r\\8hO&twMC\u0002\u0003\u001cm\n\u0001\u0002^=qKN\fg-Z\u0005\u0005\u0005?\u0011)BA\u0006MCjLHj\\4hS:<\u0007c\u0001B\u0012\u00079\u0019!Q\u0005\u0001\u000f\t\t\u001d\"q\u0007\b\u0005\u0005S\u0011)D\u0004\u0003\u0003,\tMb\u0002\u0002B\u0017\u0005cq1a\u0017B\u0018\u0013\u0005a\u0014B\u0001\u001e<\u0013\tA\u0014(\u0003\u00027o%\u0011A'\u000e\u000b\u0005\u0005w\u0011i\u0004\u0005\u0002@O!9\u0011\u0011C\u0015A\u0002\t\u0005\u0012A\u0005;sC:\u001c\u0018m\u0019;j_:\u001cX*\u00199qKJ,\u0012\u0001]\u0001\u0012I>l\u0017-\u001b8Ue\u0006t7/Y2uS>tG\u0003\u0002B$\u0005\u001b\u0002b!W1\u0003J\u0005\u0005\u0001c\u0001B&\u000b9\u0011q\b\u0001\u0005\u0007\u0005\u001fZ\u0003\u0019\u0001>\u0002\u0003Q\f1b\u00195fG.,\u00050[:ugV!!Q\u000bB/)\u0019\u00119F!\u001b\u0003nA1\u0011,\u0019B%\u00053\u0002BAa\u0017\u0003^1\u0001Aa\u0002B0Y\t\u0007!\u0011\r\u0002\u0002)F!!1MA+!\r\u0019%QM\u0005\u0004\u0005O\"%a\u0002(pi\"Lgn\u001a\u0005\b\u0005Wb\u0003\u0019AAK\u0003%1\u0017.\u001a7e\u001d\u0006lW\rC\u0004\u0003p1\u0002\rA!\u001d\u0002\u00195\f\u0017PY3FY\u0016lWM\u001c;\u0011\u000b\r\u0013)A!\u0017\u0002\u0019\u0011|W.Y5o\u000bZ,g\u000e^:\u0015\t\t]$Q\u0011\t\u00073\u0006\u0014IE!\u001f\u0011\u000be\u0013YHa \n\u0007\tu4MA\u0002TKF\u00042a\u0010BA\u0013\r\u0011\u0019i\r\u0002\f\t>l\u0017-\u001b8Fm\u0016tG\u000fC\u0004\u0003\b6\u0002\rA!#\u0002\r\u00154XM\u001c;t!\u0015I&1\u0010BF!\ry%QR\u0005\u0004\u0005\u001f\u0003&!B#wK:$\u0018\u0001C7ba\u00163XM\u001c;\u0015\t\tU%\u0011\u0014\t\u00073\u0006\u0014IEa&\u0011\u000b\r\u0013)Aa \t\rEs\u0003\u0019\u0001BF\u00035awnZ!oI\u0012K7oY1sIR!!q\u0014BS)\u0011\u0011)J!)\t\r\t\rv\u00061\u0001e\u0003\r)'O\u001d\u0005\u0006#>\u0002\rAT\u0001\u0010[\u0006\u00048I]3bi\u0016$WI^3oiR1!1\u0016BZ\u0005o\u0003b!W1\u0003J\t5\u0006cA \u00030&\u0019!\u0011W\u001a\u0003%\u0011{W.Y5o\u0007J,\u0017\r^3e\u000bZ,g\u000e\u001e\u0005\u0007\u0005k\u0003\u0004\u0019\u0001(\u0002\u0019\r\u0014X-\u0019;fI\u00163XM\u001c;\t\r\te\u0006\u00071\u0001h\u0003!\u0019wN\u001c;sC\u000e$\u0018\u0001E7ba\u0006\u00138\r[5wK\u0012,e/\u001a8u)\u0011\u0011yLa2\u0011\re\u000b'\u0011\nBa!\ry$1Y\u0005\u0004\u0005\u000b\u001c$a\u0005#p[\u0006Lg.\u0011:dQ&4X\rZ#wK:$\bb\u0002Bec\u0001\u0007!1Z\u0001\u000eCJ\u001c\u0007.\u001b<fI\u00163XM\u001c;\u0011\u0007=\u0013i-C\u0002\u0003PB\u0013Q\"\u0011:dQ&4X\rZ#wK:$\b")
public class DomainTransactionMapper
implements LazyLogging {
    private final Function1<CreatedEvent, Either<EventDecoderError, Contract<Object>>> decoder;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Flow<Transaction, DomainTransaction, NotUsed> apply(Function1<CreatedEvent, Either<EventDecoderError, Contract<Object>>> decoder) {
        return DomainTransactionMapper$.MODULE$.apply(decoder);
    }

    private Logger logger$lzycompute() {
        DomainTransactionMapper domainTransactionMapper = this;
        synchronized (domainTransactionMapper) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Flow<Transaction, DomainTransaction, NotUsed> transactionsMapper() {
        return (Flow)Flow$.MODULE$.apply().mapConcat((Function1 & Serializable)transaction -> {
            List list;
            Either<InputValidationError, DomainTransaction> either = this.domainTransaction((Transaction)transaction);
            if (either instanceof Left) {
                BoxedUnit boxedUnit;
                Left left = (Left)either;
                InputValidationError error = (InputValidationError)left.value();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Input validation error when converting to domain transaction: {}. Transaction is discarded.", (Object)error);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                list = package$.MODULE$.List().empty();
            } else if (either instanceof Right) {
                Right right = (Right)either;
                DomainTransaction t = (DomainTransaction)right.value();
                list = (IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DomainTransaction[]{t}));
            } else {
                throw new MatchError(either);
            }
            return list;
        });
    }

    private Either<InputValidationError, DomainTransaction> domainTransaction(Transaction t) {
        return this.checkExists("effectiveAt", t.effectiveAt()).flatMap((Function1 & Serializable)effectiveAt -> this.domainEvents((Seq<Event>)t.events()).map((Function1 & Serializable)events -> {
            Object transactionId = ApiTypes$.MODULE$.TransactionId().apply((Object)t.transactionId());
            Object workflowId = ApiTypes$.MODULE$.WorkflowId().apply((Object)t.workflowId());
            LedgerOffset offset = new LedgerOffset((LedgerOffset.Value)new LedgerOffset.Value$.Absolute(t.offset()));
            Object commandId = ApiTypes$.MODULE$.CommandId().apply((Object)t.commandId());
            return new Tuple5(events, transactionId, workflowId, (Object)offset, commandId);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple5 tuple5 = x$1;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            Seq events = (Seq)tuple5._1();
            Object transactionId = tuple5._2();
            Object workflowId = tuple5._3();
            LedgerOffset offset = (LedgerOffset)tuple5._4();
            Object commandId = tuple5._5();
            DomainTransaction domainTransaction = new DomainTransaction(transactionId, workflowId, offset, commandId, (Timestamp)effectiveAt, (Seq<DomainEvent>)events);
            return domainTransaction;
        }));
    }

    private <T> Either<InputValidationError, T> checkExists(String fieldName, Option<T> maybeElement) {
        Right right;
        Option<T> option = maybeElement;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object element = some.value();
            right = package$.MODULE$.Right().apply(element);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new RequiredFieldDoesNotExistError(fieldName));
        } else {
            throw new MatchError(option);
        }
        return right;
    }

    private Either<InputValidationError, Seq<DomainEvent>> domainEvents(Seq<Event> events) {
        return ((Either)scalaz.syntax.package$.MODULE$.traverse().ToTraverseOps((Object)events.toList(), list$.MODULE$.listInstance()).traverse((Function1 & Serializable)event -> this.mapEvent((Event)event).map((Function1 & Serializable)domainEvent -> domainEvent.toList()), (Applicative)either$.MODULE$.eitherMonad())).map((Function1 & Serializable)x$2 -> (List)x$2.flatten(Predef$.MODULE$.$conforms()));
    }

    private Either<InputValidationError, Option<DomainEvent>> mapEvent(Event event) {
        Left left;
        Event.Event event2 = event.event();
        if (event2 instanceof Event.Event$.Created) {
            Event.Event$.Created created = (Event.Event$.Created)event2;
            CreatedEvent createdEvent = created.value();
            left = (Either)((Either)this.decoder.apply((Object)createdEvent)).fold((Function1 & Serializable)err -> this.logAndDiscard(createdEvent, (EventDecoderError)err), (Function1 & Serializable)x$3 -> this.mapCreatedEvent(createdEvent, (Contract<Object>)x$3).map((Function1 & Serializable)value -> new Some(value)));
        } else if (event2 instanceof Event.Event$.Archived) {
            Event.Event$.Archived archived = (Event.Event$.Archived)event2;
            ArchivedEvent archivedEvent = archived.value();
            left = this.mapArchivedEvent(archivedEvent).map((Function1 & Serializable)value -> new Some(value));
        } else if (Event.Event$.Empty$.MODULE$.equals(event2)) {
            left = package$.MODULE$.Left().apply((Object)DomainTransactionMapper$EmptyEvent$.MODULE$);
        } else {
            throw new MatchError((Object)event2);
        }
        return left;
    }

    private Either<InputValidationError, Option<DomainEvent>> logAndDiscard(CreatedEvent event, EventDecoderError err) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Unhandled create event {}. Error: {}", (Object[])new String[]{event.toString(), err.toString()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return package$.MODULE$.Right().apply((Object)None$.MODULE$);
    }

    private Either<InputValidationError, DomainCreatedEvent> mapCreatedEvent(CreatedEvent createdEvent, Contract<Object> contract) {
        return this.checkExists("events.witnessedEvents.event.created.templateId", createdEvent.templateId()).flatMap((Function1 & Serializable)tid -> this.checkExists("events.witnessedEvents.event.created.createArguments", createdEvent.createArguments()).map((Function1 & Serializable)arguments -> {
            Object eventId = ApiTypes$.MODULE$.EventId().apply((Object)createdEvent.eventId());
            Object contractId = ApiTypes$.MODULE$.ContractId().apply((Object)createdEvent.contractId());
            Object templateId = ApiTypes$.MODULE$.TemplateId().apply(tid);
            Seq witnessParties = (Seq)((IterableOnceOps)createdEvent.witnessParties().map((Function1 & Serializable)a -> ApiTypes$.MODULE$.Party().apply(a))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
            Object createArguments = ApiTypes$.MODULE$.CreateArguments().apply(arguments);
            return new Tuple6(arguments, eventId, contractId, templateId, (Object)witnessParties, createArguments);
        }).map((Function1 & Serializable)x$4 -> {
            Tuple6 tuple6 = x$4;
            if (tuple6 == null) {
                throw new MatchError((Object)tuple6);
            }
            Object eventId = tuple6._2();
            Object contractId = tuple6._3();
            Object templateId = tuple6._4();
            Seq witnessParties = (Seq)tuple6._5();
            Object createArguments = tuple6._6();
            DomainCreatedEvent domainCreatedEvent = new DomainCreatedEvent(eventId, contractId, templateId, (Seq<Object>)witnessParties, createArguments, contract);
            return domainCreatedEvent;
        }));
    }

    private Either<InputValidationError, DomainArchivedEvent> mapArchivedEvent(ArchivedEvent archivedEvent) {
        return this.checkExists("events.witnessedEvents.event.archived.templateId", archivedEvent.templateId()).map((Function1 & Serializable)tid -> {
            Object eventId = ApiTypes$.MODULE$.EventId().apply((Object)archivedEvent.eventId());
            Object contractId = ApiTypes$.MODULE$.ContractId().apply((Object)archivedEvent.contractId());
            Object templateId = ApiTypes$.MODULE$.TemplateId().apply(tid);
            Seq witnessParties = (Seq)((IterableOnceOps)archivedEvent.witnessParties().map((Function1 & Serializable)a -> ApiTypes$.MODULE$.Party().apply(a))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
            return new Tuple5(tid, eventId, contractId, templateId, (Object)witnessParties);
        }).map((Function1 & Serializable)x$5 -> {
            Tuple5 tuple5 = x$5;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            Object eventId = tuple5._2();
            Object contractId = tuple5._3();
            Object templateId = tuple5._4();
            Seq witnessParties = (Seq)tuple5._5();
            DomainArchivedEvent domainArchivedEvent = new DomainArchivedEvent(eventId, contractId, templateId, (Seq<Object>)witnessParties);
            return domainArchivedEvent;
        });
    }

    public DomainTransactionMapper(Function1<CreatedEvent, Either<EventDecoderError, Contract<Object>>> decoder) {
        this.decoder = decoder;
        LazyLogging.$init$((LazyLogging)this);
    }

    private static interface InputValidationError
    extends Product,
    Serializable {
    }

    private static final class RequiredFieldDoesNotExistError
    implements InputValidationError {
        private final String field;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String field() {
            return this.field;
        }

        public RequiredFieldDoesNotExistError copy(String field) {
            return new RequiredFieldDoesNotExistError(field);
        }

        public String copy$default$1() {
            return this.field();
        }

        public String productPrefix() {
            return "RequiredFieldDoesNotExistError";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.field();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RequiredFieldDoesNotExistError;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "field";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RequiredFieldDoesNotExistError)) return false;
            boolean bl = true;
            if (!bl) return false;
            RequiredFieldDoesNotExistError requiredFieldDoesNotExistError = (RequiredFieldDoesNotExistError)x$1;
            String string = this.field();
            String string2 = requiredFieldDoesNotExistError.field();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public RequiredFieldDoesNotExistError(String field) {
            this.field = field;
            Product.$init$((Product)this);
        }
    }
}

