/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.client.binding;

import akka.NotUsed;
import akka.NotUsed$;
import akka.stream.Graph;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Source;
import com.daml.api.util.TimeProvider;
import com.daml.ledger.api.refinements.ApiTypes$;
import com.daml.ledger.api.refinements.CompositeCommand;
import com.daml.ledger.api.refinements.CompositeCommandAdapter;
import com.daml.ledger.api.v1.event.ArchivedEvent;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.event.Event;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset;
import com.daml.ledger.api.v1.transaction_filter.TransactionFilter;
import com.daml.ledger.client.LedgerClient;
import com.daml.ledger.client.binding.Contract;
import com.daml.ledger.client.binding.DomainTransaction;
import com.daml.ledger.client.binding.DomainTransactionMapper$;
import com.daml.ledger.client.binding.EventDecoderError;
import com.daml.ledger.client.binding.LedgerClientBinding$;
import com.daml.ledger.client.binding.TemplateSelector;
import com.daml.ledger.client.binding.retrying.CommandRetryFlow$;
import com.daml.ledger.client.binding.util.Slf4JLogger;
import com.daml.ledger.client.binding.util.Slf4JLogger$;
import com.daml.ledger.client.configuration.LedgerClientConfiguration;
import com.daml.ledger.client.services.commands.CommandSubmission;
import com.daml.ledger.client.services.commands.CommandSubmission$;
import com.daml.ledger.client.services.commands.tracker.CompletionResponse;
import com.daml.util.Ctx;
import io.grpc.ManagedChannel;
import io.netty.handler.ssl.SslContext;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scalaz.syntax.TagOps$;

@ScalaSignature(bytes="\u0006\u0005\t]g\u0001\u0002\u000f\u001e\u0001!B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\tk\u0001\u0011\t\u0011)A\u0005c!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u00039\u0011!y\u0004A!b\u0001\n\u0003\u0001\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u0011)\u0003!\u0011!Q\u0001\n-C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005;\")\u0011\u000f\u0001C\u0001e\"91\u0010\u0001b\u0001\n\u0013a\bbBA\u0006\u0001\u0001\u0006I! \u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011%\t\t\nAI\u0001\n\u0003\t\u0019*\u0002\u0004\u0002*\u0002\u0001\u00111\u0016\u0005\n\u00057\u0001!\u0019!C\u0005\u0005;A\u0001B!\n\u0001A\u0003%!q\u0004\u0005\b\u0005O\u0001A\u0011\u0001B\u0015\u000b\u0019\u0011y\u0005\u0001\u0001\u0003R!9\u0011q \u0001\u0005\u0002\tu\u0003b\u0002B8\u0001\u0011\u0005!\u0011O\u0004\b\u0005\u007fj\u0002\u0012\u0001BA\r\u0019aR\u0004#\u0001\u0003\u0004\"1\u0011o\u0006C\u0001\u0005\u000bCqAa\"\u0018\t\u0003\u0011I\tC\u0004\u00034^!\tA!.\t\u000f\t\rw\u0003\"\u0001\u0003F\n\u0019B*\u001a3hKJ\u001cE.[3oi\nKg\u000eZ5oO*\u0011adH\u0001\bE&tG-\u001b8h\u0015\t\u0001\u0013%\u0001\u0004dY&,g\u000e\u001e\u0006\u0003E\r\na\u0001\\3eO\u0016\u0014(B\u0001\u0013&\u0003\u0011!\u0017-\u001c7\u000b\u0003\u0019\n1aY8n\u0007\u0001\u0019\"\u0001A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g\u00031aW\rZ4fe\u000ec\u0017.\u001a8u+\u0005\t\u0004C\u0001\u001a4\u001b\u0005y\u0012B\u0001\u001b \u00051aU\rZ4fe\u000ec\u0017.\u001a8u\u00035aW\rZ4fe\u000ec\u0017.\u001a8uA\u0005\u0011B.\u001a3hKJ\u001cE.[3oi\u000e{gNZ5h+\u0005A\u0004CA\u001d=\u001b\u0005Q$BA\u001e \u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011QH\u000f\u0002\u001a\u0019\u0016$w-\u001a:DY&,g\u000e^\"p]\u001aLw-\u001e:bi&|g.A\nmK\u0012<WM]\"mS\u0016tGoQ8oM&<\u0007%A\u0004dQ\u0006tg.\u001a7\u0016\u0003\u0005\u0003\"AQ$\u000e\u0003\rS!\u0001R#\u0002\t\u001d\u0014\bo\u0019\u0006\u0002\r\u0006\u0011\u0011n\\\u0005\u0003\u0011\u000e\u0013a\"T1oC\u001e,Gm\u00115b]:,G.\u0001\u0005dQ\u0006tg.\u001a7!\u00031\u0011X\r\u001e:z)&lWm\\;u!\ta\u0015+D\u0001N\u0015\tqu*\u0001\u0003uS6,'\"\u0001)\u0002\t)\fg/Y\u0005\u0003%6\u0013\u0001\u0002R;sCRLwN\\\u0001\ri&lW\r\u0015:pm&$WM\u001d\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bA!\u001e;jY*\u0011\u0011lI\u0001\u0004CBL\u0017BA.W\u00051!\u0016.\\3Qe>4\u0018\u000eZ3s\u0003\u001d!WmY8eKJ\u0004\"A\u00188\u000f\u0005}cgB\u00011l\u001d\t\t'N\u0004\u0002cS:\u00111\r\u001b\b\u0003I\u001el\u0011!\u001a\u0006\u0003M\u001e\na\u0001\u0010:p_Rt\u0014\"\u0001\u0014\n\u0005\u0011*\u0013B\u0001\u0012$\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0011Q.H\u0001\u0018\t>l\u0017-\u001b8Ue\u0006t7/Y2uS>tW*\u00199qKJL!a\u001c9\u0003\u0017\u0011+7m\u001c3feRK\b/\u001a\u0006\u0003[v\ta\u0001P5oSRtDcB:vm^D\u0018P\u001f\t\u0003i\u0002i\u0011!\b\u0005\u0006_)\u0001\r!\r\u0005\u0006m)\u0001\r\u0001\u000f\u0005\u0006\u007f)\u0001\r!\u0011\u0005\u0006\u0015*\u0001\ra\u0013\u0005\u0006'*\u0001\r\u0001\u0016\u0005\u00069*\u0001\r!X\u0001\u0007Y><w-\u001a:\u0016\u0003u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tQa\u001d7gi)T!!!\u0002\u0002\u0007=\u0014x-C\u0002\u0002\n}\u0014a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0012iJ\fgn]1di&|gnU8ve\u000e,G\u0003DA\t\u0003g\t\u0019&!\u0018\u0002r\u0005m\u0004\u0003CA\n\u0003C\t)#a\u000b\u000e\u0005\u0005U!\u0002BA\f\u00033\t\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0005\u00037\ti\"\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u0003?\tA!Y6lC&!\u00111EA\u000b\u0005\u0019\u0019v.\u001e:dKB\u0019A/a\n\n\u0007\u0005%RDA\tE_6\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:\u0004B!!\f\u000205\u0011\u0011QD\u0005\u0005\u0003c\tiBA\u0004O_R,6/\u001a3\t\u000f\u0005UR\u00021\u0001\u00028\u0005)\u0001/\u0019:usB!\u0011\u0011HA'\u001d\u0011\tY$a\u0012\u000f\t\u0005u\u0012\u0011\t\b\u0004C\u0006}\u0012BA-\"\u0013\u0011\t\u0019%!\u0012\u0002\u0017I,g-\u001b8f[\u0016tGo\u001d\u0006\u00033\u0006JA!!\u0013\u0002L\u0005A\u0011\t]5UsB,7O\u0003\u0003\u0002D\u0005\u0015\u0013\u0002BA(\u0003#\u0012Q\u0001U1sifTA!!\u0013\u0002L!9\u0011QK\u0007A\u0002\u0005]\u0013\u0001\u0005;f[Bd\u0017\r^3TK2,7\r^8s!\r!\u0018\u0011L\u0005\u0004\u00037j\"\u0001\u0005+f[Bd\u0017\r^3TK2,7\r^8s\u0011\u001d\ty&\u0004a\u0001\u0003C\n1b\u001d;beR|eMZ:fiB!\u00111MA7\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!\u00047fI\u001e,'oX8gMN,GO\u0003\u0003\u0002l\u0005\u0015\u0013A\u0001<2\u0013\u0011\ty'!\u001a\u0003\u00191+GmZ3s\u001f\u001a47/\u001a;\t\u000f\u0005MT\u00021\u0001\u0002v\u0005IQM\u001c3PM\u001a\u001cX\r\u001e\t\u0006U\u0005]\u0014\u0011M\u0005\u0004\u0003sZ#AB(qi&|g\u000eC\u0005\u0002~5\u0001\n\u00111\u0001\u0002\u0000\u0005)Ao\\6f]B)!&a\u001e\u0002\u0002B!\u00111QAF\u001d\u0011\t))a\"\u0011\u0005\u0011\\\u0013bAAEW\u00051\u0001K]3eK\u001aLA!!$\u0002\u0010\n11\u000b\u001e:j]\u001eT1!!#,\u0003m!(/\u00198tC\u000e$\u0018n\u001c8T_V\u00148-\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011Q\u0013\u0016\u0005\u0003\u007f\n9j\u000b\u0002\u0002\u001aB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016!C;oG\",7m[3e\u0015\r\t\u0019kK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAT\u0003;\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0005M\u0019u.\\7b]\u0012$&/Y2lS:<g\t\\8x+\u0011\ti+!1\u0011\u0015\u0005M\u0011qVAZ\u00037\fY#\u0003\u0003\u00022\u0006U!\u0001\u0002$m_^\u0004\u0002\"!.\u0002:\u0006u\u00161[\u0007\u0003\u0003oS!aV\u0012\n\t\u0005m\u0016q\u0017\u0002\u0004\u0007RD\b\u0003BA`\u0003\u0003d\u0001\u0001B\u0004\u0002D>\u0011\r!!2\u0003\u0003\r\u000bB!a2\u0002NB\u0019!&!3\n\u0007\u0005-7FA\u0004O_RD\u0017N\\4\u0011\u0007)\ny-C\u0002\u0002R.\u00121!\u00118z!\u0011\t).a6\u000e\u0005\u0005-\u0013\u0002BAm\u0003\u0017\u0012\u0001cQ8na>\u001c\u0018\u000e^3D_6l\u0017M\u001c3\u0011\u0011\u0005U\u0016\u0011XA_\u0003;\u0004\u0002\"a8\u0002j\u0006=(Q\u0003\b\u0005\u0003C\f)OD\u0002e\u0003GL\u0011\u0001L\u0005\u0004\u0003O\\\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003W\fiO\u0001\u0004FSRDWM\u001d\u0006\u0004\u0003O\\\u0003\u0003BAy\u0005\u001fqA!a=\u0003\n9!\u0011Q\u001fB\u0002\u001d\u0011\t90!@\u000f\u0007\u0001\fI0C\u0002\u0002|~\t\u0001b]3sm&\u001cWm]\u0005\u0005\u0003\u007f\u0014\t!\u0001\u0005d_6l\u0017M\u001c3t\u0015\r\tYpH\u0005\u0005\u0005\u000b\u00119!A\u0004ue\u0006\u001c7.\u001a:\u000b\t\u0005}(\u0011A\u0005\u0005\u0005\u0017\u0011i!\u0001\nD_6\u0004H.\u001a;j_:\u0014Vm\u001d9p]N,'\u0002\u0002B\u0003\u0005\u000fIAA!\u0005\u0003\u0014\t\t2i\\7qY\u0016$\u0018n\u001c8GC&dWO]3\u000b\t\t-!Q\u0002\t\u0005\u0003c\u00149\"\u0003\u0003\u0003\u001a\tM!!E\"p[BdW\r^5p]N+8mY3tg\u000692m\\7q_NLG/Z\"p[6\fg\u000eZ!eCB$XM]\u000b\u0003\u0005?\u0001B!!6\u0003\"%!!1EA&\u0005]\u0019u.\u001c9pg&$XmQ8n[\u0006tG-\u00113baR,'/\u0001\rd_6\u0004xn]5uK\u000e{W.\\1oI\u0006#\u0017\r\u001d;fe\u0002\n\u0011D]3uefLgnZ\"p]\u001aL'/\\3e\u0007>lW.\u00198egV!!1\u0006B!)\u0011\u0011iC!\u0014\u0015\t\t=\"1\t\t\u0007\u0005c\u00119Da\u000f\u000e\u0005\tM\"b\u0001B\u001bW\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\te\"1\u0007\u0002\u0007\rV$XO]3\u0011\u000b\turBa\u0010\u000e\u0003\u0001\u0001B!a0\u0003B\u00119\u00111\u0019\nC\u0002\u0005\u0015\u0007b\u0002B#%\u0001\u000f!qI\u0001\u0003K\u000e\u0004BA!\r\u0003J%!!1\nB\u001a\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0004\u00026I\u0001\r!a\u000e\u0003\u0019\r{W.\\1oIN4En\\<\u0016\t\tM#\u0011\f\t\u000b\u0003'\tyK!\u0016\u0003\\\u0005-\u0002\u0003CA[\u0003s\u00139&a5\u0011\t\u0005}&\u0011\f\u0003\b\u0003\u0007\u001c\"\u0019AAc!!\t),!/\u0003X\u0005uW\u0003\u0002B0\u0005S\"BA!\u0019\u0003nQ!!1\rB6!\u0019\u0011\tDa\u000e\u0003fA)!QH\n\u0003hA!\u0011q\u0018B5\t\u001d\t\u0019\r\u0006b\u0001\u0003\u000bDqA!\u0012\u0015\u0001\b\u00119\u0005C\u0004\u00026Q\u0001\r!a\u000e\u0002\u0011MDW\u000f\u001e3po:$\"Aa\u001d\u0015\t\tU$Q\u0010\t\u0007\u0005c\u00119Da\u001e\u0011\u0007)\u0012I(C\u0002\u0003|-\u0012A!\u00168ji\"9!QI\u000bA\u0004\t\u001d\u0013a\u0005'fI\u001e,'o\u00117jK:$()\u001b8eS:<\u0007C\u0001;\u0018'\t9\u0012\u0006\u0006\u0002\u0003\u0002\u0006i1M]3bi\u0016\u001c\u0005.\u00198oK2$r!\u0011BF\u0005\u001f\u0013I\nC\u0004\u0003\u000ef\u0001\r!!!\u0002\t!|7\u000f\u001e\u0005\b\u0005#K\u0002\u0019\u0001BJ\u0003\u0011\u0001xN\u001d;\u0011\u0007)\u0012)*C\u0002\u0003\u0018.\u00121!\u00138u\u0011\u001d\u0011Y*\u0007a\u0001\u0005;\u000b!b]:m\u0007>tG/\u001a=u!\u0015Q\u0013q\u000fBP!\u0011\u0011\tKa,\u000e\u0005\t\r&\u0002\u0002BS\u0005O\u000b1a]:m\u0015\u0011\u0011IKa+\u0002\u000f!\fg\u000e\u001a7fe*\u0019!QV#\u0002\u000b9,G\u000f^=\n\t\tE&1\u0015\u0002\u000b'Nd7i\u001c8uKb$\u0018aC1tW2+GmZ3s\u0013\u0012$bAa.\u0003>\n}F\u0003\u0002B]\u0005w\u0003bA!\r\u00038\u0005\u0005\u0005b\u0002B#5\u0001\u000f!q\t\u0005\u0006\u007fi\u0001\r!\u0011\u0005\u0007\u0005\u0003T\u0002\u0019\u0001\u001d\u0002\r\r|gNZ5h\u0003E!(/\u00198tC\u000e$\u0018n\u001c8GS2$XM\u001d\u000b\u0007\u0005\u000f\u0014\u0019N!6\u0011\t\t%'qZ\u0007\u0003\u0005\u0017TAA!4\u0002j\u0005\u0011BO]1og\u0006\u001cG/[8o?\u001aLG\u000e^3s\u0013\u0011\u0011\tNa3\u0003#Q\u0013\u0018M\\:bGRLwN\u001c$jYR,'\u000fC\u0004\u00026m\u0001\r!a\u000e\t\u000f\u0005U3\u00041\u0001\u0002X\u0001")
public class LedgerClientBinding {
    private final LedgerClient ledgerClient;
    private final LedgerClientConfiguration ledgerClientConfig;
    private final ManagedChannel channel;
    private final Duration retryTimeout;
    private final TimeProvider timeProvider;
    private final Function1<CreatedEvent, Either<EventDecoderError, Contract<Object>>> decoder;
    private final Logger logger;
    private final CompositeCommandAdapter compositeCommandAdapter;

    public static TransactionFilter transactionFilter(Object party, TemplateSelector templateSelector) {
        return LedgerClientBinding$.MODULE$.transactionFilter(party, templateSelector);
    }

    public static Future<String> askLedgerId(ManagedChannel channel, LedgerClientConfiguration config, ExecutionContext ec) {
        return LedgerClientBinding$.MODULE$.askLedgerId(channel, config, ec);
    }

    public static ManagedChannel createChannel(String host, int port, Option<SslContext> sslContext) {
        return LedgerClientBinding$.MODULE$.createChannel(host, port, sslContext);
    }

    public LedgerClient ledgerClient() {
        return this.ledgerClient;
    }

    public LedgerClientConfiguration ledgerClientConfig() {
        return this.ledgerClientConfig;
    }

    public ManagedChannel channel() {
        return this.channel;
    }

    private Logger logger() {
        return this.logger;
    }

    public Source<DomainTransaction, NotUsed> transactionSource(Object party, TemplateSelector templateSelector, LedgerOffset startOffset, Option<LedgerOffset> endOffset, Option<String> token) {
        this.logger().debug("[tx {}] subscription start with offset template selector {}, start {}, end {}", new Object[]{ApiTypes$.MODULE$.Party().unwrap(party), templateSelector, startOffset, endOffset});
        LedgerOffset x$1 = startOffset;
        Option<LedgerOffset> x$2 = endOffset;
        TransactionFilter x$3 = LedgerClientBinding$.MODULE$.transactionFilter(party, templateSelector);
        Option<String> x$4 = token;
        boolean x$5 = this.ledgerClient().transactionClient().getTransactions$default$4();
        return this.ledgerClient().transactionClient().getTransactions(x$1, x$2, x$3, x$5, x$4).via(new Slf4JLogger(this.logger(), new StringBuilder(3).append("tx ").append(party).toString(), (Function1 & Serializable)tx -> new StringBuilder(18).append("CID ").append(tx.commandId()).append(" TX ").append(tx.transactionId()).append(" CONTAINS ").append(((IterableOnceOps)tx.events().map((Function1 & Serializable)x0$1 -> {
            Event.Event event;
            String string;
            Event.Event event2;
            Event event3 = x0$1;
            if (event3 != null && (event2 = event3.event()) instanceof Event.Event$.Created) {
                Event.Event$.Created created = (Event.Event$.Created)event2;
                CreatedEvent value = created.value();
                string = new StringBuilder(2).append("C ").append(value.contractId()).toString();
            } else if (event3 != null && (event = event3.event()) instanceof Event.Event$.Archived) {
                Event.Event$.Archived archived = (Event.Event$.Archived)event;
                ArchivedEvent value = archived.value();
                string = new StringBuilder(2).append("A ").append(value.contractId()).toString();
            } else {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(34).append("Expected Created or Archived, got ").append(event3).toString());
            }
            return string;
        })).mkString("[", ",", "]")).toString(), Slf4JLogger$.MODULE$.apply$default$4())).via(DomainTransactionMapper$.MODULE$.apply(this.decoder));
    }

    public Option<String> transactionSource$default$5() {
        return None$.MODULE$;
    }

    private CompositeCommandAdapter compositeCommandAdapter() {
        return this.compositeCommandAdapter;
    }

    public <C> Future<Flow<Ctx<C, CompositeCommand>, Ctx<C, Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, NotUsed>> retryingConfirmedCommands(Object party, ExecutionContext ec) {
        return CommandRetryFlow$.MODULE$.apply(party, this.ledgerClient().commandClient(), this.timeProvider, this.retryTimeout, ec).map((Function1 & Serializable)tracking -> ((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)x$1 -> x$1.map((Function1 & Serializable)compositeCommand -> new CommandSubmission(this.compositeCommandAdapter().transform(compositeCommand), CommandSubmission$.MODULE$.apply$default$2())))).via((Graph)tracking), ec);
    }

    public <C> Future<Flow<Ctx<C, CompositeCommand>, Ctx<C, Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, NotUsed>> commands(Object party, ExecutionContext ec) {
        return this.ledgerClient().commandClient().trackCommands((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(party))})), (Option)None$.MODULE$, ec).map((Function1 & Serializable)trackCommandsFlow -> ((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)x$2 -> x$2.map((Function1 & Serializable)compositeCommand -> new CommandSubmission(this.compositeCommandAdapter().transform(compositeCommand), CommandSubmission$.MODULE$.apply$default$2())))).via((Graph)trackCommandsFlow).mapMaterializedValue((Function1 & Serializable)x$3 -> NotUsed$.MODULE$), ec);
    }

    public Future<BoxedUnit> shutdown(ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.channel().shutdown();
            this.channel().awaitTermination(1L, TimeUnit.MINUTES);
        }, ec);
    }

    public LedgerClientBinding(LedgerClient ledgerClient, LedgerClientConfiguration ledgerClientConfig, ManagedChannel channel, Duration retryTimeout, TimeProvider timeProvider, Function1<CreatedEvent, Either<EventDecoderError, Contract<Object>>> decoder) {
        this.ledgerClient = ledgerClient;
        this.ledgerClientConfig = ledgerClientConfig;
        this.channel = channel;
        this.retryTimeout = retryTimeout;
        this.timeProvider = timeProvider;
        this.decoder = decoder;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.compositeCommandAdapter = new CompositeCommandAdapter(ApiTypes$.MODULE$.LedgerId().apply(TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(ledgerClient.ledgerId()))), ApiTypes$.MODULE$.ApplicationId().apply((Object)ledgerClientConfig.applicationId()));
    }
}

