/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.client.binding;

import com.daml.ledger.api.refinements.ApiTypes$;
import com.daml.ledger.api.v1.event.ArchivedEvent;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.event.Event;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset;
import com.daml.ledger.api.v1.transaction.Transaction;
import com.daml.ledger.client.binding.Contract;
import com.daml.ledger.client.binding.DomainArchivedEvent;
import com.daml.ledger.client.binding.DomainCreatedEvent;
import com.daml.ledger.client.binding.DomainEvent;
import com.daml.ledger.client.binding.DomainTransaction;
import com.daml.ledger.client.binding.DomainTransactionMapper$;
import com.daml.ledger.client.binding.DomainTransactionMapper$EmptyEvent$;
import com.daml.ledger.client.binding.EventDecoderError;
import com.google.protobuf.timestamp.Timestamp;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalaz.Applicative;
import scalaz.std.either$;
import scalaz.std.list$;

@ScalaSignature(bytes="\u0006\u0005\tew!\u0002\u001a4\u0011\u0003qd!\u0002!4\u0011\u0003\t\u0005\"\u0002%\u0002\t\u0003IU\u0001\u0002&\u0002\u0001-CQA\\\u0001\u0005\u0002=4\u0011\"a\b\u0002!\u0003\rJ#!\t\u0007\r\u0005U\u0015ARAL\u0011)\tIJ\u0002BK\u0002\u0013\u0005\u00111\u0014\u0005\u000b\u0003W3!\u0011#Q\u0001\n\u0005u\u0005B\u0002%\u0007\t\u0003\ti\u000bC\u0005\u00024\u001a\t\t\u0011\"\u0001\u00026\"I\u0011\u0011\u0018\u0004\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003w1\u0011\u0011!C!\u0003{A\u0011\"a\u0014\u0007\u0003\u0003%\t!!\u0015\t\u0013\u0005ec!!A\u0005\u0002\u0005E\u0007\"CA4\r\u0005\u0005I\u0011IA5\u0011%\t9HBA\u0001\n\u0003\t)\u000eC\u0005\u0002Z\u001a\t\t\u0011\"\u0011\u0002\\\"I\u00111\u0011\u0004\u0002\u0002\u0013\u0005\u0013Q\u0011\u0005\n\u0003\u000f3\u0011\u0011!C!\u0003\u0013C\u0011\"a8\u0007\u0003\u0003%\t%!9\b\u0013\u0005\u0015\u0018!!A\t\n\u0005\u001dh!CAK\u0003\u0005\u0005\t\u0012BAu\u0011\u0019Ae\u0003\"\u0001\u0003\u0002!I\u0011q\u0011\f\u0002\u0002\u0013\u0015\u0013\u0011\u0012\u0005\t]Z\t\t\u0011\"!\u0003\u0004!I!q\u0001\f\u0002\u0002\u0013\u0005%\u0011\u0002\u0005\n\u0003\u00173\u0012\u0011!C\u0005\u0003\u001b;qA!\u0006\u0002\u0011\u001b\u000bIDB\u0004\u00022\u0005Ai)a\r\t\r!kB\u0011AA\u001c\u0011%\tY$HA\u0001\n\u0003\ni\u0004C\u0005\u0002Pu\t\t\u0011\"\u0001\u0002R!I\u0011\u0011L\u000f\u0002\u0002\u0013\u0005\u00111\f\u0005\n\u0003Oj\u0012\u0011!C!\u0003SB\u0011\"a\u001e\u001e\u0003\u0003%\t!!\u001f\t\u0013\u0005\rU$!A\u0005B\u0005\u0015\u0005\"CAD;\u0005\u0005I\u0011IAE\u0011%\tY)HA\u0001\n\u0013\tiIB\u0003Ag\u0001\u00119\u0002\u0003\u0006\u0002\u001a\u001d\u0012\t\u0011)A\u0005\u0005SAa\u0001S\u0014\u0005\u0002\t\u0005\u0003b\u0002B$O\u0011\u0005!\u0011\n\u0005\b\u0005\u0017:C\u0011\u0002B'\u0011\u001d\u0011If\nC\u0005\u00057BqAa\u001f(\t\u0013\u0011i\bC\u0004\u0003\u001a\u001e\"IAa'\t\u000f\t\rv\u0005\"\u0003\u0003&\"9!qV\u0014\u0005\n\tE\u0006b\u0002BbO\u0011%!QY\u0001\u0018\t>l\u0017-\u001b8Ue\u0006t7/Y2uS>tW*\u00199qKJT!\u0001N\u001b\u0002\u000f\tLg\u000eZ5oO*\u0011agN\u0001\u0007G2LWM\u001c;\u000b\u0005aJ\u0014A\u00027fI\u001e,'O\u0003\u0002;w\u0005!A-Y7m\u0015\u0005a\u0014aA2p[\u000e\u0001\u0001CA \u0002\u001b\u0005\u0019$a\u0006#p[\u0006Lg\u000e\u0016:b]N\f7\r^5p]6\u000b\u0007\u000f]3s'\t\t!\t\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u00121\u0002R3d_\u0012,'\u000fV=qKB!1\t\u0014(Y\u0013\tiEIA\u0005Gk:\u001cG/[8ocA\u0011qJV\u0007\u0002!*\u0011\u0011KU\u0001\u0006KZ,g\u000e\u001e\u0006\u0003'R\u000b!A^\u0019\u000b\u0005U;\u0014aA1qS&\u0011q\u000b\u0015\u0002\r\u0007J,\u0017\r^3e\u000bZ,g\u000e\u001e\t\u00053\u0006$wM\u0004\u0002[?:\u00111LX\u0007\u00029*\u0011Q,P\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015K!\u0001\u0019#\u0002\u000fA\f7m[1hK&\u0011!m\u0019\u0002\u0007\u000b&$\b.\u001a:\u000b\u0005\u0001$\u0005CA f\u0013\t17GA\tFm\u0016tG\u000fR3d_\u0012,'/\u0012:s_J\u0004\"\u0001[6\u000f\u0005}J\u0017B\u000164\u0003!\u0019uN\u001c;sC\u000e$\u0018B\u00017n\u0005\u0015ye-\u00118z\u0015\tQ7'A\u0003baBd\u0017\u0010F\u0002q\u0003/\u0001r!\u001d?\u007f\u0003\u0013\ty!D\u0001s\u0015\t\u0019H/\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\t)h/\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003ob\fQ\u0001]3lW>T!!\u001f>\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0018aA8sO&\u0011QP\u001d\u0002\u0005\r2|w\u000fE\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\r!+A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BA\u0004\u0003\u0003\u00111\u0002\u0016:b]N\f7\r^5p]B\u0019q(a\u0003\n\u0007\u000551GA\tE_6\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:\u0004B!!\u0005\u0002\u00145\ta/C\u0002\u0002\u0016Y\u0014qAT8u+N,G\rC\u0004\u0002\u001a\u0011\u0001\r!a\u0007\u0002\u000f\u0011,7m\u001c3feB\u0019\u0011QD\u0002\u000e\u0003\u0005\u0011A#\u00138qkR4\u0016\r\\5eCRLwN\\#se>\u00148CB\u0003C\u0003G\tI\u0003E\u0002D\u0003KI1!a\nE\u0005\u001d\u0001&o\u001c3vGR\u00042!WA\u0016\u0013\r\tic\u0019\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0015\u0004\u000bu1!AC#naRLXI^3oiNAQDQA\u001b\u0003G\tI\u0003E\u0002\u0002\u001e\u0015!\"!!\u000f\u0011\u0007\u0005uQ$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0003mC:<'BAA%\u0003\u0011Q\u0017M^1\n\t\u00055\u00131\t\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005M\u0003cA\"\u0002V%\u0019\u0011q\u000b#\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005u\u00131\r\t\u0004\u0007\u0006}\u0013bAA1\t\n\u0019\u0011I\\=\t\u0013\u0005\u0015\u0014%!AA\u0002\u0005M\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002lA1\u0011QNA:\u0003;j!!a\u001c\u000b\u0007\u0005ED)\u0001\u0006d_2dWm\u0019;j_:LA!!\u001e\u0002p\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tY(!!\u0011\u0007\r\u000bi(C\u0002\u0002\u0000\u0011\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002f\r\n\t\u00111\u0001\u0002^\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002T\u0005AAo\\*ue&tw\r\u0006\u0002\u0002@\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u0012\t\u0005\u0003\u0003\n\t*\u0003\u0003\u0002\u0014\u0006\r#AB(cU\u0016\u001cGO\u0001\u0010SKF,\u0018N]3e\r&,G\u000e\u001a#pKNtu\u000e^#ySN$XI\u001d:peNAaAQA\u001b\u0003G\tI#A\u0003gS\u0016dG-\u0006\u0002\u0002\u001eB!\u0011qTAT\u001d\u0011\t\t+a)\u0011\u0005m#\u0015bAAS\t\u00061\u0001K]3eK\u001aLA!!\u0014\u0002**\u0019\u0011Q\u0015#\u0002\r\u0019LW\r\u001c3!)\u0011\ty+!-\u0011\u0007\u0005ua\u0001C\u0004\u0002\u001a&\u0001\r!!(\u0002\t\r|\u0007/\u001f\u000b\u0005\u0003_\u000b9\fC\u0005\u0002\u001a*\u0001\n\u00111\u0001\u0002\u001e\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA_U\u0011\ti*a0,\u0005\u0005\u0005\u0007\u0003BAb\u0003\u001bl!!!2\u000b\t\u0005\u001d\u0017\u0011Z\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a3E\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\f)MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$B!!\u0018\u0002T\"I\u0011Q\r\b\u0002\u0002\u0003\u0007\u00111\u000b\u000b\u0005\u0003w\n9\u000eC\u0005\u0002fA\t\t\u00111\u0001\u0002^\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ty$!8\t\u0013\u0005\u0015\u0014#!AA\u0002\u0005M\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002|\u0005\r\b\"CA3)\u0005\u0005\t\u0019AA/\u0003y\u0011V-];je\u0016$g)[3mI\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;FeJ|'\u000fE\u0002\u0002\u001eY\u0019RAFAv\u0003o\u0004\u0002\"!<\u0002t\u0006u\u0015qV\u0007\u0003\u0003_T1!!=E\u0003\u001d\u0011XO\u001c;j[\u0016LA!!>\u0002p\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\u0005e\u0018q`\u0007\u0003\u0003wTA!!@\u0002H\u0005\u0011\u0011n\\\u0005\u0005\u0003[\tY\u0010\u0006\u0002\u0002hR!\u0011q\u0016B\u0003\u0011\u001d\tI*\u0007a\u0001\u0003;\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\f\tE\u0001#B\"\u0003\u000e\u0005u\u0015b\u0001B\b\t\n1q\n\u001d;j_:D\u0011Ba\u0005\u001b\u0003\u0003\u0005\r!a,\u0002\u0007a$\u0003'\u0001\u0006F[B$\u00180\u0012<f]R\u001cBa\n\"\u0003\u001aA!!1\u0004B\u0013\u001b\t\u0011iB\u0003\u0003\u0003 \t\u0005\u0012\u0001D:dC2\fGn\\4hS:<'b\u0001B\u0012w\u0005AA/\u001f9fg\u00064W-\u0003\u0003\u0003(\tu!a\u0003'bufdunZ4j]\u001e\u00042Aa\u000b\u0004\u001d\r\u0011i\u0003\u0001\b\u0005\u0005_\u0011yD\u0004\u0003\u00032\tub\u0002\u0002B\u001a\u0005wqAA!\u000e\u0003:9\u00191La\u000e\n\u0003qJ!AO\u001e\n\u0005aJ\u0014B\u0001\u001c8\u0013\t!T\u0007\u0006\u0003\u0003D\t\u0015\u0003CA (\u0011\u001d\tI\"\u000ba\u0001\u0005S\t!\u0003\u001e:b]N\f7\r^5p]Nl\u0015\r\u001d9feV\t\u0001/A\te_6\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:$BAa\u0014\u0003VA1\u0011,\u0019B)\u0003\u0013\u00012Aa\u0015\u0006\u001d\ty\u0004\u0001\u0003\u0004\u0003X-\u0002\rA`\u0001\u0002i\u0006Y1\r[3dW\u0016C\u0018n\u001d;t+\u0011\u0011iF!\u001a\u0015\r\t}#\u0011\u000fB;!\u0019I\u0016M!\u0015\u0003bA!!1\rB3\u0019\u0001!qAa\u001a-\u0005\u0004\u0011IGA\u0001U#\u0011\u0011Y'!\u0018\u0011\u0007\r\u0013i'C\u0002\u0003p\u0011\u0013qAT8uQ&tw\rC\u0004\u0003t1\u0002\r!!(\u0002\u0013\u0019LW\r\u001c3OC6,\u0007b\u0002B<Y\u0001\u0007!\u0011P\u0001\r[\u0006L(-Z#mK6,g\u000e\u001e\t\u0006\u0007\n5!\u0011M\u0001\rI>l\u0017-\u001b8Fm\u0016tGo\u001d\u000b\u0005\u0005\u007f\u0012i\t\u0005\u0004ZC\nE#\u0011\u0011\t\u00063\n\r%qQ\u0005\u0004\u0005\u000b\u001b'aA*fcB\u0019qH!#\n\u0007\t-5GA\u0006E_6\f\u0017N\\#wK:$\bb\u0002BH[\u0001\u0007!\u0011S\u0001\u0007KZ,g\u000e^:\u0011\u000be\u0013\u0019Ia%\u0011\u0007=\u0013)*C\u0002\u0003\u0018B\u0013Q!\u0012<f]R\f\u0001\"\\1q\u000bZ,g\u000e\u001e\u000b\u0005\u0005;\u0013\t\u000b\u0005\u0004ZC\nE#q\u0014\t\u0006\u0007\n5!q\u0011\u0005\u0007#:\u0002\rAa%\u0002\u001b1|w-\u00118e\t&\u001c8-\u0019:e)\u0011\u00119K!,\u0015\t\tu%\u0011\u0016\u0005\u0007\u0005W{\u0003\u0019\u00013\u0002\u0007\u0015\u0014(\u000fC\u0003R_\u0001\u0007a*A\bnCB\u001c%/Z1uK\u0012,e/\u001a8u)\u0019\u0011\u0019La/\u0003@B1\u0011,\u0019B)\u0005k\u00032a\u0010B\\\u0013\r\u0011Il\r\u0002\u0013\t>l\u0017-\u001b8De\u0016\fG/\u001a3Fm\u0016tG\u000f\u0003\u0004\u0003>B\u0002\rAT\u0001\rGJ,\u0017\r^3e\u000bZ,g\u000e\u001e\u0005\u0007\u0005\u0003\u0004\u0004\u0019A4\u0002\u0011\r|g\u000e\u001e:bGR\f\u0001#\\1q\u0003J\u001c\u0007.\u001b<fI\u00163XM\u001c;\u0015\t\t\u001d'q\u001a\t\u00073\u0006\u0014\tF!3\u0011\u0007}\u0012Y-C\u0002\u0003NN\u00121\u0003R8nC&t\u0017I]2iSZ,G-\u0012<f]RDqA!52\u0001\u0004\u0011\u0019.A\u0007be\u000eD\u0017N^3e\u000bZ,g\u000e\u001e\t\u0004\u001f\nU\u0017b\u0001Bl!\ni\u0011I]2iSZ,G-\u0012<f]R\u0004")
public class DomainTransactionMapper
implements LazyLogging {
    private final Function1<CreatedEvent, Either<EventDecoderError, Contract<Object>>> decoder;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Flow<Transaction, DomainTransaction, NotUsed> apply(Function1<CreatedEvent, Either<EventDecoderError, Contract<Object>>> decoder) {
        return DomainTransactionMapper$.MODULE$.apply(decoder);
    }

    private Logger logger$lzycompute() {
        DomainTransactionMapper domainTransactionMapper = this;
        synchronized (domainTransactionMapper) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Flow<Transaction, DomainTransaction, NotUsed> transactionsMapper() {
        return (Flow)Flow$.MODULE$.apply().mapConcat((Function1 & Serializable)transaction -> {
            Either<InputValidationError, DomainTransaction> either = this.domainTransaction((Transaction)transaction);
            if (either instanceof Left) {
                BoxedUnit boxedUnit;
                Left left = (Left)either;
                InputValidationError error = (InputValidationError)left.value();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Input validation error when converting to domain transaction: {}. Transaction is discarded.", (Object)error);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return package$.MODULE$.List().empty();
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                DomainTransaction t = (DomainTransaction)right.value();
                return new .colon.colon((Object)t, (List)Nil$.MODULE$);
            }
            throw new MatchError(either);
        });
    }

    private Either<InputValidationError, DomainTransaction> domainTransaction(Transaction t) {
        return this.checkExists("effectiveAt", t.effectiveAt()).flatMap((Function1 & Serializable)effectiveAt -> this.domainEvents((Seq<Event>)t.events()).map((Function1 & Serializable)events -> {
            Object transactionId = ApiTypes$.MODULE$.TransactionId().apply((Object)t.transactionId());
            Object workflowId = ApiTypes$.MODULE$.WorkflowId().apply((Object)t.workflowId());
            LedgerOffset offset = new LedgerOffset((LedgerOffset.Value)new LedgerOffset.Value$.Absolute(t.offset()));
            Object commandId = ApiTypes$.MODULE$.CommandId().apply((Object)t.commandId());
            return new Tuple5(events, transactionId, workflowId, (Object)offset, commandId);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple5 tuple5 = x$1;
            if (tuple5 != null) {
                Seq events = (Seq)tuple5._1();
                Object transactionId = tuple5._2();
                Object workflowId = tuple5._3();
                LedgerOffset offset = (LedgerOffset)tuple5._4();
                Object commandId = tuple5._5();
                return new DomainTransaction(transactionId, workflowId, offset, commandId, (Timestamp)effectiveAt, (Seq<DomainEvent>)events);
            }
            throw new MatchError((Object)tuple5);
        }));
    }

    private <T> Either<InputValidationError, T> checkExists(String fieldName, Option<T> maybeElement) {
        Option<T> option = maybeElement;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object element = some.value();
            return package$.MODULE$.Right().apply(element);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)new RequiredFieldDoesNotExistError(fieldName));
        }
        throw new MatchError(option);
    }

    private Either<InputValidationError, Seq<DomainEvent>> domainEvents(Seq<Event> events) {
        return ((Either)scalaz.syntax.package$.MODULE$.traverse().ToTraverseOps((Object)events.toList(), list$.MODULE$.listInstance()).traverse((Function1 & Serializable)event -> this.mapEvent((Event)event).map((Function1 & Serializable)domainEvent -> domainEvent.toList()), (Applicative)either$.MODULE$.eitherMonad())).map((Function1 & Serializable)x$2 -> (List)x$2.flatten(Predef$.MODULE$.$conforms()));
    }

    private Either<InputValidationError, Option<DomainEvent>> mapEvent(Event event) {
        Event.Event event2 = event.event();
        if (event2 instanceof Event.Event$.Created) {
            Event.Event$.Created created = (Event.Event$.Created)event2;
            CreatedEvent createdEvent = created.value();
            return (Either)((Either)this.decoder.apply((Object)createdEvent)).fold((Function1 & Serializable)err -> this.logAndDiscard(createdEvent, (EventDecoderError)err), (Function1 & Serializable)x$3 -> this.mapCreatedEvent(createdEvent, (Contract<Object>)x$3).map((Function1 & Serializable)value -> new Some(value)));
        }
        if (event2 instanceof Event.Event$.Archived) {
            Event.Event$.Archived archived = (Event.Event$.Archived)event2;
            ArchivedEvent archivedEvent = archived.value();
            return this.mapArchivedEvent(archivedEvent).map((Function1 & Serializable)value -> new Some(value));
        }
        if (Event.Event$.Empty$.MODULE$.equals(event2)) {
            return package$.MODULE$.Left().apply((Object)DomainTransactionMapper$EmptyEvent$.MODULE$);
        }
        throw new MatchError((Object)event2);
    }

    private Either<InputValidationError, Option<DomainEvent>> logAndDiscard(CreatedEvent event, EventDecoderError err) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Unhandled create event {}. Error: {}", new Object[]{event.toString(), err.toString()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return package$.MODULE$.Right().apply((Object)None$.MODULE$);
    }

    private Either<InputValidationError, DomainCreatedEvent> mapCreatedEvent(CreatedEvent createdEvent, Contract<Object> contract) {
        return this.checkExists("events.witnessedEvents.event.created.templateId", createdEvent.templateId()).flatMap((Function1 & Serializable)tid -> this.checkExists("events.witnessedEvents.event.created.createArguments", createdEvent.createArguments()).map((Function1 & Serializable)arguments -> {
            Object eventId = ApiTypes$.MODULE$.EventId().apply((Object)createdEvent.eventId());
            Object contractId = ApiTypes$.MODULE$.ContractId().apply((Object)createdEvent.contractId());
            Object templateId = ApiTypes$.MODULE$.TemplateId().apply(tid);
            Seq witnessParties = (Seq)((IterableOnceOps)createdEvent.witnessParties().map((Function1 & Serializable)a -> ApiTypes$.MODULE$.Party().apply(a))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
            Object createArguments = ApiTypes$.MODULE$.CreateArguments().apply(arguments);
            return new Tuple6(arguments, eventId, contractId, templateId, (Object)witnessParties, createArguments);
        }).map((Function1 & Serializable)x$4 -> {
            Tuple6 tuple6 = x$4;
            if (tuple6 != null) {
                Object eventId = tuple6._2();
                Object contractId = tuple6._3();
                Object templateId = tuple6._4();
                Seq witnessParties = (Seq)tuple6._5();
                Object createArguments = tuple6._6();
                return new DomainCreatedEvent(eventId, contractId, templateId, (Seq<Object>)witnessParties, createArguments, contract);
            }
            throw new MatchError((Object)tuple6);
        }));
    }

    private Either<InputValidationError, DomainArchivedEvent> mapArchivedEvent(ArchivedEvent archivedEvent) {
        return this.checkExists("events.witnessedEvents.event.archived.templateId", archivedEvent.templateId()).map((Function1 & Serializable)tid -> {
            Object eventId = ApiTypes$.MODULE$.EventId().apply((Object)archivedEvent.eventId());
            Object contractId = ApiTypes$.MODULE$.ContractId().apply((Object)archivedEvent.contractId());
            Object templateId = ApiTypes$.MODULE$.TemplateId().apply(tid);
            Seq witnessParties = (Seq)((IterableOnceOps)archivedEvent.witnessParties().map((Function1 & Serializable)a -> ApiTypes$.MODULE$.Party().apply(a))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
            return new Tuple5(tid, eventId, contractId, templateId, (Object)witnessParties);
        }).map((Function1 & Serializable)x$5 -> {
            Tuple5 tuple5 = x$5;
            if (tuple5 != null) {
                Object eventId = tuple5._2();
                Object contractId = tuple5._3();
                Object templateId = tuple5._4();
                Seq witnessParties = (Seq)tuple5._5();
                return new DomainArchivedEvent(eventId, contractId, templateId, (Seq<Object>)witnessParties);
            }
            throw new MatchError((Object)tuple5);
        });
    }

    public DomainTransactionMapper(Function1<CreatedEvent, Either<EventDecoderError, Contract<Object>>> decoder) {
        this.decoder = decoder;
        LazyLogging.$init$((LazyLogging)this);
    }

    private static interface InputValidationError
    extends Product,
    Serializable {
    }

    private static final class RequiredFieldDoesNotExistError
    implements InputValidationError {
        private final String field;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String field() {
            return this.field;
        }

        public RequiredFieldDoesNotExistError copy(String field) {
            return new RequiredFieldDoesNotExistError(field);
        }

        public String copy$default$1() {
            return this.field();
        }

        public String productPrefix() {
            return "RequiredFieldDoesNotExistError";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.field();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RequiredFieldDoesNotExistError;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "field";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RequiredFieldDoesNotExistError)) return false;
            boolean bl = true;
            if (!bl) return false;
            RequiredFieldDoesNotExistError requiredFieldDoesNotExistError = (RequiredFieldDoesNotExistError)x$1;
            String string = this.field();
            String string2 = requiredFieldDoesNotExistError.field();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public RequiredFieldDoesNotExistError(String field) {
            this.field = field;
            Product.$init$((Product)this);
        }
    }
}

