/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.client.binding;

import com.daml.api.util.TimeProvider;
import com.daml.ledger.api.refinements.ApiTypes$;
import com.daml.ledger.api.refinements.CompositeCommand;
import com.daml.ledger.api.refinements.CompositeCommandAdapter;
import com.daml.ledger.api.v1.event.ArchivedEvent;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.event.Event;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset;
import com.daml.ledger.api.v1.transaction_filter.TransactionFilter;
import com.daml.ledger.client.LedgerClient;
import com.daml.ledger.client.binding.Contract;
import com.daml.ledger.client.binding.DomainTransaction;
import com.daml.ledger.client.binding.DomainTransactionMapper$;
import com.daml.ledger.client.binding.EventDecoderError;
import com.daml.ledger.client.binding.LedgerClientBinding$;
import com.daml.ledger.client.binding.TemplateSelector;
import com.daml.ledger.client.binding.retrying.CommandRetryFlow$;
import com.daml.ledger.client.binding.util.Slf4JLogger;
import com.daml.ledger.client.binding.util.Slf4JLogger$;
import com.daml.ledger.client.configuration.LedgerClientConfiguration;
import com.daml.ledger.client.services.commands.CommandSubmission;
import com.daml.ledger.client.services.commands.CommandSubmission$;
import com.daml.ledger.client.services.commands.tracker.CompletionResponse;
import com.daml.util.Ctx;
import io.grpc.ManagedChannel;
import io.netty.handler.ssl.SslContext;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.NotUsed;
import org.apache.pekko.NotUsed$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scalaz.syntax.TagOps$;
import scalaz.syntax.package$;

@ScalaSignature(bytes="\u0006\u0005\tmg\u0001\u0002\u000f\u001e\u0001!B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\tk\u0001\u0011\t\u0011)A\u0005c!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u00039\u0011!y\u0004A!b\u0001\n\u0003\u0001\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u0011)\u0003!\u0011!Q\u0001\n-C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005;\")\u0011\u000f\u0001C\u0001e\"91\u0010\u0001b\u0001\n\u0013a\bbBA\u0006\u0001\u0001\u0006I! \u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011%\t)\nAI\u0001\n\u0003\t9*\u0002\u0004\u0002.\u0002\u0001\u0011q\u0016\u0005\n\u0005?\u0001!\u0019!C\u0005\u0005CA\u0001B!\u000b\u0001A\u0003%!1\u0005\u0005\b\u0005W\u0001A\u0011\u0001B\u0017\u000b\u0019\u0011\u0019\u0006\u0001\u0001\u0003V!9!1\u0001\u0001\u0005\u0002\t\u0005\u0004b\u0002B:\u0001\u0011\u0005!QO\u0004\b\u0005\u0007k\u0002\u0012\u0001BC\r\u0019aR\u0004#\u0001\u0003\b\"1\u0011o\u0006C\u0001\u0005\u0013CqAa#\u0018\t\u0003\u0011i\tC\u0004\u00038^!\tA!/\t\u000f\t\u001dw\u0003\"\u0001\u0003J\n\u0019B*\u001a3hKJ\u001cE.[3oi\nKg\u000eZ5oO*\u0011adH\u0001\bE&tG-\u001b8h\u0015\t\u0001\u0013%\u0001\u0004dY&,g\u000e\u001e\u0006\u0003E\r\na\u0001\\3eO\u0016\u0014(B\u0001\u0013&\u0003\u0011!\u0017-\u001c7\u000b\u0003\u0019\n1aY8n\u0007\u0001\u0019\"\u0001A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g\u00031aW\rZ4fe\u000ec\u0017.\u001a8u+\u0005\t\u0004C\u0001\u001a4\u001b\u0005y\u0012B\u0001\u001b \u00051aU\rZ4fe\u000ec\u0017.\u001a8u\u00035aW\rZ4fe\u000ec\u0017.\u001a8uA\u0005\u0011B.\u001a3hKJ\u001cE.[3oi\u000e{gNZ5h+\u0005A\u0004CA\u001d=\u001b\u0005Q$BA\u001e \u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011QH\u000f\u0002\u001a\u0019\u0016$w-\u001a:DY&,g\u000e^\"p]\u001aLw-\u001e:bi&|g.A\nmK\u0012<WM]\"mS\u0016tGoQ8oM&<\u0007%A\u0004dQ\u0006tg.\u001a7\u0016\u0003\u0005\u0003\"AQ$\u000e\u0003\rS!\u0001R#\u0002\t\u001d\u0014\bo\u0019\u0006\u0002\r\u0006\u0011\u0011n\\\u0005\u0003\u0011\u000e\u0013a\"T1oC\u001e,Gm\u00115b]:,G.\u0001\u0005dQ\u0006tg.\u001a7!\u00031\u0011X\r\u001e:z)&lWm\\;u!\ta\u0015+D\u0001N\u0015\tqu*\u0001\u0003uS6,'\"\u0001)\u0002\t)\fg/Y\u0005\u0003%6\u0013\u0001\u0002R;sCRLwN\\\u0001\ri&lW\r\u0015:pm&$WM\u001d\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bA!\u001e;jY*\u0011\u0011lI\u0001\u0004CBL\u0017BA.W\u00051!\u0016.\\3Qe>4\u0018\u000eZ3s\u0003\u001d!WmY8eKJ\u0004\"A\u00188\u000f\u0005}cgB\u00011l\u001d\t\t'N\u0004\u0002cS:\u00111\r\u001b\b\u0003I\u001el\u0011!\u001a\u0006\u0003M\u001e\na\u0001\u0010:p_Rt\u0014\"\u0001\u0014\n\u0005\u0011*\u0013B\u0001\u0012$\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0011Q.H\u0001\u0018\t>l\u0017-\u001b8Ue\u0006t7/Y2uS>tW*\u00199qKJL!a\u001c9\u0003\u0017\u0011+7m\u001c3feRK\b/\u001a\u0006\u0003[v\ta\u0001P5oSRtDcB:vm^D\u0018P\u001f\t\u0003i\u0002i\u0011!\b\u0005\u0006_)\u0001\r!\r\u0005\u0006m)\u0001\r\u0001\u000f\u0005\u0006\u007f)\u0001\r!\u0011\u0005\u0006\u0015*\u0001\ra\u0013\u0005\u0006'*\u0001\r\u0001\u0016\u0005\u00069*\u0001\r!X\u0001\u0007Y><w-\u001a:\u0016\u0003u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tQa\u001d7gi)T!!!\u0002\u0002\u0007=\u0014x-C\u0002\u0002\n}\u0014a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0012iJ\fgn]1di&|gnU8ve\u000e,G\u0003DA\t\u0003o\t9&!\u0019\u0002v\u0005}\u0004\u0003CA\n\u0003K\tI#a\f\u000e\u0005\u0005U!\u0002BA\f\u00033\t\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0005\u00037\ti\"\u0001\u0004tiJ,\u0017-\u001c\u0006\u0005\u0003?\t\t#A\u0003qK.\\wN\u0003\u0003\u0002$\u0005\r\u0011AB1qC\u000eDW-\u0003\u0003\u0002(\u0005U!AB*pkJ\u001cW\rE\u0002u\u0003WI1!!\f\u001e\u0005E!u.\\1j]R\u0013\u0018M\\:bGRLwN\u001c\t\u0005\u0003c\t\u0019$\u0004\u0002\u0002\u001e%!\u0011QGA\u000f\u0005\u001dqu\u000e^+tK\u0012Dq!!\u000f\u000e\u0001\u0004\tY$A\u0003qCJ$\u0018\u0010\u0005\u0003\u0002>\u0005Ec\u0002BA \u0003\u0017rA!!\u0011\u0002F9\u0019\u0011-a\u0011\n\u0005e\u000b\u0013\u0002BA$\u0003\u0013\n1B]3gS:,W.\u001a8ug*\u0011\u0011,I\u0005\u0005\u0003\u001b\ny%\u0001\u0005Ba&$\u0016\u0010]3t\u0015\u0011\t9%!\u0013\n\t\u0005M\u0013Q\u000b\u0002\u0006!\u0006\u0014H/\u001f\u0006\u0005\u0003\u001b\ny\u0005C\u0004\u0002Z5\u0001\r!a\u0017\u0002!Q,W\u000e\u001d7bi\u0016\u001cV\r\\3di>\u0014\bc\u0001;\u0002^%\u0019\u0011qL\u000f\u0003!Q+W\u000e\u001d7bi\u0016\u001cV\r\\3di>\u0014\bbBA2\u001b\u0001\u0007\u0011QM\u0001\fgR\f'\u000f^(gMN,G\u000f\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\u001b1,GmZ3s?>4gm]3u\u0015\u0011\ty'!\u0013\u0002\u0005Y\f\u0014\u0002BA:\u0003S\u0012A\u0002T3eO\u0016\u0014xJ\u001a4tKRDq!a\u001e\u000e\u0001\u0004\tI(A\u0005f]\u0012|eMZ:fiB)!&a\u001f\u0002f%\u0019\u0011QP\u0016\u0003\r=\u0003H/[8o\u0011%\t\t)\u0004I\u0001\u0002\u0004\t\u0019)A\u0003u_.,g\u000eE\u0003+\u0003w\n)\t\u0005\u0003\u0002\b\u0006=e\u0002BAE\u0003\u0017\u0003\"\u0001Z\u0016\n\u0007\u000555&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\u000b\u0019J\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001b[\u0013a\u0007;sC:\u001c\u0018m\u0019;j_:\u001cv.\u001e:dK\u0012\"WMZ1vYR$S'\u0006\u0002\u0002\u001a*\"\u00111QANW\t\ti\n\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\u0013Ut7\r[3dW\u0016$'bAATW\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0016\u0011\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,'aE\"p[6\fg\u000e\u001a+sC\u000e\\\u0017N\\4GY><X\u0003BAY\u0003\u000b\u0004\"\"a\u0005\u00024\u0006]\u0016q\\A\u0018\u0013\u0011\t),!\u0006\u0003\t\u0019cwn\u001e\t\t\u0003s\u000bi,!1\u0002X6\u0011\u00111\u0018\u0006\u0003/\u000eJA!a0\u0002<\n\u00191\t\u001e=\u0011\t\u0005\r\u0017Q\u0019\u0007\u0001\t\u001d\t9m\u0004b\u0001\u0003\u0013\u0014\u0011aQ\t\u0005\u0003\u0017\f\t\u000eE\u0002+\u0003\u001bL1!a4,\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AKAj\u0013\r\t)n\u000b\u0002\u0004\u0003:L\b\u0003BAm\u00037l!!a\u0014\n\t\u0005u\u0017q\n\u0002\u0011\u0007>l\u0007o\\:ji\u0016\u001cu.\\7b]\u0012\u0004\u0002\"!/\u0002>\u0006\u0005\u0017\u0011\u001d\t\t\u0003G\fi/a=\u0003\u001a9!\u0011Q]Au\u001d\r!\u0017q]\u0005\u0002Y%\u0019\u00111^\u0016\u0002\u000fA\f7m[1hK&!\u0011q^Ay\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u00111^\u0016\u0011\t\u0005U(1\u0003\b\u0005\u0003o\u0014iA\u0004\u0003\u0002z\n\u001da\u0002BA~\u0005\u0003q1\u0001YA\u007f\u0013\r\typH\u0001\tg\u0016\u0014h/[2fg&!!1\u0001B\u0003\u0003!\u0019w.\\7b]\u0012\u001c(bAA\u0000?%!!\u0011\u0002B\u0006\u0003\u001d!(/Y2lKJTAAa\u0001\u0003\u0006%!!q\u0002B\t\u0003I\u0019u.\u001c9mKRLwN\u001c*fgB|gn]3\u000b\t\t%!1B\u0005\u0005\u0005+\u00119BA\tD_6\u0004H.\u001a;j_:4\u0015-\u001b7ve\u0016TAAa\u0004\u0003\u0012A!\u0011Q\u001fB\u000e\u0013\u0011\u0011iBa\u0006\u0003#\r{W\u000e\u001d7fi&|gnU;dG\u0016\u001c8/A\fd_6\u0004xn]5uK\u000e{W.\\1oI\u0006#\u0017\r\u001d;feV\u0011!1\u0005\t\u0005\u00033\u0014)#\u0003\u0003\u0003(\u0005=#aF\"p[B|7/\u001b;f\u0007>lW.\u00198e\u0003\u0012\f\u0007\u000f^3s\u0003a\u0019w.\u001c9pg&$XmQ8n[\u0006tG-\u00113baR,'\u000fI\u0001\u001ae\u0016$(/_5oO\u000e{gNZ5s[\u0016$7i\\7nC:$7/\u0006\u0003\u00030\t\u0015C\u0003\u0002B\u0019\u0005#\"BAa\r\u0003HA1!Q\u0007B\u001e\u0005\u007fi!Aa\u000e\u000b\u0007\te2&\u0001\u0006d_:\u001cWO\u001d:f]RLAA!\u0010\u00038\t1a)\u001e;ve\u0016\u0004RA!\u0011\u0010\u0005\u0007j\u0011\u0001\u0001\t\u0005\u0003\u0007\u0014)\u0005B\u0004\u0002HJ\u0011\r!!3\t\u000f\t%#\u0003q\u0001\u0003L\u0005\u0011Qm\u0019\t\u0005\u0005k\u0011i%\u0003\u0003\u0003P\t]\"\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u001d\tID\u0005a\u0001\u0003w\u0011AbQ8n[\u0006tGm\u001d$m_^,BAa\u0016\u0003^AQ\u00111CAZ\u00053\u0012y&a\f\u0011\u0011\u0005e\u0016Q\u0018B.\u0003/\u0004B!a1\u0003^\u00119\u0011qY\nC\u0002\u0005%\u0007\u0003CA]\u0003{\u0013Y&!9\u0016\t\t\r$Q\u000e\u000b\u0005\u0005K\u0012\t\b\u0006\u0003\u0003h\t=\u0004C\u0002B\u001b\u0005w\u0011I\u0007E\u0003\u0003BM\u0011Y\u0007\u0005\u0003\u0002D\n5DaBAd)\t\u0007\u0011\u0011\u001a\u0005\b\u0005\u0013\"\u00029\u0001B&\u0011\u001d\tI\u0004\u0006a\u0001\u0003w\t\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0005o\"BA!\u001f\u0003\u0002B1!Q\u0007B\u001e\u0005w\u00022A\u000bB?\u0013\r\u0011yh\u000b\u0002\u0005+:LG\u000fC\u0004\u0003JU\u0001\u001dAa\u0013\u0002'1+GmZ3s\u00072LWM\u001c;CS:$\u0017N\\4\u0011\u0005Q<2CA\f*)\t\u0011))A\u0007de\u0016\fG/Z\"iC:tW\r\u001c\u000b\b\u0003\n=%1\u0013BO\u0011\u001d\u0011\t*\u0007a\u0001\u0003\u000b\u000bA\u0001[8ti\"9!QS\rA\u0002\t]\u0015\u0001\u00029peR\u00042A\u000bBM\u0013\r\u0011Yj\u000b\u0002\u0004\u0013:$\bb\u0002BP3\u0001\u0007!\u0011U\u0001\u000bgNd7i\u001c8uKb$\b#\u0002\u0016\u0002|\t\r\u0006\u0003\u0002BS\u0005gk!Aa*\u000b\t\t%&1V\u0001\u0004gNd'\u0002\u0002BW\u0005_\u000bq\u0001[1oI2,'OC\u0002\u00032\u0016\u000bQA\\3uifLAA!.\u0003(\nQ1k\u001d7D_:$X\r\u001f;\u0002\u0017\u0005\u001c8\u000eT3eO\u0016\u0014\u0018\n\u001a\u000b\u0007\u0005w\u0013\tMa1\u0015\t\tu&q\u0018\t\u0007\u0005k\u0011Y$!\"\t\u000f\t%#\u0004q\u0001\u0003L!)qH\u0007a\u0001\u0003\"1!Q\u0019\u000eA\u0002a\naaY8oM&<\u0017!\u0005;sC:\u001c\u0018m\u0019;j_:4\u0015\u000e\u001c;feR1!1\u001aBl\u00053\u0004BA!4\u0003T6\u0011!q\u001a\u0006\u0005\u0005#\fi'\u0001\nue\u0006t7/Y2uS>twLZ5mi\u0016\u0014\u0018\u0002\u0002Bk\u0005\u001f\u0014\u0011\u0003\u0016:b]N\f7\r^5p]\u001aKG\u000e^3s\u0011\u001d\tId\u0007a\u0001\u0003wAq!!\u0017\u001c\u0001\u0004\tY\u0006")
public class LedgerClientBinding {
    private final LedgerClient ledgerClient;
    private final LedgerClientConfiguration ledgerClientConfig;
    private final ManagedChannel channel;
    private final Duration retryTimeout;
    private final TimeProvider timeProvider;
    private final Function1<CreatedEvent, Either<EventDecoderError, Contract<Object>>> decoder;
    private final Logger logger;
    private final CompositeCommandAdapter compositeCommandAdapter;

    public static TransactionFilter transactionFilter(Object party, TemplateSelector templateSelector) {
        return LedgerClientBinding$.MODULE$.transactionFilter(party, templateSelector);
    }

    public static Future<String> askLedgerId(ManagedChannel channel, LedgerClientConfiguration config, ExecutionContext ec) {
        return LedgerClientBinding$.MODULE$.askLedgerId(channel, config, ec);
    }

    public static ManagedChannel createChannel(String host, int port, Option<SslContext> sslContext) {
        return LedgerClientBinding$.MODULE$.createChannel(host, port, sslContext);
    }

    public LedgerClient ledgerClient() {
        return this.ledgerClient;
    }

    public LedgerClientConfiguration ledgerClientConfig() {
        return this.ledgerClientConfig;
    }

    public ManagedChannel channel() {
        return this.channel;
    }

    private Logger logger() {
        return this.logger;
    }

    public Source<DomainTransaction, NotUsed> transactionSource(Object party, TemplateSelector templateSelector, LedgerOffset startOffset, Option<LedgerOffset> endOffset, Option<String> token) {
        this.logger().debug("[tx {}] subscription start with offset template selector {}, start {}, end {}", new Object[]{ApiTypes$.MODULE$.Party().unwrap(party), templateSelector, startOffset, endOffset});
        LedgerOffset x$1 = startOffset;
        Option<LedgerOffset> x$2 = endOffset;
        TransactionFilter x$3 = LedgerClientBinding$.MODULE$.transactionFilter(party, templateSelector);
        Option<String> x$4 = token;
        boolean x$5 = this.ledgerClient().transactionClient().getTransactions$default$4();
        return this.ledgerClient().transactionClient().getTransactions(x$1, x$2, x$3, x$5, x$4).via(new Slf4JLogger(this.logger(), new StringBuilder(3).append("tx ").append(party).toString(), (Function1 & Serializable)tx -> new StringBuilder(18).append("CID ").append(tx.commandId()).append(" TX ").append(tx.transactionId()).append(" CONTAINS ").append(((IterableOnceOps)tx.events().map((Function1 & Serializable)x0$1 -> {
            Event.Event event;
            Event.Event event2;
            Event event3 = x0$1;
            if (event3 != null && (event2 = event3.event()) instanceof Event.Event$.Created) {
                Event.Event$.Created created = (Event.Event$.Created)event2;
                CreatedEvent value = created.value();
                return new StringBuilder(2).append("C ").append(value.contractId()).toString();
            }
            if (event3 != null && (event = event3.event()) instanceof Event.Event$.Archived) {
                Event.Event$.Archived archived = (Event.Event$.Archived)event;
                ArchivedEvent value = archived.value();
                return new StringBuilder(2).append("A ").append(value.contractId()).toString();
            }
            throw scala.sys.package$.MODULE$.error(new StringBuilder(34).append("Expected Created or Archived, got ").append(event3).toString());
        })).mkString("[", ",", "]")).toString(), Slf4JLogger$.MODULE$.apply$default$4())).via(DomainTransactionMapper$.MODULE$.apply(this.decoder));
    }

    public Option<String> transactionSource$default$5() {
        return None$.MODULE$;
    }

    private CompositeCommandAdapter compositeCommandAdapter() {
        return this.compositeCommandAdapter;
    }

    public <C> Future<Flow<Ctx<C, CompositeCommand>, Ctx<C, Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, NotUsed>> retryingConfirmedCommands(Object party, ExecutionContext ec) {
        return CommandRetryFlow$.MODULE$.apply(party, this.ledgerClient().commandClient(), this.timeProvider, this.retryTimeout, ec).map((Function1 & Serializable)tracking -> ((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)x$1 -> x$1.map((Function1 & Serializable)compositeCommand -> new CommandSubmission(this.compositeCommandAdapter().transform(compositeCommand), CommandSubmission$.MODULE$.apply$default$2())))).via((Graph)tracking), ec);
    }

    public <C> Future<Flow<Ctx<C, CompositeCommand>, Ctx<C, Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, NotUsed>> commands(Object party, ExecutionContext ec) {
        return this.ledgerClient().commandClient().trackCommands((Seq)new .colon.colon((Object)((String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(party))), (List)Nil$.MODULE$), (Option)None$.MODULE$, ec).map((Function1 & Serializable)trackCommandsFlow -> ((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)x$2 -> x$2.map((Function1 & Serializable)compositeCommand -> new CommandSubmission(this.compositeCommandAdapter().transform(compositeCommand), CommandSubmission$.MODULE$.apply$default$2())))).via((Graph)trackCommandsFlow).mapMaterializedValue((Function1 & Serializable)x$3 -> NotUsed$.MODULE$), ec);
    }

    public Future<BoxedUnit> shutdown(ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.channel().shutdown();
            this.channel().awaitTermination(1L, TimeUnit.MINUTES);
        }, ec);
    }

    public LedgerClientBinding(LedgerClient ledgerClient, LedgerClientConfiguration ledgerClientConfig, ManagedChannel channel, Duration retryTimeout, TimeProvider timeProvider, Function1<CreatedEvent, Either<EventDecoderError, Contract<Object>>> decoder) {
        this.ledgerClient = ledgerClient;
        this.ledgerClientConfig = ledgerClientConfig;
        this.channel = channel;
        this.retryTimeout = retryTimeout;
        this.timeProvider = timeProvider;
        this.decoder = decoder;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.compositeCommandAdapter = new CompositeCommandAdapter(ApiTypes$.MODULE$.LedgerId().apply(TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(ledgerClient.ledgerId()))), ApiTypes$.MODULE$.ApplicationId().apply((Object)ledgerClientConfig.applicationId()));
    }
}

