/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.client.binding.retrying;

import com.daml.api.util.TimeProvider;
import com.daml.ledger.client.binding.retrying.RetryInfo;
import com.daml.ledger.client.binding.retrying.RetryInfo$;
import com.daml.ledger.client.binding.retrying.RetryLogger$;
import com.daml.ledger.client.services.commands.CommandClient;
import com.daml.ledger.client.services.commands.CommandSubmission;
import com.daml.ledger.client.services.commands.tracker.CompletionResponse;
import com.daml.tracing.TelemetryContext;
import com.daml.util.Ctx;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import org.apache.pekko.NotUsed;
import org.apache.pekko.NotUsed$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.UniformFanInShape;
import org.apache.pekko.stream.UniformFanOutShape;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.GraphDSL;
import org.apache.pekko.stream.scaladsl.GraphDSL$;
import org.apache.pekko.stream.scaladsl.Merge$;
import org.apache.pekko.stream.scaladsl.Partition$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalaz.syntax.TagOps$;
import scalaz.syntax.package$;

public final class CommandRetryFlow$ {
    public static final CommandRetryFlow$ MODULE$ = new CommandRetryFlow$();
    private static final int RETRY_PORT = 0;
    private static final int PROPAGATE_PORT = 1;
    private static final Set<Object> RETRYABLE_ERROR_CODES = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8, 14}));

    private int RETRY_PORT() {
        return RETRY_PORT;
    }

    private int PROPAGATE_PORT() {
        return PROPAGATE_PORT;
    }

    public <C> Future<Flow<Ctx<C, CommandSubmission>, Ctx<C, Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, NotUsed>> apply(Object party, CommandClient commandClient, TimeProvider timeProvider, TemporalAmount maxRetryTime, ExecutionContext ec) {
        return commandClient.trackCommands((Seq)new .colon.colon((Object)((String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(party))), (List)Nil$.MODULE$), commandClient.trackCommands$default$2(), ec).map((Function1 & Serializable)submissionFlow -> {
            Flow submissionFlowWithoutMat = submissionFlow.mapMaterializedValue((Function1 & Serializable)x$1 -> NotUsed$.MODULE$);
            Flow graph = MODULE$.createGraph(submissionFlowWithoutMat, timeProvider, maxRetryTime);
            return new Tuple3(submissionFlow, (Object)submissionFlowWithoutMat, graph);
        }, ec).map((Function1 & Serializable)x$2 -> {
            Tuple3 tuple3 = x$2;
            if (tuple3 != null) {
                Flow graph = (Flow)tuple3._3();
                return MODULE$.wrapGraph(graph, timeProvider);
            }
            throw new MatchError((Object)tuple3);
        }, ec);
    }

    public <C> Flow<Ctx<C, CommandSubmission>, Ctx<C, Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, NotUsed> wrapGraph(Flow<Ctx<RetryInfo<C, CommandSubmission>, CommandSubmission>, Ctx<RetryInfo<C, CommandSubmission>, Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, NotUsed> graph, TimeProvider timeProvider) {
        return (Flow)((Flow)Flow$.MODULE$.apply().map((Function1 & Serializable)request -> RetryInfo$.MODULE$.wrap(timeProvider, request))).via(graph).map((Function1 & Serializable)request -> RetryInfo$.MODULE$.unwrap(request));
    }

    public <C> Flow<Ctx<RetryInfo<C, CommandSubmission>, CommandSubmission>, Ctx<RetryInfo<C, CommandSubmission>, Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, NotUsed> createGraph(Flow<Ctx<RetryInfo<C, CommandSubmission>, CommandSubmission>, Ctx<RetryInfo<C, CommandSubmission>, Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, NotUsed> commandSubmissionFlow, TimeProvider timeProvider, TemporalAmount maxRetryTime) {
        return Flow$.MODULE$.fromGraph(GraphDSL$.MODULE$.createGraph(commandSubmissionFlow, (Function1 & Serializable)b -> (Function1 & Serializable)commandSubmission -> {
            UniformFanInShape merge = (UniformFanInShape)b.add((Graph)Merge$.MODULE$.apply(2, true));
            UniformFanOutShape retryDecider = (UniformFanOutShape)b.add((Graph)Partition$.MODULE$.apply(2, (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CommandRetryFlow$.$anonfun$createGraph$3(maxRetryTime, timeProvider, x0$1))));
            FlowShape convertToRetry = (FlowShape)b.add((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable)x0$2 -> {
                Ctx ctx = x0$2;
                if (ctx != null) {
                    RetryInfo retryInfo = (RetryInfo)ctx.context();
                    TelemetryContext telemetryContext = ctx.telemetryContext();
                    return new Ctx(retryInfo.newRetry(), retryInfo.value(), telemetryContext);
                }
                throw new MatchError((Object)ctx);
            }));
            GraphDSL.Implicits$.MODULE$.port2flow(merge.out(), b).$tilde$greater(commandSubmission, b).$tilde$greater(retryDecider.in(), b);
            GraphDSL.Implicits$.MODULE$.ReversePortOps(merge.in(MODULE$.RETRY_PORT())).$less$tilde(convertToRetry, b).$less$tilde(retryDecider.out(MODULE$.RETRY_PORT()), b);
            return new FlowShape(merge.in(MODULE$.PROPAGATE_PORT()), retryDecider.out(MODULE$.PROPAGATE_PORT()));
        }));
    }

    public Set<Object> RETRYABLE_ERROR_CODES() {
        return RETRYABLE_ERROR_CODES;
    }

    private int statusNotFoundError(String commandId) {
        throw new RuntimeException(new StringBuilder(31).append("Status for command ").append(commandId).append(" is missing.").toString());
    }

    public static final /* synthetic */ int $anonfun$createGraph$3(TemporalAmount maxRetryTime$2, TimeProvider timeProvider$3, Ctx x0$1) {
        Either either;
        Left left;
        CompletionResponse.CompletionFailure statusNotFound;
        Either either2;
        Left left2;
        CompletionResponse.CompletionFailure completionFailure;
        Either either3;
        Ctx ctx = x0$1;
        if (ctx != null) {
            RetryInfo retryInfo = (RetryInfo)ctx.context();
            Either either4 = (Either)ctx.value();
            if (retryInfo != null) {
                Left left3;
                CompletionResponse.CompletionFailure notOk;
                CommandSubmission value = (CommandSubmission)retryInfo.value();
                int nrOfRetries = retryInfo.nrOfRetries();
                Instant firstSubmissionTime = retryInfo.firstSubmissionTime();
                if (either4 instanceof Left && (notOk = (CompletionResponse.CompletionFailure)(left3 = (Left)either4).value()) instanceof CompletionResponse.NotOkResponse) {
                    CompletionResponse.NotOkResponse notOkResponse = (CompletionResponse.NotOkResponse)notOk;
                    if (MODULE$.RETRYABLE_ERROR_CODES().contains((Object)BoxesRunTime.boxToInteger((int)notOkResponse.grpcStatus().code()))) {
                        if (firstSubmissionTime.plus(maxRetryTime$2).isBefore(timeProvider$3.getCurrentTime())) {
                            RetryLogger$.MODULE$.logStopRetrying(value, notOkResponse.grpcStatus(), nrOfRetries, firstSubmissionTime);
                            return MODULE$.PROPAGATE_PORT();
                        }
                        RetryLogger$.MODULE$.logNonFatal(value, notOkResponse.grpcStatus(), nrOfRetries);
                        return MODULE$.RETRY_PORT();
                    }
                }
            }
        }
        if (ctx != null) {
            RetryInfo retryInfo = (RetryInfo)ctx.context();
            Either either5 = (Either)ctx.value();
            if (retryInfo != null) {
                Left left4;
                CompletionResponse.CompletionFailure notOk;
                CommandSubmission value = (CommandSubmission)retryInfo.value();
                int nrOfRetries = retryInfo.nrOfRetries();
                if (either5 instanceof Left && (notOk = (CompletionResponse.CompletionFailure)(left4 = (Left)either5).value()) instanceof CompletionResponse.NotOkResponse) {
                    CompletionResponse.NotOkResponse notOkResponse = (CompletionResponse.NotOkResponse)notOk;
                    RetryLogger$.MODULE$.logFatal(value, notOkResponse.grpcStatus(), nrOfRetries);
                    return MODULE$.PROPAGATE_PORT();
                }
            }
        }
        if (ctx != null && (either3 = (Either)ctx.value()) instanceof Left && (completionFailure = (CompletionResponse.CompletionFailure)(left2 = (Left)either3).value()) instanceof CompletionResponse.TimeoutResponse) {
            return MODULE$.PROPAGATE_PORT();
        }
        if (ctx != null && (either2 = (Either)ctx.value()) instanceof Left && (statusNotFound = (CompletionResponse.CompletionFailure)(left = (Left)either2).value()) instanceof CompletionResponse.NoStatusInResponse) {
            CompletionResponse.NoStatusInResponse noStatusInResponse = (CompletionResponse.NoStatusInResponse)statusNotFound;
            return MODULE$.statusNotFoundError(noStatusInResponse.commandId());
        }
        if (ctx != null && (either = (Either)ctx.value()) instanceof Right) {
            return MODULE$.PROPAGATE_PORT();
        }
        throw new MatchError((Object)ctx);
    }

    private CommandRetryFlow$() {
    }
}

