/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.client.binding.retrying;

import com.daml.ledger.api.v1.commands.Commands;
import com.daml.ledger.api.validation.CommandsValidator$;
import com.daml.ledger.client.binding.log.Labels$;
import com.daml.ledger.client.services.commands.CommandSubmission;
import com.google.rpc.status.Status;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class RetryLogger$
implements LazyLogging {
    public static final RetryLogger$ MODULE$ = new RetryLogger$();
    private static final String ACT_AS;
    private static final String BIM;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        ACT_AS = "act-as";
        BIM = "bim";
    }

    private Logger logger$lzycompute() {
        RetryLogger$ retryLogger$ = this;
        synchronized (retryLogger$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public void logFatal(CommandSubmission submission, Status status, int nrOfRetries) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringBuilder(88).append("Encountered fatal error when submitting command after ").append(nrOfRetries).append(" retries, therefore retry halted: ").append(this.format(submission.commands(), status)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void logStopRetrying(CommandSubmission submission, Status status, int nrOfRetries, Instant firstSubmissionTime) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringBuilder(63).append("Retrying of command stopped after ").append(nrOfRetries).append(" retries. Attempting since ").append(firstSubmissionTime).append(": ").append(this.format(submission.commands(), status)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void logNonFatal(CommandSubmission submission, Status status, int nrOfRetries) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringBuilder(90).append("Encountered non-fatal error when submitting command after ").append(nrOfRetries).append(" retries, therefore will retry: ").append(this.format(submission.commands(), status)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private String format(Commands commands, Status status) {
        return this.format((Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.BIM(), (Object)commands.commandId()), new Tuple2((Object)this.ACT_AS(), (Object)CommandsValidator$.MODULE$.effectiveSubmitters(commands).actAs()), new Tuple2((Object)Labels$.MODULE$.WORKFLOW_ID(), (Object)commands.workflowId()), new Tuple2((Object)Labels$.MODULE$.ERROR_CODE(), (Object)BoxesRunTime.boxToInteger((int)status.code())), new Tuple2((Object)Labels$.MODULE$.ERROR_MESSAGE(), (Object)status.message()), new Tuple2((Object)Labels$.MODULE$.ERROR_DETAILS(), (Object)status.details().mkString(","))}));
    }

    private String format(Seq<Tuple2<String, Object>> fs) {
        return ((IterableOnceOps)fs.map((Function1 & Serializable)f -> new StringBuilder(3).append(f._1()).append(" = ").append(f._2()).toString())).mkString(", ");
    }

    private String ACT_AS() {
        return ACT_AS;
    }

    private String BIM() {
        return BIM;
    }

    private RetryLogger$() {
    }
}

