/*
 * Decompiled with CFR 0.152.
 */
package com.daml.api.util;

import com.daml.ledger.api.v1.value.Value;
import com.google.protobuf.timestamp.Timestamp;
import com.google.protobuf.timestamp.Timestamp$;
import java.time.Instant;
import java.util.concurrent.TimeUnit;

public final class TimestampConversion$ {
    public static final TimestampConversion$ MODULE$ = new TimestampConversion$();
    private static final Instant MIN = Instant.parse("0001-01-01T00:00:00Z");
    private static final Instant MAX = Instant.parse("9999-12-31T23:59:59.999999Z");

    public Instant MIN() {
        return MIN;
    }

    public Instant MAX() {
        return MAX;
    }

    public Instant microsToInstant(Value.Sum.Timestamp micros) {
        long seconds = TimeUnit.MICROSECONDS.toSeconds(micros.value());
        long deltaMicros = micros.value() - TimeUnit.SECONDS.toMicros(seconds);
        return Instant.ofEpochSecond(seconds, TimeUnit.MICROSECONDS.toNanos(deltaMicros));
    }

    public Value.Sum.Timestamp instantToMicros(Instant t) {
        if (t.getNano() % 1000 != 0) {
            throw new IllegalArgumentException(new StringBuilder(84).append("Conversion of Instant ").append(t).append(" to microsecond granularity would result in loss of precision.").toString());
        }
        return new Value.Sum.Timestamp(TimeUnit.SECONDS.toMicros(t.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(t.getNano()));
    }

    public Instant toInstant(Timestamp protoTimestamp) {
        return Instant.ofEpochSecond(protoTimestamp.seconds(), protoTimestamp.nanos());
    }

    public Timestamp fromInstant(Instant instant) {
        return new Timestamp(Timestamp$.MODULE$.$lessinit$greater$default$1(), Timestamp$.MODULE$.$lessinit$greater$default$2()).withSeconds(instant.getEpochSecond()).withNanos(instant.getNano());
    }

    private TimestampConversion$() {
    }
}

