/*
 * Decompiled with CFR 0.152.
 */
package com.daml.api.util;

import com.daml.api.util.TimestampConversion;
import com.daml.api.util.TimestampConversion$ConversionMode$Exact$;
import com.daml.api.util.TimestampConversion$ConversionMode$HalfUp$;
import com.daml.ledger.api.v1.value.Value;
import com.daml.lf.data.Time;
import com.google.protobuf.timestamp.Timestamp;
import com.google.protobuf.timestamp.Timestamp$;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import scala.MatchError;

public final class TimestampConversion$ {
    public static final TimestampConversion$ MODULE$ = new TimestampConversion$();
    private static final Instant MIN = Instant.parse("0001-01-01T00:00:00Z");
    private static final Instant MAX = Instant.parse("9999-12-31T23:59:59.999999Z");

    public Instant MIN() {
        return MIN;
    }

    public Instant MAX() {
        return MAX;
    }

    public Instant microsToInstant(Value.Sum.Timestamp micros) {
        long seconds = TimeUnit.MICROSECONDS.toSeconds(micros.value());
        long deltaMicros = micros.value() - TimeUnit.SECONDS.toMicros(seconds);
        return Instant.ofEpochSecond(seconds, TimeUnit.MICROSECONDS.toNanos(deltaMicros));
    }

    public Value.Sum.Timestamp instantToMicros(Instant t) {
        if (t.getNano() % 1000 != 0) {
            throw new IllegalArgumentException(new StringBuilder(84).append("Conversion of Instant ").append(t).append(" to microsecond granularity would result in loss of precision.").toString());
        }
        return new Value.Sum.Timestamp(TimeUnit.SECONDS.toMicros(t.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(t.getNano()));
    }

    public Value.Sum.Timestamp roundInstantToMicros(Instant t) {
        return this.instantToMicros(this.roundToMicros(t, TimestampConversion$ConversionMode$HalfUp$.MODULE$));
    }

    public Instant toInstant(Timestamp protoTimestamp) {
        return Instant.ofEpochSecond(protoTimestamp.seconds(), protoTimestamp.nanos());
    }

    public Timestamp fromInstant(Instant instant) {
        return new Timestamp(Timestamp$.MODULE$.$lessinit$greater$default$1(), Timestamp$.MODULE$.$lessinit$greater$default$2(), Timestamp$.MODULE$.$lessinit$greater$default$3()).withSeconds(instant.getEpochSecond()).withNanos(instant.getNano());
    }

    public Time.Timestamp toLf(Timestamp protoTimestamp, TimestampConversion.ConversionMode mode) {
        Instant instant = this.roundToMicros(this.toInstant(protoTimestamp), mode);
        return Time.Timestamp$.MODULE$.assertFromInstant(instant);
    }

    public Timestamp fromLf(Time.Timestamp timestamp) {
        return this.fromInstant(timestamp.toInstant());
    }

    private Instant roundToMicros(Instant t, TimestampConversion.ConversionMode mode) {
        Instant instant;
        long fractionNanos = (long)t.getNano() % 1000L;
        if (fractionNanos != 0L) {
            TimestampConversion.ConversionMode conversionMode = mode;
            if (TimestampConversion$ConversionMode$Exact$.MODULE$.equals(conversionMode)) {
                throw new IllegalArgumentException(new StringBuilder(76).append("Conversion of ").append(t).append(" to microsecond granularity would result in loss of precision.").toString());
            }
            if (!TimestampConversion$ConversionMode$HalfUp$.MODULE$.equals(conversionMode)) {
                throw new MatchError((Object)conversionMode);
            }
            Instant instant2 = t.plusNanos(fractionNanos >= 500L ? 1000L - fractionNanos : -fractionNanos);
            instant = instant2;
        } else {
            instant = t;
        }
        return instant;
    }

    private TimestampConversion$() {
    }
}

