/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.codegen.conf;

import ch.qos.logback.classic.Level;
import com.daml.assistant.config.ConfigLoadError;
import com.daml.assistant.config.ConfigLoadingError;
import com.daml.assistant.config.ConfigMissing;
import com.daml.assistant.config.ConfigParseError;
import com.daml.assistant.config.ProjectConfig;
import com.daml.assistant.config.ProjectConfig$;
import com.daml.lf.codegen.conf.CodegenConfigReader;
import com.daml.lf.codegen.conf.CodegenConfigReader$Java$;
import com.daml.lf.codegen.conf.CodegenConfigReader$Scala$;
import com.daml.lf.codegen.conf.Conf;
import com.daml.lf.codegen.conf.Conf$;
import com.daml.lf.codegen.conf.PackageReference;
import com.daml.lf.data.Ref$;
import io.circe.ACursor;
import io.circe.Decoder$;
import io.circe.KeyDecoder;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

public final class CodegenConfigReader$ {
    public static final CodegenConfigReader$ MODULE$ = new CodegenConfigReader$();
    private static final Path darDirectory = Paths.get(".daml/dist", new String[0]);
    private static final KeyDecoder<PackageReference> decodePackageReference = new KeyDecoder<PackageReference>(){

        public final <B> KeyDecoder<B> map(Function1<PackageReference, B> f) {
            return KeyDecoder.map$((KeyDecoder)this, f);
        }

        public final <B> KeyDecoder<B> flatMap(Function1<PackageReference, KeyDecoder<B>> f) {
            return KeyDecoder.flatMap$((KeyDecoder)this, f);
        }

        public final Option<PackageReference> apply(String key) {
            return this.nameVersion(key);
        }

        private Option<PackageReference> nameVersion(String key) {
            None$ none$;
            Object object;
            String[] stringArray = key.split("-");
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                String name2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String version = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                none$ = Ref$.MODULE$.PackageName().fromString(name2).toOption().flatMap((Function1 & Serializable)name -> Ref$.MODULE$.PackageVersion().fromString(version).toOption().map((Function1 & Serializable)version -> new PackageReference.NameVersion((String)name, (String)version)));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }
        {
            KeyDecoder.$init$((KeyDecoder)this);
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$nameVersion$1(java.lang.String java.lang.String ), $anonfun$nameVersion$2(java.lang.String java.lang.String )}, serializedLambda);
        }
    };

    public Either<ConfigLoadingError, Conf> readFromEnv(CodegenConfigReader.CodegenDest dest) {
        return ProjectConfig$.MODULE$.loadFromEnv().flatMap((Function1 & Serializable)sdkConf -> MODULE$.codegenConf((ProjectConfig)sdkConf, dest).map((Function1 & Serializable)codegenConf -> codegenConf));
    }

    public Either<ConfigLoadingError, Conf> codegenConf(ProjectConfig sdkConf, CodegenConfigReader.CodegenDest dest) {
        return this.darPath(sdkConf).flatMap((Function1 & Serializable)dar -> MODULE$.packagePrefix(sdkConf, dest).flatMap((Function1 & Serializable)packagePrefix -> MODULE$.modulePrefixes(sdkConf).flatMap((Function1 & Serializable)modulePrefixes -> MODULE$.outputDirectory(sdkConf, dest).flatMap((Function1 & Serializable)outputDirectory -> MODULE$.decoderPkgAndClass(sdkConf, dest).flatMap((Function1 & Serializable)decoderPkgAndClass -> MODULE$.verbosity(sdkConf, dest).flatMap((Function1 & Serializable)verbosity -> MODULE$.logLevel((Option<Object>)verbosity, Level.ERROR).flatMap((Function1 & Serializable)logLevel -> MODULE$.root(sdkConf, dest).map((Function1 & Serializable)root -> {
            Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(dar), packagePrefix)}));
            Map x$2 = modulePrefixes;
            Path x$3 = outputDirectory;
            Option x$4 = decoderPkgAndClass;
            Level x$5 = logLevel;
            List x$6 = (List)root.getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil());
            return new Conf((Map<Path, Option<String>>)x$1, x$3, (Map<PackageReference, String>)x$2, (Option<Tuple2<String, String>>)x$4, x$5, (List<String>)x$6);
        }))))))));
    }

    private Either<ConfigLoadingError, Path> darPath(ProjectConfig sdkConf) {
        return this.name(sdkConf).flatMap((Function1 & Serializable)name -> MODULE$.version(sdkConf).flatMap((Function1 & Serializable)version -> MODULE$.darPath(sdkConf.projectPath(), (String)name, (String)version).map((Function1 & Serializable)dar -> dar)));
    }

    private Either<ConfigLoadingError, String> name(ProjectConfig sdkConf) {
        return sdkConf.name().flatMap((Function1 & Serializable)x0$1 -> {
            Right right;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                String a = (String)some.value();
                right = package$.MODULE$.Right().apply((Object)a);
            } else if (None$.MODULE$.equals(option)) {
                right = package$.MODULE$.Left().apply((Object)new ConfigMissing("name"));
            } else {
                throw new MatchError((Object)option);
            }
            return right;
        });
    }

    private Either<ConfigLoadingError, String> version(ProjectConfig sdkConf) {
        return sdkConf.version().flatMap((Function1 & Serializable)x0$1 -> {
            Right right;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                String a = (String)some.value();
                right = package$.MODULE$.Right().apply((Object)a);
            } else if (None$.MODULE$.equals(option)) {
                right = package$.MODULE$.Left().apply((Object)new ConfigMissing("version"));
            } else {
                throw new MatchError((Object)option);
            }
            return right;
        });
    }

    private Either<ConfigLoadingError, Path> darPath(Path projectPath, String name, String version) {
        return this.result((Function0 & Serializable)() -> projectPath.resolve(MODULE$.darDirectory()).resolve(new StringBuilder(5).append(name).append("-").append(version).append(".dar").toString()));
    }

    private Path darDirectory() {
        return darDirectory;
    }

    private Either<ConfigLoadingError, Option<String>> packagePrefix(ProjectConfig sdkConf, CodegenConfigReader.CodegenDest mode) {
        return this.codegen(sdkConf, mode).downField("package-prefix").as(Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString())).left().map((Function1 & Serializable)e -> MODULE$.configParseError((Exception)e));
    }

    private Either<ConfigLoadingError, Map<PackageReference, String>> modulePrefixes(ProjectConfig sdkConf) {
        return sdkConf.content().hcursor().downField("module-prefixes").as(Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeMap(this.decodePackageReference(), Decoder$.MODULE$.decodeString()))).map((Function1 & Serializable)x$1 -> (Map)x$1.getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).left().map((Function1 & Serializable)e -> MODULE$.configParseError((Exception)e));
    }

    private Either<ConfigLoadingError, Path> outputDirectory(ProjectConfig sdkConf, CodegenConfigReader.CodegenDest mode) {
        return this.codegen(sdkConf, mode).downField("output-directory").as(Decoder$.MODULE$.decodeString()).left().map((Function1 & Serializable)e -> MODULE$.configParseError((Exception)e)).flatMap((Function1 & Serializable)a -> MODULE$.path((String)a));
    }

    private Either<ConfigLoadingError, Option<Tuple2<String, String>>> decoderPkgAndClass(ProjectConfig sdkConf, CodegenConfigReader.CodegenDest mode) {
        return this.codegen(sdkConf, mode).downField("decoderClass").as(Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString())).left().map((Function1 & Serializable)e -> MODULE$.configParseError((Exception)e)).flatMap((Function1 & Serializable)fa -> MODULE$.decoderClass((Option<String>)fa));
    }

    private Either<ConfigLoadingError, Option<Tuple2<String, String>>> decoderClass(Option<String> fa) {
        Either either;
        Option<String> option = fa;
        if (option instanceof Some) {
            Some some = (Some)option;
            String a = (String)some.value();
            either = this.decoderClass(a).map((Function1 & Serializable)x$2 -> new Some(x$2));
        } else if (None$.MODULE$.equals(option)) {
            either = this.resultR(None$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    private Either<ConfigLoadingError, Tuple2<String, String>> decoderClass(String s) {
        return this.result((Function0 & Serializable)() -> (Tuple2)Conf$.MODULE$.readClassName().reads().apply((Object)s));
    }

    private Either<ConfigLoadingError, Option<Object>> verbosity(ProjectConfig sdkConf, CodegenConfigReader.CodegenDest mode) {
        return this.codegen(sdkConf, mode).downField("verbosity").as(Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeInt())).left().map((Function1 & Serializable)e -> MODULE$.configParseError((Exception)e));
    }

    private Either<ConfigLoadingError, Level> logLevel(Option<Object> fa, Level level) {
        return (Either)fa.fold((Function0 & Serializable)() -> MODULE$.resultR(level), (Function1 & Serializable)a -> CodegenConfigReader$.MODULE$.readVerbosity(BoxesRunTime.unboxToInt((Object)a)));
    }

    private Either<ConfigLoadingError, Level> readVerbosity(int a) {
        return this.result((Function0 & Serializable)() -> (Level)Conf$.MODULE$.readVerbosity().reads().apply((Object)Integer.toString(a)));
    }

    private Either<ConfigLoadingError, Option<List<String>>> root(ProjectConfig sdkConf, CodegenConfigReader.CodegenDest mode) {
        return this.codegen(sdkConf, mode).downField("root").as(Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeString()))).left().map((Function1 & Serializable)e -> MODULE$.configParseError((Exception)e));
    }

    private ACursor codegen(ProjectConfig sdkConf, CodegenConfigReader.CodegenDest mode) {
        return sdkConf.content().hcursor().downField("codegen").downField(this.dest(mode));
    }

    private String dest(CodegenConfigReader.CodegenDest a) {
        String string;
        CodegenConfigReader.CodegenDest codegenDest = a;
        if (CodegenConfigReader$Java$.MODULE$.equals(codegenDest)) {
            string = "java";
        } else if (CodegenConfigReader$Scala$.MODULE$.equals(codegenDest)) {
            string = "scala";
        } else {
            throw new MatchError((Object)codegenDest);
        }
        return string;
    }

    private Either<ConfigLoadingError, Path> path(String a) {
        return this.result((Function0 & Serializable)() -> new File(a).toPath());
    }

    private ConfigParseError configParseError(Exception e) {
        return new ConfigParseError(e.getMessage());
    }

    private <A> Either<ConfigLoadingError, A> result(Function0<A> a) {
        return this.result(Try$.MODULE$.apply(a));
    }

    private <A> Either<ConfigLoadingError, A> result(Try<A> fa) {
        return fa.toEither().left().map((Function1 & Serializable)e -> new ConfigLoadError(e.getMessage()));
    }

    private <A> Either<ConfigLoadingError, A> resultR(A a) {
        return package$.MODULE$.Right().apply(a);
    }

    public KeyDecoder<PackageReference> decodePackageReference() {
        return decodePackageReference;
    }

    private CodegenConfigReader$() {
    }
}

