/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Insertion;
import scenelib.type.Type;

public class CastInsertion
extends Insertion {
    private Type type;
    public boolean onArrayLiteral = false;

    public CastInsertion(Criteria criteria, Type type) {
        super(criteria, false);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    protected void setType(Type t) {
        this.type = t;
    }

    @Override
    protected String getText(boolean comments, boolean abbreviate) {
        String result2 = this.onArrayLiteral ? "((new " + this.typeToString(this.type, comments, abbreviate) + " " : "((" + this.typeToString(this.type, comments, abbreviate) + ") (";
        return result2;
    }

    @Override
    protected boolean addLeadingSpace(boolean gotSeparateLine, int pos, char precedingChar) {
        return super.addLeadingSpace(gotSeparateLine, pos, precedingChar) && precedingChar != '[';
    }

    @Override
    protected boolean addTrailingSpace(boolean gotSeparateLine) {
        return false;
    }

    public boolean isOnArrayLiteral() {
        return this.onArrayLiteral;
    }

    public void setOnArrayLiteral(boolean onArrayLiteral) {
        this.onArrayLiteral = onArrayLiteral;
    }

    @Override
    public Insertion.Kind getKind() {
        return Insertion.Kind.CAST;
    }
}

