/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Criterion;
import annotator.scanner.CommonScanner;
import annotator.scanner.InitBlockScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

public class InInitBlockCriterion
implements Criterion {
    public final int blockID;
    public final boolean isStatic;
    public final Criterion notInMethodCriterion;

    public InInitBlockCriterion(int blockID, boolean isStatic) {
        this.blockID = blockID;
        this.isStatic = isStatic;
        this.notInMethodCriterion = Criteria.notInMethod();
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        while (path != null) {
            if (CommonScanner.isInitBlock(path, this.isStatic)) {
                int indexInSource = InitBlockScanner.indexOfInitTree(path, this.isStatic);
                return indexInSource == this.blockID;
            }
            path = path.getParentPath();
        }
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return this.isStatic ? Criterion.Kind.IN_STATIC_INIT : Criterion.Kind.IN_INSTANCE_INIT;
    }

    public String toString() {
        return "In " + (this.isStatic ? "static" : "instance") + " initializer with index " + this.blockID;
    }
}

